/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLScalarType;
import graphql.schema.TypeResolver;
import graphql.schema.idl.NoopWiringFactory;
import graphql.schema.idl.ScalarInfo;
import graphql.schema.idl.TypeRuntimeWiring;
import graphql.schema.idl.WiringFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.UnaryOperator;

@PublicApi
public class RuntimeWiring {
    private final Map<String, Map<String, DataFetcher>> dataFetchers;
    private final Map<String, GraphQLScalarType> scalars;
    private final Map<String, TypeResolver> typeResolvers;
    private final WiringFactory wiringFactory;

    private RuntimeWiring(Map<String, Map<String, DataFetcher>> dataFetchers, Map<String, GraphQLScalarType> scalars, Map<String, TypeResolver> typeResolvers, WiringFactory wiringFactory) {
        this.dataFetchers = dataFetchers;
        this.scalars = scalars;
        this.typeResolvers = typeResolvers;
        this.wiringFactory = wiringFactory;
    }

    public Map<String, GraphQLScalarType> getScalars() {
        return new LinkedHashMap<String, GraphQLScalarType>(this.scalars);
    }

    public Map<String, Map<String, DataFetcher>> getDataFetchers() {
        return this.dataFetchers;
    }

    public Map<String, DataFetcher> getDataFetcherForType(String typeName) {
        return this.dataFetchers.computeIfAbsent(typeName, k -> new LinkedHashMap());
    }

    public Map<String, TypeResolver> getTypeResolvers() {
        return this.typeResolvers;
    }

    public WiringFactory getWiringFactory() {
        return this.wiringFactory;
    }

    public static Builder newRuntimeWiring() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private final Map<String, Map<String, DataFetcher>> dataFetchers = new LinkedHashMap<String, Map<String, DataFetcher>>();
        private final Map<String, GraphQLScalarType> scalars = new LinkedHashMap<String, GraphQLScalarType>();
        private final Map<String, TypeResolver> typeResolvers = new LinkedHashMap<String, TypeResolver>();
        private WiringFactory wiringFactory = new NoopWiringFactory();

        private Builder() {
            ScalarInfo.STANDARD_SCALARS.forEach(this::scalar);
        }

        public Builder wiringFactory(WiringFactory wiringFactory) {
            Assert.assertNotNull(wiringFactory, "You must provide a wiring factory");
            this.wiringFactory = wiringFactory;
            return this;
        }

        public Builder scalar(GraphQLScalarType scalarType) {
            this.scalars.put(scalarType.getName(), scalarType);
            return this;
        }

        public Builder type(TypeRuntimeWiring.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(String typeName, UnaryOperator<TypeRuntimeWiring.Builder> builderFunction) {
            TypeRuntimeWiring.Builder builder = (TypeRuntimeWiring.Builder)builderFunction.apply(TypeRuntimeWiring.newTypeWiring(typeName));
            return this.type(builder.build());
        }

        public Builder type(TypeRuntimeWiring typeRuntimeWiring) {
            String typeName = typeRuntimeWiring.getTypeName();
            Map typeDataFetchers = this.dataFetchers.computeIfAbsent(typeName, k -> new LinkedHashMap());
            typeRuntimeWiring.getFieldDataFetchers().forEach(typeDataFetchers::put);
            TypeResolver typeResolver = typeRuntimeWiring.getTypeResolver();
            if (typeResolver != null) {
                this.typeResolvers.put(typeName, typeResolver);
            }
            return this;
        }

        public RuntimeWiring build() {
            return new RuntimeWiring(this.dataFetchers, this.scalars, this.typeResolvers, this.wiringFactory);
        }
    }
}

