/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.language.AstPrinter;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.Node;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeExtensionDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.errors.InterfaceFieldArgumentRedefinitionError;
import graphql.schema.idl.errors.InterfaceFieldRedefinitionError;
import graphql.schema.idl.errors.MissingInterfaceFieldArgumentsError;
import graphql.schema.idl.errors.MissingInterfaceFieldError;
import graphql.schema.idl.errors.MissingInterfaceTypeError;
import graphql.schema.idl.errors.MissingScalarImplementationError;
import graphql.schema.idl.errors.MissingTypeError;
import graphql.schema.idl.errors.MissingTypeResolverError;
import graphql.schema.idl.errors.OperationTypesMustBeObjects;
import graphql.schema.idl.errors.QueryOperationMissingError;
import graphql.schema.idl.errors.SchemaMissingError;
import graphql.schema.idl.errors.SchemaProblem;
import graphql.schema.idl.errors.TypeExtensionFieldRedefinitionError;
import graphql.schema.idl.errors.TypeExtensionMissingBaseTypeError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SchemaTypeChecker {
    public List<GraphQLError> checkTypeRegistry(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) throws SchemaProblem {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        this.checkForMissingTypes(errors, typeRegistry);
        this.checkTypeExtensionsHaveCorrespondingType(errors, typeRegistry);
        this.checkTypeExtensionsFieldRedefinition(errors, typeRegistry);
        this.checkInterfacesAreImplemented(errors, typeRegistry);
        this.checkSchemaInvariants(errors, typeRegistry);
        this.checkScalarImplementationsArePresent(errors, typeRegistry, wiring);
        this.checkTypeResolversArePresent(errors, typeRegistry, wiring);
        return errors;
    }

    private void checkSchemaInvariants(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        if (!typeRegistry.schemaDefinition().isPresent()) {
            errors.add(new SchemaMissingError());
        } else {
            SchemaDefinition schemaDefinition = typeRegistry.schemaDefinition().get();
            List<OperationTypeDefinition> operationTypeDefinitions = schemaDefinition.getOperationTypeDefinitions();
            operationTypeDefinitions.forEach(this.checkOperationTypesExist(typeRegistry, errors));
            operationTypeDefinitions.forEach(this.checkOperationTypesAreObjects(typeRegistry, errors));
            Optional<OperationTypeDefinition> query = operationTypeDefinitions.stream().filter(op -> "query".equals(op.getName())).findFirst();
            if (!query.isPresent()) {
                errors.add(new QueryOperationMissingError());
            }
        }
    }

    private void checkForMissingTypes(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        List<TypeExtensionDefinition> typeExtensions = typeRegistry.typeExtensions().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        typeExtensions.forEach(typeExtension -> {
            List<Type> implementsTypes = typeExtension.getImplements();
            implementsTypes.forEach(this.checkInterfaceTypeExists(typeRegistry, errors, (TypeDefinition)typeExtension));
            this.checkFieldTypesPresent(typeRegistry, errors, (TypeDefinition)typeExtension, typeExtension.getFieldDefinitions());
        });
        Map<String, TypeDefinition> typesMap = typeRegistry.types();
        List<ObjectTypeDefinition> objectTypes = this.filterTo(typesMap, ObjectTypeDefinition.class);
        objectTypes.forEach(objectType -> {
            List<Type> implementsTypes = objectType.getImplements();
            implementsTypes.forEach(this.checkInterfaceTypeExists(typeRegistry, errors, (TypeDefinition)objectType));
            this.checkFieldTypesPresent(typeRegistry, errors, (TypeDefinition)objectType, objectType.getFieldDefinitions());
        });
        List<InterfaceTypeDefinition> interfaceTypes = this.filterTo(typesMap, InterfaceTypeDefinition.class);
        interfaceTypes.forEach(interfaceType -> {
            List<FieldDefinition> fields = interfaceType.getFieldDefinitions();
            this.checkFieldTypesPresent(typeRegistry, errors, (TypeDefinition)interfaceType, fields);
        });
        List<UnionTypeDefinition> unionTypes = this.filterTo(typesMap, UnionTypeDefinition.class);
        unionTypes.forEach(unionType -> {
            List<Type> memberTypes = unionType.getMemberTypes();
            memberTypes.forEach(this.checkTypeExists("union member", typeRegistry, errors, (TypeDefinition)unionType));
        });
        List<InputObjectTypeDefinition> inputTypes = this.filterTo(typesMap, InputObjectTypeDefinition.class);
        inputTypes.forEach(inputType -> {
            List<InputValueDefinition> inputValueDefinitions = inputType.getInputValueDefinitions();
            List<Type> inputValueTypes = inputValueDefinitions.stream().map(InputValueDefinition::getType).collect(Collectors.toList());
            inputValueTypes.forEach(this.checkTypeExists("input value", typeRegistry, errors, (TypeDefinition)inputType));
        });
    }

    private void checkScalarImplementationsArePresent(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) {
        typeRegistry.scalars().keySet().forEach(scalarName -> {
            if (!wiring.getScalars().containsKey(scalarName)) {
                errors.add(new MissingScalarImplementationError((String)scalarName));
            }
        });
    }

    private void checkTypeResolversArePresent(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) {
        Predicate<InterfaceTypeDefinition> noDynamicResolverForInterface = interaceTypeDef -> !wiring.getWiringFactory().providesTypeResolver(typeRegistry, (InterfaceTypeDefinition)interaceTypeDef);
        Predicate<UnionTypeDefinition> noDynamicResolverForUnion = unionTypeDef -> !wiring.getWiringFactory().providesTypeResolver(typeRegistry, (UnionTypeDefinition)unionTypeDef);
        Predicate<TypeDefinition> noTypeResolver = typeDefinition -> !wiring.getTypeResolvers().containsKey(typeDefinition.getName());
        Consumer<TypeDefinition> addError = typeDefinition -> errors.add(new MissingTypeResolverError((TypeDefinition)typeDefinition));
        typeRegistry.types().values().stream().filter(typeDef -> typeDef instanceof InterfaceTypeDefinition).map(InterfaceTypeDefinition.class::cast).filter(noDynamicResolverForInterface).filter(noTypeResolver).forEach(addError);
        typeRegistry.types().values().stream().filter(typeDef -> typeDef instanceof UnionTypeDefinition).map(UnionTypeDefinition.class::cast).filter(noDynamicResolverForUnion).filter(noTypeResolver).forEach(addError);
    }

    private void checkFieldTypesPresent(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors, TypeDefinition typeDefinition, List<FieldDefinition> fields) {
        List<Type> fieldTypes = fields.stream().map(FieldDefinition::getType).collect(Collectors.toList());
        fieldTypes.forEach(this.checkTypeExists("field", typeRegistry, errors, typeDefinition));
        List<Type> fieldInputValues = fields.stream().map(f -> f.getInputValueDefinitions().stream().map(InputValueDefinition::getType).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        fieldInputValues.forEach(this.checkTypeExists("field input", typeRegistry, errors, typeDefinition));
    }

    private Consumer<Type> checkTypeExists(String typeOfType, TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors, TypeDefinition typeDefinition) {
        return t -> {
            TypeName unwrapped = TypeInfo.typeInfo(t).getTypeName();
            if (!typeRegistry.hasType(unwrapped)) {
                errors.add(new MissingTypeError(typeOfType, typeDefinition, unwrapped));
            }
        };
    }

    private Consumer<? super Type> checkInterfaceTypeExists(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors, TypeDefinition typeDefinition) {
        return t -> {
            TypeInfo typeInfo = TypeInfo.typeInfo(t);
            TypeName unwrapped = typeInfo.getTypeName();
            Optional<TypeDefinition> type = typeRegistry.getType(unwrapped);
            if (!type.isPresent()) {
                errors.add(new MissingInterfaceTypeError("interface", typeDefinition, unwrapped));
            } else if (!(type.get() instanceof InterfaceTypeDefinition)) {
                errors.add(new MissingInterfaceTypeError("interface", typeDefinition, unwrapped));
            }
        };
    }

    private void checkInterfacesAreImplemented(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        Map<String, TypeDefinition> typesMap = typeRegistry.types();
        List<ObjectTypeDefinition> objectTypes = this.filterTo(typesMap, ObjectTypeDefinition.class);
        objectTypes.forEach(objectType -> {
            List<Type> implementsTypes = objectType.getImplements();
            implementsTypes.forEach(this.checkInterfaceIsImplemented("object", typeRegistry, errors, (ObjectTypeDefinition)objectType));
        });
        Map<String, List<TypeExtensionDefinition>> typeExtensions = typeRegistry.typeExtensions();
        typeExtensions.values().forEach(extList -> extList.forEach(typeExtension -> {
            List<Type> implementsTypes = typeExtension.getImplements();
            implementsTypes.forEach(this.checkInterfaceIsImplemented("extension", typeRegistry, errors, (ObjectTypeDefinition)typeExtension));
        }));
    }

    private Consumer<? super Type> checkInterfaceIsImplemented(String typeOfType, TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors, ObjectTypeDefinition objectTypeDef) {
        return t -> {
            TypeInfo typeInfo = TypeInfo.typeInfo(t);
            TypeName unwrapped = typeInfo.getTypeName();
            Optional<TypeDefinition> type = typeRegistry.getType(unwrapped);
            if (type.isPresent() && type.get() instanceof InterfaceTypeDefinition) {
                InterfaceTypeDefinition interfaceTypeDef = (InterfaceTypeDefinition)type.get();
                Map objectFields = objectTypeDef.getFieldDefinitions().stream().collect(Collectors.toMap(FieldDefinition::getName, Function.identity()));
                interfaceTypeDef.getFieldDefinitions().forEach(interfaceFieldDef -> {
                    FieldDefinition objectFieldDef = (FieldDefinition)objectFields.get(interfaceFieldDef.getName());
                    if (objectFieldDef == null) {
                        errors.add(new MissingInterfaceFieldError(typeOfType, objectTypeDef, interfaceTypeDef, (FieldDefinition)interfaceFieldDef));
                    } else {
                        String objectFieldType;
                        String interfaceFieldType = AstPrinter.printAst(interfaceFieldDef.getType());
                        if (!interfaceFieldType.equals(objectFieldType = AstPrinter.printAst(objectFieldDef.getType()))) {
                            errors.add(new InterfaceFieldRedefinitionError(typeOfType, objectTypeDef, interfaceTypeDef, objectFieldDef, objectFieldType, interfaceFieldType));
                        }
                        List<InputValueDefinition> objectArgs = objectFieldDef.getInputValueDefinitions();
                        List<InputValueDefinition> interfaceArgs = interfaceFieldDef.getInputValueDefinitions();
                        if (objectArgs.size() != interfaceArgs.size()) {
                            errors.add(new MissingInterfaceFieldArgumentsError(typeOfType, objectTypeDef, interfaceTypeDef, objectFieldDef));
                        } else {
                            this.checkArgumentConsistency(typeOfType, objectTypeDef, interfaceTypeDef, objectFieldDef, (FieldDefinition)interfaceFieldDef, errors);
                        }
                    }
                });
            }
        };
    }

    private void checkArgumentConsistency(String typeOfType, ObjectTypeDefinition objectTypeDef, InterfaceTypeDefinition interfaceTypeDef, FieldDefinition objectFieldDef, FieldDefinition interfaceFieldDef, List<GraphQLError> errors) {
        List<InputValueDefinition> objectArgs = objectFieldDef.getInputValueDefinitions();
        List<InputValueDefinition> interfaceArgs = interfaceFieldDef.getInputValueDefinitions();
        for (int i = 0; i < interfaceArgs.size(); ++i) {
            String objectArgStr;
            InputValueDefinition interfaceArg = interfaceArgs.get(i);
            InputValueDefinition objectArg = objectArgs.get(i);
            String interfaceArgStr = AstPrinter.printAst(interfaceArg);
            if (interfaceArgStr.equals(objectArgStr = AstPrinter.printAst(objectArg))) continue;
            errors.add(new InterfaceFieldArgumentRedefinitionError(typeOfType, objectTypeDef, interfaceTypeDef, objectFieldDef, objectArgStr, interfaceArgStr));
        }
    }

    private void checkTypeExtensionsFieldRedefinition(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        Map<String, List<TypeExtensionDefinition>> typeExtensions = typeRegistry.typeExtensions();
        typeExtensions.values().forEach(extList -> extList.forEach(typeExtension -> {
            for (TypeExtensionDefinition otherTypeExt : extList) {
                if (otherTypeExt == typeExtension) continue;
                this.checkForFieldRedefinition(errors, otherTypeExt, otherTypeExt.getFieldDefinitions(), typeExtension.getFieldDefinitions());
            }
            Optional<TypeDefinition> type = typeRegistry.getType(typeExtension.getName());
            if (type.isPresent() && type.get() instanceof ObjectTypeDefinition) {
                ObjectTypeDefinition baseType = (ObjectTypeDefinition)type.get();
                this.checkForFieldRedefinition(errors, (TypeDefinition)typeExtension, typeExtension.getFieldDefinitions(), baseType.getFieldDefinitions());
            }
        }));
    }

    private void checkForFieldRedefinition(List<GraphQLError> errors, TypeDefinition typeDefinition, List<FieldDefinition> fieldDefinitions, List<FieldDefinition> referenceFieldDefinitions) {
        Map referenceFields = referenceFieldDefinitions.stream().collect(Collectors.toMap(FieldDefinition::getName, Function.identity()));
        fieldDefinitions.forEach(fld -> {
            FieldDefinition referenceField = (FieldDefinition)referenceFields.get(fld.getName());
            if (referenceFields.containsKey(fld.getName()) && !this.isSameType(fld.getType(), referenceField.getType())) {
                errors.add(new TypeExtensionFieldRedefinitionError(typeDefinition, (FieldDefinition)fld));
            }
        });
    }

    private boolean isSameType(Type type1, Type type2) {
        String s1 = AstPrinter.printAst(type1);
        String s2 = AstPrinter.printAst(type2);
        return s1.equals(s2);
    }

    private void checkTypeExtensionsHaveCorrespondingType(List<GraphQLError> errors, TypeDefinitionRegistry typeRegistry) {
        Map<String, List<TypeExtensionDefinition>> typeExtensions = typeRegistry.typeExtensions();
        typeExtensions.forEach((name, extTypeList) -> {
            TypeExtensionDefinition extensionDefinition = (TypeExtensionDefinition)extTypeList.get(0);
            Optional<TypeDefinition> typeDefinition = typeRegistry.getType(new TypeName((String)name));
            if (!typeDefinition.isPresent()) {
                errors.add(new TypeExtensionMissingBaseTypeError(extensionDefinition));
            } else if (!(typeDefinition.get() instanceof ObjectTypeDefinition)) {
                errors.add(new TypeExtensionMissingBaseTypeError(extensionDefinition));
            }
        });
    }

    private Consumer<OperationTypeDefinition> checkOperationTypesExist(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors) {
        return op -> {
            TypeName unwrapped = TypeInfo.typeInfo(op.getType()).getTypeName();
            if (!typeRegistry.hasType(unwrapped)) {
                errors.add(new MissingTypeError("operation", (Node)op, op.getName(), unwrapped));
            }
        };
    }

    private Consumer<OperationTypeDefinition> checkOperationTypesAreObjects(TypeDefinitionRegistry typeRegistry, List<GraphQLError> errors) {
        return op -> {
            Type queryType = op.getType();
            Optional<TypeDefinition> type = typeRegistry.getType(queryType);
            type.ifPresent(typeDef -> {
                if (!(typeDef instanceof ObjectTypeDefinition)) {
                    errors.add(new OperationTypesMustBeObjects((OperationTypeDefinition)op));
                }
            });
        };
    }

    private <T extends TypeDefinition> List<T> filterTo(Map<String, TypeDefinition> types, Class<? extends T> clazz) {
        return types.values().stream().filter(t -> clazz.equals(t.getClass())).map(clazz::cast).collect(Collectors.toList());
    }
}

