/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidationErrorCollector;
import graphql.schema.validation.SchemaValidationErrorType;
import graphql.schema.validation.SchemaValidationRule;
import java.util.List;
import java.util.Objects;

public class ObjectsImplementInterfaces
implements SchemaValidationRule {
    @Override
    public void check(GraphQLFieldDefinition fieldDef, SchemaValidationErrorCollector validationErrorCollector) {
    }

    @Override
    public void check(GraphQLType type, SchemaValidationErrorCollector validationErrorCollector) {
        if (type instanceof GraphQLObjectType) {
            this.check((GraphQLObjectType)type, validationErrorCollector);
        }
    }

    private void check(GraphQLObjectType objectTyoe, SchemaValidationErrorCollector validationErrorCollector) {
        List<GraphQLOutputType> interfaces = objectTyoe.getInterfaces();
        interfaces.forEach(interfaceType -> this.checkObjectImplementsInterface(objectTyoe, (GraphQLInterfaceType)interfaceType, validationErrorCollector));
    }

    private void checkObjectImplementsInterface(GraphQLObjectType objectTyoe, GraphQLInterfaceType interfaceType, SchemaValidationErrorCollector validationErrorCollector) {
        List<GraphQLFieldDefinition> fieldDefinitions = interfaceType.getFieldDefinitions();
        for (GraphQLFieldDefinition interfaceFieldDef : fieldDefinitions) {
            GraphQLFieldDefinition objectFieldDef = objectTyoe.getFieldDefinition(interfaceFieldDef.getName());
            if (objectFieldDef == null) {
                validationErrorCollector.addError(this.error(String.format("object type '%s' does not implement interface '%s' because field '%s' is missing", objectTyoe.getName(), interfaceType.getName(), interfaceFieldDef.getName())));
                continue;
            }
            this.checkFieldTypeEquivalence(objectTyoe, interfaceType, validationErrorCollector, interfaceFieldDef, objectFieldDef);
        }
    }

    private void checkFieldTypeEquivalence(GraphQLObjectType objectTyoe, GraphQLInterfaceType interfaceType, SchemaValidationErrorCollector validationErrorCollector, GraphQLFieldDefinition interfaceFieldDef, GraphQLFieldDefinition objectFieldDef) {
        String objectFieldDefStr;
        String interfaceFieldDefStr = GraphQLTypeUtil.getUnwrappedTypeName(interfaceFieldDef.getType());
        if (!interfaceFieldDefStr.equals(objectFieldDefStr = GraphQLTypeUtil.getUnwrappedTypeName(objectFieldDef.getType()))) {
            validationErrorCollector.addError(this.error(String.format("object type '%s' does not implement interface '%s' because field '%s' is defined as '%s' type and not as '%s' type", objectTyoe.getName(), interfaceType.getName(), interfaceFieldDef.getName(), objectFieldDefStr, interfaceFieldDefStr)));
        } else {
            this.checkFieldArgumentEquivalence(objectTyoe, interfaceType, validationErrorCollector, interfaceFieldDef, objectFieldDef);
        }
    }

    private void checkFieldArgumentEquivalence(GraphQLObjectType objectTyoe, GraphQLInterfaceType interfaceType, SchemaValidationErrorCollector validationErrorCollector, GraphQLFieldDefinition interfaceFieldDef, GraphQLFieldDefinition objectFieldDef) {
        List<GraphQLArgument> interfaceArgs = interfaceFieldDef.getArguments();
        List<GraphQLArgument> objectArgs = objectFieldDef.getArguments();
        if (interfaceArgs.size() != objectArgs.size()) {
            validationErrorCollector.addError(this.error(String.format("object type '%s' does not implement interface '%s' because field '%s' has a different number of arguments", objectTyoe.getName(), interfaceType.getName(), interfaceFieldDef.getName())));
        } else {
            for (int i = 0; i < interfaceArgs.size(); ++i) {
                GraphQLArgument interfaceArg = interfaceArgs.get(i);
                GraphQLArgument objectArg = objectArgs.get(i);
                String interfaceArgStr = this.makeArgStr(interfaceArg);
                String objectArgStr = this.makeArgStr(objectArg);
                boolean same = true;
                if (!interfaceArgStr.equals(objectArgStr)) {
                    same = false;
                }
                if (!Objects.equals(interfaceArg.getDefaultValue(), objectArg.getDefaultValue())) {
                    same = false;
                }
                if (same) continue;
                validationErrorCollector.addError(this.error(String.format("object type '%s' does not implement interface '%s' because field '%s' argument '%s' is defined differently", objectTyoe.getName(), interfaceType.getName(), interfaceFieldDef.getName(), interfaceArg.getName())));
            }
        }
    }

    private String makeArgStr(GraphQLArgument argument) {
        return argument.getName() + ":" + GraphQLTypeUtil.getUnwrappedTypeName(argument.getType());
    }

    private SchemaValidationError error(String msg) {
        return new SchemaValidationError(SchemaValidationErrorType.ObjectDoesNotImplementItsInterfaces, msg);
    }
}

