/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.language.Node;
import graphql.validation.QueryLanguageVisitor;
import java.util.ArrayList;
import java.util.List;

public class LanguageTraversal {
    private final List<Node> path;

    public LanguageTraversal() {
        this.path = new ArrayList<Node>();
    }

    public LanguageTraversal(List<Node> basePath) {
        this.path = basePath != null ? basePath : new ArrayList<Node>();
    }

    public void traverse(Node root, QueryLanguageVisitor queryLanguageVisitor) {
        this.traverseImpl(root, queryLanguageVisitor, this.path);
    }

    private void traverseImpl(Node root, QueryLanguageVisitor queryLanguageVisitor, List<Node> path) {
        queryLanguageVisitor.enter(root, path);
        path.add(root);
        for (Node child : root.getChildren()) {
            this.traverseImpl(child, queryLanguageVisitor, path);
        }
        path.remove(path.size() - 1);
        queryLanguageVisitor.leave(root, path);
    }
}

