/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;

public class MonthDaySerializer
extends JSR310FormattedSerializerBase<MonthDay> {
    private static final long serialVersionUID = 1L;
    public static final MonthDaySerializer INSTANCE = new MonthDaySerializer();

    private MonthDaySerializer() {
        this((DateTimeFormatter)null);
    }

    public MonthDaySerializer(DateTimeFormatter formatter) {
        super(MonthDay.class, formatter);
    }

    private MonthDaySerializer(MonthDaySerializer base, Boolean useTimestamp, DateTimeFormatter formatter) {
        super(base, useTimestamp, formatter);
    }

    protected MonthDaySerializer withFormat(Boolean useTimestamp, DateTimeFormatter formatter) {
        return new MonthDaySerializer(this, useTimestamp, formatter);
    }

    @Override
    public void serialize(MonthDay value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (this._useTimestampExplicitOnly(provider)) {
            generator.writeStartArray();
            generator.writeNumber(value.getMonthValue());
            generator.writeNumber(value.getDayOfMonth());
            generator.writeEndArray();
        } else {
            String str = this._formatter == null ? value.toString() : value.format(this._formatter);
            generator.writeString(str);
        }
    }

    @Override
    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        boolean useTimestamp;
        SerializerProvider provider = visitor.getProvider();
        boolean bl = useTimestamp = provider != null && this._useTimestampExplicitOnly(provider);
        if (useTimestamp) {
            this._acceptTimestampVisitor(visitor, typeHint);
        } else {
            JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
            if (v2 != null) {
                v2.format(JsonValueFormat.DATE_TIME);
            }
        }
    }
}

