/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.IterImplForStreaming;
import com.jsoniter.IterImplNumber;
import com.jsoniter.IterImplSkip;
import com.jsoniter.IterImplString;
import com.jsoniter.JsonIterator;
import com.jsoniter.Slice;
import com.jsoniter.any.Any;
import com.jsoniter.spi.JsonException;
import java.io.IOException;

class IterImpl {
    IterImpl() {
    }

    public static final int readObjectFieldAsHash(JsonIterator iter) throws IOException {
        byte c;
        int i;
        if (IterImpl.readByte(iter) != 34 && IterImpl.nextToken(iter) != 34) {
            throw iter.reportError("readObjectFieldAsHash", "expect \"");
        }
        long hash = -2128831035L;
        for (i = iter.head; i < iter.tail && (c = iter.buf[i]) != 34; ++i) {
            hash ^= (long)c;
            hash *= 16777619L;
        }
        iter.head = i + 1;
        if (IterImpl.readByte(iter) != 58 && IterImpl.nextToken(iter) != 58) {
            throw iter.reportError("readObjectFieldAsHash", "expect :");
        }
        return (int)hash;
    }

    public static final Slice readObjectFieldAsSlice(JsonIterator iter) throws IOException {
        Slice field = IterImpl.readSlice(iter);
        if (IterImpl.nextToken(iter) != 58) {
            throw iter.reportError("readObjectFieldAsSlice", "expect : after object field");
        }
        return field;
    }

    static final void skipArray(JsonIterator iter) throws IOException {
        int level = 1;
        block5: for (int i = iter.head; i < iter.tail; ++i) {
            switch (iter.buf[i]) {
                case 34: {
                    iter.head = i + 1;
                    IterImpl.skipString(iter);
                    i = iter.head - 1;
                    continue block5;
                }
                case 91: {
                    ++level;
                    continue block5;
                }
                case 93: {
                    if (--level != 0) continue block5;
                    iter.head = i + 1;
                    return;
                }
            }
        }
        throw iter.reportError("skipArray", "incomplete array");
    }

    static final void skipObject(JsonIterator iter) throws IOException {
        int level = 1;
        block5: for (int i = iter.head; i < iter.tail; ++i) {
            switch (iter.buf[i]) {
                case 34: {
                    iter.head = i + 1;
                    IterImpl.skipString(iter);
                    i = iter.head - 1;
                    continue block5;
                }
                case 123: {
                    ++level;
                    continue block5;
                }
                case 125: {
                    if (--level != 0) continue block5;
                    iter.head = i + 1;
                    return;
                }
            }
        }
        throw iter.reportError("skipObject", "incomplete object");
    }

    static final void skipString(JsonIterator iter) throws IOException {
        int end = IterImplSkip.findStringEnd(iter);
        if (end == -1) {
            throw iter.reportError("skipString", "incomplete string");
        }
        iter.head = end;
    }

    static final void skipUntilBreak(JsonIterator iter) throws IOException {
        for (int i = iter.head; i < iter.tail; ++i) {
            byte c = iter.buf[i];
            if (!IterImplSkip.breaks[c]) continue;
            iter.head = i;
            return;
        }
        iter.head = iter.tail;
    }

    static final boolean skipNumber(JsonIterator iter) throws IOException {
        boolean dotFound = false;
        for (int i = iter.head; i < iter.tail; ++i) {
            byte c = iter.buf[i];
            if (c == 46) {
                dotFound = true;
                continue;
            }
            if (!IterImplSkip.breaks[c]) continue;
            iter.head = i;
            return dotFound;
        }
        iter.head = iter.tail;
        return dotFound;
    }

    public static final Slice readSlice(JsonIterator iter) throws IOException {
        if (IterImpl.nextToken(iter) != 34) {
            throw iter.reportError("readSlice", "expect \" for string");
        }
        int end = IterImplString.findSliceEnd(iter);
        if (end == -1) {
            throw iter.reportError("readSlice", "incomplete string");
        }
        iter.reusableSlice.reset(iter.buf, iter.head, end - 1);
        iter.head = end;
        return iter.reusableSlice;
    }

    static final byte nextToken(JsonIterator iter) throws IOException {
        byte c;
        int i = iter.head;
        block3: while (true) {
            c = iter.buf[i++];
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
        iter.head = i;
        return c;
    }

    static final byte readByte(JsonIterator iter) throws IOException {
        return iter.buf[iter.head++];
    }

    public static Any readAny(JsonIterator iter) throws IOException {
        int start = iter.head;
        byte c = IterImpl.nextToken(iter);
        switch (c) {
            case 34: {
                IterImpl.skipString(iter);
                return Any.lazyString(iter.buf, start, iter.head);
            }
            case 116: {
                IterImpl.skipFixedBytes(iter, 3);
                return Any.wrap(true);
            }
            case 102: {
                IterImpl.skipFixedBytes(iter, 4);
                return Any.wrap(false);
            }
            case 110: {
                IterImpl.skipFixedBytes(iter, 3);
                return Any.wrap(null);
            }
            case 91: {
                IterImpl.skipArray(iter);
                return Any.lazyArray(iter.buf, start, iter.head);
            }
            case 123: {
                IterImpl.skipObject(iter);
                return Any.lazyObject(iter.buf, start, iter.head);
            }
        }
        if (IterImpl.skipNumber(iter)) {
            return Any.lazyDouble(iter.buf, start, iter.head);
        }
        return Any.lazyLong(iter.buf, start, iter.head);
    }

    public static void skipFixedBytes(JsonIterator iter, int n) throws IOException {
        iter.head += n;
    }

    public static final boolean loadMore(JsonIterator iter) throws IOException {
        return false;
    }

    public static final int readStringSlowPath(JsonIterator iter, int j) throws IOException {
        try {
            int i = iter.head;
            while (i < iter.tail) {
                int bc;
                block25: {
                    block24: {
                        if ((bc = iter.buf[i++]) == 34) {
                            iter.head = i;
                            return j;
                        }
                        if (bc != 92) break block24;
                        bc = iter.buf[i++];
                        switch (bc) {
                            case 98: {
                                bc = 8;
                                break block25;
                            }
                            case 116: {
                                bc = 9;
                                break block25;
                            }
                            case 110: {
                                bc = 10;
                                break block25;
                            }
                            case 102: {
                                bc = 12;
                                break block25;
                            }
                            case 114: {
                                bc = 13;
                                break block25;
                            }
                            case 34: 
                            case 47: 
                            case 92: {
                                break block25;
                            }
                            case 117: {
                                bc = (IterImplString.translateHex(iter.buf[i++]) << 12) + (IterImplString.translateHex(iter.buf[i++]) << 8) + (IterImplString.translateHex(iter.buf[i++]) << 4) + IterImplString.translateHex(iter.buf[i++]);
                                break block25;
                            }
                            default: {
                                throw iter.reportError("readStringSlowPath", "invalid escape character: " + bc);
                            }
                        }
                    }
                    if ((bc & 0x80) != 0) {
                        byte u2 = iter.buf[i++];
                        if ((bc & 0xE0) == 192) {
                            bc = ((bc & 0x1F) << 6) + (u2 & 0x3F);
                        } else {
                            byte u3 = iter.buf[i++];
                            if ((bc & 0xF0) == 224) {
                                bc = ((bc & 0xF) << 12) + ((u2 & 0x3F) << 6) + (u3 & 0x3F);
                            } else {
                                byte u4 = iter.buf[i++];
                                if ((bc & 0xF8) != 240) {
                                    throw iter.reportError("readStringSlowPath", "invalid unicode character");
                                }
                                bc = ((bc & 7) << 18) + ((u2 & 0x3F) << 12) + ((u3 & 0x3F) << 6) + (u4 & 0x3F);
                                if (bc >= 65536) {
                                    char[] newBuf;
                                    if (bc >= 0x110000) {
                                        throw iter.reportError("readStringSlowPath", "invalid unicode character");
                                    }
                                    int sup = bc - 65536;
                                    if (iter.reusableChars.length == j) {
                                        newBuf = new char[iter.reusableChars.length * 2];
                                        System.arraycopy(iter.reusableChars, 0, newBuf, 0, iter.reusableChars.length);
                                        iter.reusableChars = newBuf;
                                    }
                                    iter.reusableChars[j++] = (char)((sup >>> 10) + 55296);
                                    if (iter.reusableChars.length == j) {
                                        newBuf = new char[iter.reusableChars.length * 2];
                                        System.arraycopy(iter.reusableChars, 0, newBuf, 0, iter.reusableChars.length);
                                        iter.reusableChars = newBuf;
                                    }
                                    iter.reusableChars[j++] = (char)((sup & 0x3FF) + 56320);
                                    continue;
                                }
                            }
                        }
                    }
                }
                if (iter.reusableChars.length == j) {
                    char[] newBuf = new char[iter.reusableChars.length * 2];
                    System.arraycopy(iter.reusableChars, 0, newBuf, 0, iter.reusableChars.length);
                    iter.reusableChars = newBuf;
                }
                iter.reusableChars[j++] = (char)bc;
            }
            throw iter.reportError("readStringSlowPath", "incomplete string");
        }
        catch (IndexOutOfBoundsException e) {
            throw iter.reportError("readString", "incomplete string");
        }
    }

    public static int updateStringCopyBound(JsonIterator iter, int bound) {
        return bound;
    }

    static final int readPositiveInt(JsonIterator iter, byte c) throws IOException {
        int ind = IterImplNumber.intDigits[c];
        if (ind == 0) {
            return 0;
        }
        if (ind == -1) {
            throw iter.reportError("readPositiveInt", "expect 0~9");
        }
        if (iter.tail - iter.head > 9) {
            int ind8;
            int ind7;
            int ind6;
            int ind5;
            int ind4;
            int ind3;
            int i = iter.head;
            int ind2 = IterImplNumber.intDigits[iter.buf[i]];
            if (ind2 == -1) {
                iter.head = i;
                return ind;
            }
            if ((ind3 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 10 + ind2;
            }
            if ((ind4 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 100 + ind2 * 10 + ind3;
            }
            if ((ind5 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 1000 + ind2 * 100 + ind3 * 10 + ind4;
            }
            if ((ind6 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 10000 + ind2 * 1000 + ind3 * 100 + ind4 * 10 + ind5;
            }
            if ((ind7 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 100000 + ind2 * 10000 + ind3 * 1000 + ind4 * 100 + ind5 * 10 + ind6;
            }
            if ((ind8 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 1000000 + ind2 * 100000 + ind3 * 10000 + ind4 * 1000 + ind5 * 100 + ind6 * 10 + ind7;
            }
            int ind9 = IterImplNumber.intDigits[iter.buf[++i]];
            ind = ind * 10000000 + ind2 * 1000000 + ind3 * 100000 + ind4 * 10000 + ind5 * 1000 + ind6 * 100 + ind7 * 10 + ind8;
            iter.head = i;
            if (ind9 == -1) {
                return ind;
            }
        }
        return IterImplForStreaming.readIntSlowPath(iter, ind);
    }

    static final long readPositiveLong(JsonIterator iter, byte c) throws IOException {
        long ind = IterImplNumber.intDigits[c];
        if (ind == -1L) {
            throw iter.reportError("readPositiveLong", "expect 0~9");
        }
        if (iter.tail - iter.head > 9) {
            int ind8;
            int ind7;
            int ind6;
            int ind5;
            int ind4;
            int ind3;
            int i = iter.head;
            int ind2 = IterImplNumber.intDigits[iter.buf[i]];
            if (ind2 == -1) {
                iter.head = i;
                return ind;
            }
            if ((ind3 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 10L + (long)ind2;
            }
            if ((ind4 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 100L + (long)(ind2 * 10) + (long)ind3;
            }
            if ((ind5 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 1000L + (long)(ind2 * 100) + (long)(ind3 * 10) + (long)ind4;
            }
            if ((ind6 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 10000L + (long)(ind2 * 1000) + (long)(ind3 * 100) + (long)(ind4 * 10) + (long)ind5;
            }
            if ((ind7 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 100000L + (long)(ind2 * 10000) + (long)(ind3 * 1000) + (long)(ind4 * 100) + (long)(ind5 * 10) + (long)ind6;
            }
            if ((ind8 = IterImplNumber.intDigits[iter.buf[++i]]) == -1) {
                iter.head = i;
                return ind * 1000000L + (long)(ind2 * 100000) + (long)(ind3 * 10000) + (long)(ind4 * 1000) + (long)(ind5 * 100) + (long)(ind6 * 10) + (long)ind7;
            }
            int ind9 = IterImplNumber.intDigits[iter.buf[++i]];
            ind = ind * 10000000L + (long)(ind2 * 1000000) + (long)(ind3 * 100000) + (long)(ind4 * 10000) + (long)(ind5 * 1000) + (long)(ind6 * 100) + (long)(ind7 * 10) + (long)ind8;
            iter.head = i;
            if (ind9 == -1) {
                return ind;
            }
        }
        return IterImplForStreaming.readLongSlowPath(iter, ind);
    }

    static final double readPositiveDouble(JsonIterator iter) throws IOException {
        int oldHead = iter.head;
        try {
            long value = IterImplNumber.readLong(iter);
            if (iter.head == iter.tail) {
                return value;
            }
            byte c = iter.buf[iter.head];
            if (c == 46) {
                ++iter.head;
                int start = iter.head;
                c = iter.buf[iter.head++];
                long decimalPart = IterImpl.readPositiveLong(iter, c);
                int decimalPlaces = iter.head - start;
                if (decimalPlaces > 0 && decimalPlaces < IterImplNumber.POW10.length && iter.head - oldHead < 10) {
                    value = value * IterImplNumber.POW10[decimalPlaces] + decimalPart;
                    return (double)value / (double)IterImplNumber.POW10[decimalPlaces];
                }
                iter.head = oldHead;
                return IterImplForStreaming.readDoubleSlowPath(iter);
            }
            if (iter.head < iter.tail && iter.buf[iter.head] == 101) {
                iter.head = oldHead;
                return IterImplForStreaming.readDoubleSlowPath(iter);
            }
            return value;
        }
        catch (JsonException e) {
            iter.head = oldHead;
            return IterImplForStreaming.readDoubleSlowPath(iter);
        }
    }
}

