/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.IterImpl;
import com.jsoniter.JsonIterator;
import java.io.IOException;

class IterImplString {
    static final int[] hexDigits;

    IterImplString() {
    }

    public static final String readString(JsonIterator iter) throws IOException {
        byte c = IterImpl.readByte(iter);
        if (c != 34 && IterImplString.readStringIsNull(iter, c)) {
            return null;
        }
        int j = IterImplString.parse(iter);
        return new String(iter.reusableChars, 0, j);
    }

    private static int parse(JsonIterator iter) throws IOException {
        int i = iter.head;
        int bound = iter.reusableChars.length;
        bound = IterImpl.updateStringCopyBound(iter, bound);
        for (int j = 0; j < bound; ++j) {
            byte c;
            if ((c = iter.buf[i++]) == 34) {
                iter.head = i;
                return j;
            }
            if ((c ^ 0x5C) < 1) break;
            iter.reusableChars[j] = (char)c;
        }
        int alreadyCopied = 0;
        if (i > iter.head) {
            alreadyCopied = i - iter.head - 1;
            iter.head = i - 1;
        }
        return IterImpl.readStringSlowPath(iter, alreadyCopied);
    }

    private static boolean readStringIsNull(JsonIterator iter, byte c) throws IOException {
        if (c == 110) {
            IterImpl.skipFixedBytes(iter, 3);
            return true;
        }
        c = IterImpl.nextToken(iter);
        if (c == 110) {
            IterImpl.skipFixedBytes(iter, 3);
            return true;
        }
        return false;
    }

    public static int translateHex(byte b) {
        int val = hexDigits[b];
        if (val == -1) {
            throw new IndexOutOfBoundsException(b + " is not valid hex digit");
        }
        return val;
    }

    static final int findSliceEnd(JsonIterator iter) {
        for (int i = iter.head; i < iter.tail; ++i) {
            byte c = iter.buf[i];
            if (c == 34) {
                return i + 1;
            }
            if (c != 92) continue;
            throw iter.reportError("findSliceEnd", "slice does not support escape char");
        }
        return -1;
    }

    static {
        int i;
        hexDigits = new int[103];
        for (i = 0; i < hexDigits.length; ++i) {
            IterImplString.hexDigits[i] = -1;
        }
        for (i = 48; i <= 57; ++i) {
            IterImplString.hexDigits[i] = i - 48;
        }
        for (i = 97; i <= 102; ++i) {
            IterImplString.hexDigits[i] = i - 97 + 10;
        }
        for (i = 65; i <= 70; ++i) {
            IterImplString.hexDigits[i] = i - 65 + 10;
        }
    }
}

