/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.JsonIterator;
import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;

abstract class LazyAny
extends Any {
    protected final byte[] data;
    protected final int head;
    protected final int tail;

    public LazyAny(byte[] data, int head, int tail) {
        this.data = data;
        this.head = head;
        this.tail = tail;
    }

    @Override
    public abstract ValueType valueType();

    @Override
    public final <T> T bindTo(T obj) {
        try {
            return this.parse().read(obj);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public final <T> T bindTo(TypeLiteral<T> typeLiteral, T obj) {
        try {
            return this.parse().read(typeLiteral, obj);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public final <T> T as(Class<T> clazz) {
        try {
            return this.parse().read(clazz);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public final <T> T as(TypeLiteral<T> typeLiteral) {
        try {
            return this.parse().read(typeLiteral);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    @Override
    public String toString() {
        return new String(this.data, this.head, this.tail - this.head);
    }

    @Override
    public final JsonIterator parse() {
        JsonIterator iter = JsonIterator.tlsIter.get();
        iter.reset(this.data, this.head, this.tail);
        return iter;
    }

    @Override
    public void writeTo(JsonStream stream) throws IOException {
        stream.write(this.data, this.head, this.tail - this.head);
    }
}

