/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import java.io.IOException;

class StringAny
extends Any {
    private static final String FALSE = "false";
    private String val;

    public StringAny(String val) {
        this.val = val;
    }

    @Override
    public ValueType valueType() {
        return ValueType.STRING;
    }

    @Override
    public Object object() {
        return this.val;
    }

    @Override
    public Any set(String newVal) {
        this.val = newVal;
        return this;
    }

    @Override
    public void writeTo(JsonStream stream) throws IOException {
        stream.writeVal(this.val);
    }

    @Override
    public boolean toBoolean() {
        int len = this.val.length();
        if (len == 0) {
            return false;
        }
        if (len == 5 && FALSE.equals(this.val)) {
            return false;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (this.val.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int toInt() {
        return Integer.valueOf(this.val);
    }

    @Override
    public long toLong() {
        return Long.valueOf(this.val);
    }

    @Override
    public float toFloat() {
        return Float.valueOf(this.val).floatValue();
    }

    @Override
    public double toDouble() {
        return Double.valueOf(this.val);
    }

    @Override
    public String toString() {
        return this.val;
    }
}

