/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen;

import com.fizzed.rocker.runtime.ArrayOfByteArraysOutput;
import com.fizzed.rocker.runtime.DefaultRockerModel;
import com.jsoniter.any.Any;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public interface Generator {
    public static final Map<String, byte[]> schemaMap = new HashMap<String, byte[]>();

    public void generate(String var1, Object var2, Any var3) throws IOException;

    public String getFramework();

    default public ByteBuffer getConfigSchema() throws IOException {
        byte[] schemaBuf = schemaMap.get(this.getFramework());
        if (schemaBuf == null) {
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.getFramework() + ".json");){
                schemaBuf = IOUtils.toByteArray(is);
                schemaMap.put(this.getFramework(), schemaBuf);
            }
        }
        return ByteBuffer.wrap(schemaBuf);
    }

    default public void transfer(String folder, String path, String filename, DefaultRockerModel rockerModel) throws IOException {
        String absPath = folder + (path.isEmpty() ? "" : File.separator + path);
        if (Files.notExists(Paths.get(absPath, new String[0]), new LinkOption[0])) {
            Files.createDirectories(Paths.get(absPath, new String[0]), new FileAttribute[0]);
        }
        try (FileOutputStream fos = new FileOutputStream(absPath + File.separator + filename);
             ReadableByteChannel rbc = rockerModel.render(ArrayOfByteArraysOutput.FACTORY).asReadableByteChannel();){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
    }
}

