/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.GraphQLException;
import graphql.execution.TypeFromAST;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ValuesResolver {
    public Map<String, Object> getVariableValues(GraphQLSchema schema, List<VariableDefinition> variableDefinitions, Map<String, Object> inputs) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (VariableDefinition variableDefinition : variableDefinitions) {
            result.put(variableDefinition.getName(), this.getVariableValue(schema, variableDefinition, inputs.get(variableDefinition.getName())));
        }
        return result;
    }

    public Map<String, Object> getArgumentValues(List<GraphQLArgument> argumentTypes, List<Argument> arguments, Map<String, Object> variables) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Map<String, Argument> argumentMap = this.argumentMap(arguments);
        for (GraphQLArgument fieldArgument : argumentTypes) {
            Argument argument = argumentMap.get(fieldArgument.getName());
            Object value = argument != null ? this.coerceValueAst(fieldArgument.getType(), argument.getValue(), variables) : fieldArgument.getDefaultValue();
            result.put(fieldArgument.getName(), value);
        }
        return result;
    }

    private Map<String, Argument> argumentMap(List<Argument> arguments) {
        LinkedHashMap<String, Argument> result = new LinkedHashMap<String, Argument>();
        for (Argument argument : arguments) {
            result.put(argument.getName(), argument);
        }
        return result;
    }

    private Object getVariableValue(GraphQLSchema schema, VariableDefinition variableDefinition, Object inputValue) {
        GraphQLType type = TypeFromAST.getTypeFromAST(schema, variableDefinition.getType());
        if (!this.isValid(type, inputValue)) {
            throw new GraphQLException("Invalid value for type");
        }
        if (inputValue == null && variableDefinition.getDefaultValue() != null) {
            return this.coerceValueAst(type, variableDefinition.getDefaultValue(), null);
        }
        return this.coerceValue(type, inputValue);
    }

    private boolean isValid(GraphQLType type, Object inputValue) {
        return true;
    }

    private Object coerceValue(GraphQLType graphQLType, Object value) {
        if (graphQLType instanceof GraphQLNonNull) {
            Object returnValue = this.coerceValue(((GraphQLNonNull)graphQLType).getWrappedType(), value);
            if (returnValue == null) {
                throw new GraphQLException("Null value for NonNull type " + graphQLType);
            }
            return returnValue;
        }
        if (value == null) {
            return null;
        }
        if (graphQLType instanceof GraphQLScalarType) {
            return this.coerceValueForScalar((GraphQLScalarType)graphQLType, value);
        }
        if (graphQLType instanceof GraphQLEnumType) {
            return this.coerceValueForEnum((GraphQLEnumType)graphQLType, value);
        }
        if (graphQLType instanceof GraphQLList) {
            return this.coerceValueForList((GraphQLList)graphQLType, value);
        }
        if (graphQLType instanceof GraphQLInputObjectType && value instanceof Map) {
            return this.coerceValueForInputObjectType((GraphQLInputObjectType)graphQLType, (Map)value);
        }
        if (graphQLType instanceof GraphQLInputObjectType) {
            return value;
        }
        throw new GraphQLException("unknown type " + graphQLType);
    }

    private Object coerceValueForInputObjectType(GraphQLInputObjectType inputObjectType, Map<String, Object> input) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (GraphQLInputObjectField inputField : inputObjectType.getFields()) {
            if (!input.containsKey(inputField.getName()) && !this.alwaysHasValue(inputField)) continue;
            Object value = this.coerceValue(inputField.getType(), input.get(inputField.getName()));
            result.put(inputField.getName(), value == null ? inputField.getDefaultValue() : value);
        }
        return result;
    }

    private boolean alwaysHasValue(GraphQLInputObjectField inputField) {
        return inputField.getDefaultValue() != null || inputField.getType() instanceof GraphQLNonNull;
    }

    private Object coerceValueForScalar(GraphQLScalarType graphQLScalarType, Object value) {
        return graphQLScalarType.getCoercing().parseValue(value);
    }

    private Object coerceValueForEnum(GraphQLEnumType graphQLEnumType, Object value) {
        return graphQLEnumType.getCoercing().parseValue(value);
    }

    private List coerceValueForList(GraphQLList graphQLList, Object value) {
        if (value instanceof Iterable) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object val : (Iterable)value) {
                result.add(this.coerceValue(graphQLList.getWrappedType(), val));
            }
            return result;
        }
        return Collections.singletonList(this.coerceValue(graphQLList.getWrappedType(), value));
    }

    private Object coerceValueAst(GraphQLType type, Value inputValue, Map<String, Object> variables) {
        if (inputValue instanceof VariableReference) {
            return variables.get(((VariableReference)inputValue).getName());
        }
        if (type instanceof GraphQLScalarType) {
            return ((GraphQLScalarType)type).getCoercing().parseLiteral(inputValue);
        }
        if (type instanceof GraphQLNonNull) {
            return this.coerceValueAst(((GraphQLNonNull)type).getWrappedType(), inputValue, variables);
        }
        if (type instanceof GraphQLInputObjectType) {
            return this.coerceValueAstForInputObject((GraphQLInputObjectType)type, (ObjectValue)inputValue, variables);
        }
        if (type instanceof GraphQLEnumType) {
            return ((GraphQLEnumType)type).getCoercing().parseLiteral(inputValue);
        }
        if (type instanceof GraphQLList) {
            return this.coerceValueAstForList((GraphQLList)type, inputValue, variables);
        }
        return null;
    }

    private Object coerceValueAstForList(GraphQLList graphQLList, Value value, Map<String, Object> variables) {
        if (value instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)value;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Value singleValue : arrayValue.getValues()) {
                result.add(this.coerceValueAst(graphQLList.getWrappedType(), singleValue, variables));
            }
            return result;
        }
        return Collections.singletonList(this.coerceValueAst(graphQLList.getWrappedType(), value, variables));
    }

    private Object coerceValueAstForInputObject(GraphQLInputObjectType type, ObjectValue inputValue, Map<String, Object> variables) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Map<String, ObjectField> inputValueFieldsByName = this.mapObjectValueFieldsByName(inputValue);
        for (GraphQLInputObjectField inputTypeField : type.getFields()) {
            if (inputValueFieldsByName.containsKey(inputTypeField.getName())) {
                ObjectField field = inputValueFieldsByName.get(inputTypeField.getName());
                Object fieldValue = this.coerceValueAst(inputTypeField.getType(), field.getValue(), variables);
                if (fieldValue == null) {
                    fieldValue = inputTypeField.getDefaultValue();
                }
                result.put(field.getName(), fieldValue);
                continue;
            }
            if (inputTypeField.getDefaultValue() != null) {
                result.put(inputTypeField.getName(), inputTypeField.getDefaultValue());
                continue;
            }
            if (!(inputTypeField.getType() instanceof GraphQLNonNull)) continue;
            throw new GraphQLException("Null value for NonNull type " + inputTypeField.getType());
        }
        return result;
    }

    private Map<String, ObjectField> mapObjectValueFieldsByName(ObjectValue inputValue) {
        LinkedHashMap<String, ObjectField> inputValueFieldsByName = new LinkedHashMap<String, ObjectField>();
        for (ObjectField objectField : inputValue.getObjectFields()) {
            inputValueFieldsByName.put(objectField.getName(), objectField);
        }
        return inputValueFieldsByName;
    }
}

