/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.Type;
import graphql.language.Value;
import java.util.ArrayList;
import java.util.List;

public class InputValueDefinition
extends AbstractNode {
    private String name;
    private Type type;
    private Value defaultValue;
    private List<Directive> directives = new ArrayList<Directive>();

    public InputValueDefinition(String name) {
        this(name, null);
    }

    public InputValueDefinition(String name, Type type) {
        this(name, type, null);
    }

    public InputValueDefinition(String name, Type type, Value defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public void setValue(Value defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.type);
        result.add(this.defaultValue);
        result.addAll(this.directives);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputValueDefinition that = (InputValueDefinition)o;
        return !(null == this.name ? null != that.name : !this.name.equals(that.name));
    }

    public String toString() {
        return "InputValueDefinition{name='" + this.name + '\'' + ", type=" + this.type + ", defaultValue=" + this.defaultValue + ", directives=" + this.directives + '}';
    }
}

