/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.Handlers;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.CanonicalPathUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class CanonicalPathHandler
implements HttpHandler {
    private volatile HttpHandler next = ResponseCodeHandler.HANDLE_404;

    public CanonicalPathHandler() {
    }

    public CanonicalPathHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.setRelativePath(CanonicalPathUtils.canonicalize(exchange.getRelativePath()));
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public CanonicalPathHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler2) {
            return new CanonicalPathHandler(handler2);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "canonical-path";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }
}

