/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ReadReadyHandler;
import org.xnio.conduits.StreamSourceConduit;

public final class StreamSourceChannelWrappingConduit
implements StreamSourceConduit {
    private final StreamSourceChannel channel;

    public StreamSourceChannelWrappingConduit(StreamSourceChannel channel) {
        this.channel = channel;
    }

    @Override
    public void terminateReads() throws IOException {
        this.channel.shutdownReads();
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return this.channel.transferTo(position, count, target);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return this.channel.transferTo(count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        return this.channel.read(dsts, offs, len);
    }

    @Override
    public boolean isReadShutdown() {
        return !this.channel.isOpen();
    }

    @Override
    public void resumeReads() {
        this.channel.resumeReads();
    }

    @Override
    public void suspendReads() {
        this.channel.suspendReads();
    }

    @Override
    public void wakeupReads() {
        this.channel.wakeupReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.channel.isReadResumed();
    }

    @Override
    public void awaitReadable() throws IOException {
        this.channel.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.channel.awaitReadable(time, timeUnit);
    }

    @Override
    public XnioIoThread getReadThread() {
        return this.channel.getIoThread();
    }

    @Override
    public void setReadReadyHandler(final ReadReadyHandler handler2) {
        this.channel.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

            @Override
            public void handleEvent(StreamSourceChannel channel) {
                handler2.readReady();
            }
        });
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }
}

