/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.runtime;

import com.fizzed.rocker.BindableRockerModel;
import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.RenderingException;
import com.fizzed.rocker.RockerContent;
import com.fizzed.rocker.RockerModel;
import com.fizzed.rocker.RockerOutput;
import com.fizzed.rocker.RockerOutputFactory;
import com.fizzed.rocker.RockerStringify;
import com.fizzed.rocker.RockerTemplate;
import com.fizzed.rocker.runtime.ArrayOfByteArraysOutput;
import com.fizzed.rocker.runtime.BreakException;
import com.fizzed.rocker.runtime.CompileDiagnosticException;
import com.fizzed.rocker.runtime.ContinueException;
import com.fizzed.rocker.runtime.DefaultRockerModel;
import com.fizzed.rocker.runtime.Raw;
import java.io.IOException;

public abstract class DefaultRockerTemplate
extends RockerTemplate {
    protected Internal __internal = new Internal();

    public DefaultRockerTemplate(RockerModel model2) {
        super(model2);
    }

    @Override
    protected void __associate(RockerTemplate context) {
        DefaultRockerTemplate otherContext = (DefaultRockerTemplate)context;
        this.__internal.setOut(otherContext.__internal.getOut());
        this.__internal.setContentType(otherContext.__internal.getContentType(), otherContext.__internal.getStringify());
    }

    @Override
    protected RockerOutput __newOutput() {
        return new ArrayOfByteArraysOutput(this.__internal.getContentType(), this.__internal.getCharset());
    }

    public final RockerOutput __render(DefaultRockerTemplate context, RockerOutputFactory outputFactory) throws RenderingException {
        if (context != null) {
            this.__associate(context);
        }
        if (this.__internal.charset == null) {
            throw new RenderingException("Template charset must be initialized before render");
        }
        if (this.__internal.contentType == null) {
            throw new RenderingException("Content type must be initialized before render");
        }
        if (this.__internal.stringify == null) {
            throw new RenderingException("Stringify must be initialized before render");
        }
        if (this.__internal.out == null) {
            if (outputFactory != null) {
                this.__internal.out = outputFactory.create(this.__internal.contentType, this.__internal.charset);
            } else {
                this.__internal.out = this.__newOutput();
            }
        }
        this.__internal.verifyOkToBeginRendering();
        try {
            this.__doRender();
        }
        catch (CompileDiagnosticException e) {
            throw e;
        }
        catch (Throwable t) {
            String templatePath = this.__internal.templatePackageName.replace('.', '/');
            throw new RenderingException(this.__internal.sourceLine, this.__internal.sourcePosInLine, this.__internal.templateName, templatePath, t.getMessage(), t);
        }
        return this.__internal.out;
    }

    protected abstract void __doRender() throws IOException, RenderingException;

    public Raw raw(Object obj) throws IOException {
        if (obj == null) {
            throw new NullPointerException("Value was null");
        }
        return Raw.of(obj.toString());
    }

    public Raw raw(String s) throws IOException {
        if (s == null) {
            throw new NullPointerException("Value was null");
        }
        return Raw.of(s);
    }

    protected class Internal {
        private String charset;
        private ContentType contentType;
        private RockerStringify stringify;
        private RockerOutput out;
        private boolean rendered;
        private int sourceLine = -1;
        private int sourcePosInLine = -1;
        private String templateName;
        private String templatePackageName;

        private Internal() {
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public String getTemplatePackageName() {
            return this.templatePackageName;
        }

        public void setTemplatePackageName(String templatePackageName) {
            this.templatePackageName = templatePackageName;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public void aboutToExecutePosInTemplate(int line, int posInLine) {
            this.sourceLine = line;
            this.sourcePosInLine = posInLine;
        }

        public ContentType getContentType() {
            return this.contentType;
        }

        public void setContentType(ContentType contentType) {
            this.setContentType(contentType, ContentType.stringify(contentType));
        }

        public void setContentType(ContentType contentType, RockerStringify stringify) {
            this.contentType = contentType;
            this.stringify = stringify;
        }

        public RockerStringify getStringify() {
            return this.stringify;
        }

        public void setStringify(RockerStringify stringify) {
            this.stringify = stringify;
        }

        public RockerOutput getOut() {
            return this.out;
        }

        public void setOut(RockerOutput out) {
            this.out = out;
        }

        protected void verifyOkToBeginRendering() {
            if (this.rendered) {
                throw new RenderingException("Template already rendered (templates are single use only!)");
            }
            this.rendered = true;
        }

        public void throwBreakException() throws BreakException {
            throw new BreakException();
        }

        public void throwContinueException() throws ContinueException {
            throw new ContinueException();
        }

        public void writeValue(String s) throws IOException {
            this.out.w(s);
        }

        public void writeValue(byte[] bytes) throws IOException {
            this.out.w(bytes);
        }

        public void renderValue(RockerContent c, boolean nullSafe) throws RenderingException, IOException {
            if (nullSafe && c == null) {
                return;
            }
            c.render();
        }

        public void renderValue(DefaultRockerModel model2, boolean nullSafe) throws RenderingException, IOException {
            model2.doRender(DefaultRockerTemplate.this, null, null);
        }

        public void renderValue(BindableRockerModel model2, boolean nullSafe) throws RenderingException, IOException {
            DefaultRockerModel underlyingModel = (DefaultRockerModel)model2.getModel();
            this.renderValue(underlyingModel, nullSafe);
        }

        public void renderValue(Raw raw, boolean nullSafe) throws RenderingException, IOException {
            if (nullSafe && raw.getValue() == null) {
                return;
            }
            this.out.w(raw.toString());
        }

        public void renderValue(String value, boolean nullSafe) throws IOException {
            if (nullSafe && value == null) {
                return;
            }
            this.out.w(this.stringify.s(value));
        }

        public void renderValue(Object value, boolean nullSafe) throws IOException {
            if (nullSafe && value == null) {
                return;
            }
            this.out.w(this.stringify.s(value));
        }

        public void renderValue(byte v, boolean nullSafe) throws IOException {
            this.out.w(this.stringify.s(v));
        }

        public void renderValue(short v, boolean nullSafe) throws IOException {
            this.out.w(this.stringify.s(v));
        }

        public void renderValue(int v, boolean nullSafe) throws IOException {
            this.out.w(this.stringify.s(v));
        }

        public void renderValue(long v, boolean nullSafe) throws IOException {
            this.out.w(this.stringify.s(v));
        }

        public void renderValue(float v, boolean nullSafe) throws IOException {
            this.out.w(this.stringify.s(v));
        }

        public void renderValue(double v, boolean nullSafe) throws IOException {
            this.out.w(this.stringify.s(v));
        }

        public void renderValue(char v, boolean nullSafe) throws IOException {
            this.out.w(this.stringify.s(v));
        }

        public void renderValue(boolean v, boolean nullSafe) throws IOException {
            this.out.w(this.stringify.s(v));
        }
    }
}

