/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.JsonIterator;
import com.jsoniter.JsonIteratorPool;
import com.jsoniter.ValueType;
import com.jsoniter.any.LazyAny;
import com.jsoniter.spi.JsonException;
import java.io.IOException;

class LongLazyAny
extends LazyAny {
    private boolean isCached;
    private long cache;

    public LongLazyAny(byte[] data, int head, int tail) {
        super(data, head, tail);
    }

    @Override
    public ValueType valueType() {
        return ValueType.NUMBER;
    }

    @Override
    public Object object() {
        this.fillCache();
        return this.cache;
    }

    @Override
    public boolean toBoolean() {
        this.fillCache();
        return this.cache != 0L;
    }

    @Override
    public int toInt() {
        this.fillCache();
        return (int)this.cache;
    }

    @Override
    public long toLong() {
        this.fillCache();
        return this.cache;
    }

    @Override
    public float toFloat() {
        this.fillCache();
        return this.cache;
    }

    @Override
    public double toDouble() {
        this.fillCache();
        return this.cache;
    }

    private void fillCache() {
        if (!this.isCached) {
            JsonIterator iter = this.parse();
            try {
                this.cache = iter.readLong();
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
            finally {
                JsonIteratorPool.returnJsonIterator(iter);
            }
            this.isCached = true;
        }
    }
}

