/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.eventuate;

import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.networknt.codegen.Generator;
import com.networknt.codegen.Utils;
import com.networknt.oas.OpenApiParser;
import com.networknt.oas.model.Example;
import com.networknt.oas.model.MediaType;
import com.networknt.oas.model.OpenApi3;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.Response;
import com.networknt.oas.model.Server;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import templates.eventuate.rest.LICENSE;
import templates.eventuate.rest.README;
import templates.eventuate.rest.buildSh;
import templates.eventuate.rest.classpath;
import templates.eventuate.rest.clientYml;
import templates.eventuate.rest.gitignore;
import templates.eventuate.rest.handler;
import templates.eventuate.rest.logback;
import templates.eventuate.rest.openapi.command.aggregate;
import templates.eventuate.rest.openapi.command.command;
import templates.eventuate.rest.openapi.commandservice.dockerfileredhat;
import templates.eventuate.rest.openapi.commandservice.service;
import templates.eventuate.rest.openapi.common.event;
import templates.eventuate.rest.openapi.handlerProvider;
import templates.eventuate.rest.openapi.handlerTest;
import templates.eventuate.rest.openapi.query.packageInfo;
import templates.eventuate.rest.openapi.query.pom;
import templates.eventuate.rest.openapi.query.queryService;
import templates.eventuate.rest.openapi.queryservice.dockerfile;
import templates.eventuate.rest.openapi.queryservice.eventuateClient;
import templates.eventuate.rest.openapi.queryservice.kafka;
import templates.eventuate.rest.pojo;
import templates.eventuate.rest.primaryCrt;
import templates.eventuate.rest.project;
import templates.eventuate.rest.secondaryCrt;
import templates.eventuate.rest.secret;
import templates.eventuate.rest.security;
import templates.eventuate.rest.server;
import templates.eventuate.rest.testServer;
import templates.eventuate.rest.validatorYml;

public class EventuateOpenApiGenerator
implements Generator {
    private Map<String, String> typeMapping = new HashMap<String, String>();
    boolean prometheusMetrics = false;

    public EventuateOpenApiGenerator() {
        this.typeMapping.put("array", "java.util.List");
        this.typeMapping.put("map", "java.util.Map");
        this.typeMapping.put("List", "java.util.List");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "java.math.BigDecimal");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("binary", "byte[]");
    }

    @Override
    public String getFramework() {
        return "eventuate-rest";
    }

    @Override
    public void generate(String targetPath, Object model2, Any config) throws IOException {
        String projectName = config.toString("name");
        String projectPath = targetPath + "/" + projectName;
        String eventuateEventPackage = config.toString("eventuateEventPackage");
        String eventuateCommandPackage = config.toString("eventuateCommandPackage");
        String eventuateQueryPackage = config.toString("eventuateQueryPackage");
        boolean overwriteEventuateModule = config.toBoolean("overwriteEventuateModule");
        String httpPort = config.toString("httpPort");
        boolean enableHttps = config.toBoolean("enableHttps");
        String httpsPort = config.toString("httpsPort");
        String dockerOrganization = config.toString("dockerOrganization");
        this.prometheusMetrics = config.toBoolean("prometheusMetrics");
        String expose = "";
        expose = enableHttps ? httpsPort : httpPort;
        if (dockerOrganization == null || dockerOrganization.length() == 0) {
            dockerOrganization = "networknt";
        }
        this.transfer(projectPath, "", "pom.xml", templates.eventuate.rest.openapi.pom.template(config));
        this.transfer(projectPath, "", "build.sh", buildSh.template(dockerOrganization, config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version")));
        this.transfer(projectPath, "", ".gitignore", gitignore.template());
        this.transfer(projectPath, "", "README.md", README.template());
        this.transfer(projectPath, "", "LICENSE", LICENSE.template());
        this.transfer(projectPath, "", ".classpath", classpath.template());
        this.transfer(projectPath, "", ".project", project.template(config));
        this.transfer(projectPath, "common", "pom.xml", templates.eventuate.rest.openapi.common.pom.template(config));
        this.transfer(projectPath, "command", "pom.xml", templates.eventuate.rest.openapi.command.pom.template(config));
        this.transfer(projectPath, "query", "pom.xml", pom.template(config));
        if (overwriteEventuateModule) {
            String basedEventInterface = config.toString("basedEventInterface");
            if (basedEventInterface != null && basedEventInterface.length() > 0) {
                this.transfer(projectPath + "/common", ("src.main.java." + eventuateEventPackage).replace(".", File.separator), basedEventInterface + ".java", event.template(eventuateEventPackage, basedEventInterface));
            } else {
                this.transfer(projectPath + "/common", ("src.main.java." + eventuateEventPackage).replace(".", File.separator), "BaseEvent.java", event.template(eventuateEventPackage, "BaseEvent"));
            }
            String basedCommandInterface = config.toString("basedCommandInterface");
            if (basedCommandInterface != null && basedCommandInterface.length() > 0) {
                this.transfer(projectPath + "/command", ("src.main.java." + eventuateCommandPackage).replace(".", File.separator), basedCommandInterface + ".java", command.template(eventuateCommandPackage, basedCommandInterface));
            } else {
                this.transfer(projectPath + "/command", ("src.main.java." + eventuateCommandPackage).replace(".", File.separator), "BaseCommand.java", command.template(eventuateCommandPackage, "BaseCommand"));
            }
            this.transfer(projectPath + "/command", ("src.main.java." + eventuateCommandPackage + ".domain").replace(".", File.separator), "SampleAggregate.java", aggregate.template(eventuateCommandPackage + ".domain", "SampleAggregate"));
            this.transfer(projectPath + "/query", ("src.main.java." + eventuateQueryPackage).replace(".", File.separator), "package-info.java", packageInfo.template(eventuateQueryPackage));
            this.transfer(projectPath + "/query", ("src.main.java." + eventuateQueryPackage).replace(".", File.separator), "BaseQueryService.java", queryService.template(eventuateQueryPackage, "BaseQueryService"));
        }
        String commandService = projectPath + "/command-rest-service";
        String queryService2 = projectPath + "/query-rest-service";
        Any anyModel = (Any)model2;
        Any commandModel = anyModel.get((Object)"command");
        Any queryModel = anyModel.get((Object)"query");
        if (commandModel != null) {
            this.processCommandService(commandService, commandModel, config, expose);
        }
        if (queryModel != null) {
            this.processQueryService(queryService2, queryModel, config, expose);
        }
    }

    public void processCommandService(String commandService, Object model2, Any config, String expose) throws IOException {
        boolean enableHttp = config.toBoolean("enableHttp");
        boolean enableHttps = config.toBoolean("enableHttps");
        boolean enableRegistry = config.toBoolean("enableRegistry");
        boolean supportClient = config.toBoolean("supportClient");
        String dockerOrganization = config.toString("dockerOrganization");
        boolean overwriteHandler = config.toBoolean("overwriteHandler");
        boolean overwriteHandlerTest = config.toBoolean("overwriteHandlerTest");
        boolean overwriteModel = config.toBoolean("overwriteModel");
        String rootPackage = config.toString("rootPackage");
        String handlerPackage = config.toString("handlerPackage");
        String version = config.toString("version");
        if (dockerOrganization == null || dockerOrganization.length() == 0) {
            dockerOrganization = "networknt";
        }
        this.transfer(commandService, "docker", "Dockerfile", templates.eventuate.rest.openapi.commandservice.dockerfile.template(config));
        this.transfer(commandService, "docker", "Dockerfile-Redhat", dockerfileredhat.template(config));
        this.transfer(commandService, "", "build.sh", buildSh.template(dockerOrganization, config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version")));
        this.transfer(commandService, "", ".gitignore", gitignore.template());
        this.transfer(commandService, "", "README.md", templates.eventuate.rest.openapi.commandservice.README.template());
        this.transfer(commandService, "", "LICENSE", LICENSE.template());
        this.transfer(commandService, "", ".classpath", classpath.template());
        this.transfer(commandService, "", ".project", project.template(config));
        this.transfer(commandService, "", "pom.xml", templates.eventuate.rest.openapi.commandservice.pom.template(config));
        this.transfer(commandService, "src.main.resources.config".replace(".", File.separator), "service.yml", service.template(config));
        this.transfer(commandService, "src.main.resources.config".replace(".", File.separator), "server.yml", server.template(config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version"), enableHttp, "8081", enableHttps, "8441", enableRegistry, version));
        this.transfer(commandService, "src.test.resources.config".replace(".", File.separator), "server.yml", server.template(config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version"), enableHttp, "49587", enableHttps, "49588", enableRegistry, version));
        this.transfer(commandService, "src.main.resources.config".replace(".", File.separator), "secret.yml", secret.template());
        this.transfer(commandService, "src.main.resources.config".replace(".", File.separator), "openapi-security.yml", security.template());
        this.transfer(commandService, "src.main.resources.config".replace(".", File.separator), "openapi-validator.yml", validatorYml.template());
        if (supportClient) {
            this.transfer(commandService, "src.main.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        } else {
            this.transfer(commandService, "src.test.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        }
        this.transfer(commandService, "src.main.resources.config".replace(".", File.separator), "primary.crt", primaryCrt.template());
        this.transfer(commandService, "src.main.resources.config".replace(".", File.separator), "secondary.crt", secondaryCrt.template());
        this.transfer(commandService, "src.main.resources".replace(".", File.separator), "logback.xml", logback.template());
        this.transfer(commandService, "src.test.resources".replace(".", File.separator), "logback-test.xml", logback.template());
        if (overwriteModel) {
            this.generateModule(commandService, model2, config);
        }
        this.injectEndpoints(model2);
        List<Map<String, Object>> operationList = this.getOperationList(model2);
        this.transfer(commandService, ("src.main.java." + rootPackage).replace(".", File.separator), "PathHandlerProvider.java", handlerProvider.template(rootPackage, handlerPackage, operationList, this.prometheusMetrics));
        if (overwriteHandler) {
            for (Map<String, Object> op : operationList) {
                String className = op.get("handlerName").toString();
                String example = null;
                if (op.get("example") != null) {
                    example = JsonStream.serialize(op.get("example"));
                }
                if ("ServerInfoGetHandler".equals(className) || "HealthGetHandler".equals(className) || "PrometheusGetHandler".equals(className)) continue;
                this.transfer(commandService, ("src.main.java." + handlerPackage).replace(".", File.separator), className + ".java", handler.template(handlerPackage, className, example));
            }
        }
        this.transfer(commandService, ("src.test.java." + handlerPackage + ".").replace(".", File.separator), "TestServer.java", testServer.template(handlerPackage));
        if (overwriteHandlerTest) {
            for (Map<String, Object> op : operationList) {
                this.transfer(commandService, ("src.test.java." + handlerPackage).replace(".", File.separator), op.get("handlerName") + "Test.java", handlerTest.template(handlerPackage, op));
            }
        }
        try (InputStream is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/server.keystore");){
            Files.copy(is, Paths.get(commandService, "src.main.resources.config".replace(".", File.separator), "server.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/server.truststore");
        var18_18 = null;
        try {
            Files.copy(is, Paths.get(commandService, "src.main.resources.config".replace(".", File.separator), "server.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var18_18 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var18_18 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var18_18.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        if (supportClient) {
            is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/client.keystore");
            var18_18 = null;
            try {
                Files.copy(is, Paths.get(commandService, "src.main.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var18_18 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var18_18 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var18_18.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/client.truststore");
            var18_18 = null;
            try {
                Files.copy(is, Paths.get(commandService, "src.main.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var18_18 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var18_18 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var18_18.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/client.keystore");
        var18_18 = null;
        try {
            Files.copy(is, Paths.get(commandService, "src.test.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var18_18 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var18_18 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var18_18.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/client.truststore");
        var18_18 = null;
        try {
            Files.copy(is, Paths.get(commandService, "src.test.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var18_18 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var18_18 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var18_18.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        JsonStream.serialize(model2, new FileOutputStream(FileSystems.getDefault().getPath(commandService, "src.main.resources.config".replace(".", File.separator), "openapi.json").toFile()));
    }

    public void processQueryService(String queryService2, Object model2, Any config, String expose) throws IOException {
        boolean enableHttp = config.toBoolean("enableHttp");
        boolean enableHttps = config.toBoolean("enableHttps");
        boolean enableRegistry = config.toBoolean("enableRegistry");
        boolean supportClient = config.toBoolean("supportClient");
        String dockerOrganization = config.toString("dockerOrganization");
        boolean overwriteHandler = config.toBoolean("overwriteHandler");
        boolean overwriteHandlerTest = config.toBoolean("overwriteHandlerTest");
        boolean overwriteModel = config.toBoolean("overwriteModel");
        String rootPackage = config.toString("rootPackage");
        String handlerPackage = config.toString("handlerPackage");
        String version = config.toString("version");
        if (dockerOrganization == null || dockerOrganization.length() == 0) {
            dockerOrganization = "networknt";
        }
        this.transfer(queryService2, "docker", "Dockerfile", dockerfile.template(config));
        this.transfer(queryService2, "docker", "Dockerfile-Redhat", templates.eventuate.rest.openapi.queryservice.dockerfileredhat.template(config));
        this.transfer(queryService2, "", "build.sh", buildSh.template(dockerOrganization, config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version")));
        this.transfer(queryService2, "", ".gitignore", gitignore.template());
        this.transfer(queryService2, "", "README.md", templates.eventuate.rest.openapi.queryservice.README.template());
        this.transfer(queryService2, "", "LICENSE", LICENSE.template());
        this.transfer(queryService2, "", ".classpath", classpath.template());
        this.transfer(queryService2, "", ".project", project.template(config));
        this.transfer(queryService2, "", "pom.xml", templates.eventuate.rest.openapi.queryservice.pom.template(config));
        this.transfer(queryService2, "src.main.resources.config".replace(".", File.separator), "service.yml", templates.eventuate.rest.openapi.queryservice.service.template(config));
        this.transfer(queryService2, "src.main.resources.config".replace(".", File.separator), "server.yml", server.template(config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version"), enableHttp, "8082", enableHttps, "8442", enableRegistry, version));
        this.transfer(queryService2, "src.test.resources.config".replace(".", File.separator), "server.yml", server.template(config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version"), enableHttp, "49587", enableHttps, "49588", enableRegistry, version));
        this.transfer(queryService2, "src.main.resources.config".replace(".", File.separator), "secret.yml", secret.template());
        this.transfer(queryService2, "src.main.resources.config".replace(".", File.separator), "openapi-security.yml", security.template());
        if (supportClient) {
            this.transfer(queryService2, "src.main.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        } else {
            this.transfer(queryService2, "src.test.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        }
        this.transfer(queryService2, "src.main.resources.config".replace(".", File.separator), "primary.crt", primaryCrt.template());
        this.transfer(queryService2, "src.main.resources.config".replace(".", File.separator), "secondary.crt", secondaryCrt.template());
        this.transfer(queryService2, "src.main.resources".replace(".", File.separator), "logback.xml", logback.template());
        this.transfer(queryService2, "src.test.resources".replace(".", File.separator), "logback-test.xml", logback.template());
        this.transfer(queryService2, "src.main.resources.config".replace(".", File.separator), "kafka.yml", kafka.template());
        this.transfer(queryService2, "src.main.resources.config".replace(".", File.separator), "eventuate-client.yml", eventuateClient.template());
        if (overwriteModel) {
            this.generateModule(queryService2, model2, config);
        }
        this.injectEndpoints(model2);
        List<Map<String, Object>> operationList = this.getOperationList(model2);
        this.transfer(queryService2, ("src.main.java." + rootPackage).replace(".", File.separator), "PathHandlerProvider.java", handlerProvider.template(rootPackage, handlerPackage, operationList, this.prometheusMetrics));
        if (overwriteHandler) {
            for (Map<String, Object> op : operationList) {
                String className = op.get("handlerName").toString();
                String example = null;
                if (op.get("example") != null) {
                    example = JsonStream.serialize(op.get("example"));
                }
                if ("ServerInfoGetHandler".equals(className) || "HealthGetHandler".equals(className) || "PrometheusGetHandler".equals(className)) continue;
                this.transfer(queryService2, ("src.main.java." + handlerPackage).replace(".", File.separator), className + ".java", handler.template(handlerPackage, className, example));
            }
        }
        this.transfer(queryService2, ("src.test.java." + handlerPackage + ".").replace(".", File.separator), "TestServer.java", testServer.template(handlerPackage));
        if (overwriteHandlerTest) {
            for (Map<String, Object> op : operationList) {
                this.transfer(queryService2, ("src.test.java." + handlerPackage).replace(".", File.separator), op.get("handlerName") + "Test.java", handlerTest.template(handlerPackage, op));
            }
        }
        try (InputStream is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/server.keystore");){
            Files.copy(is, Paths.get(queryService2, "src.main.resources.config".replace(".", File.separator), "server.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/server.truststore");
        var18_18 = null;
        try {
            Files.copy(is, Paths.get(queryService2, "src.main.resources.config".replace(".", File.separator), "server.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var18_18 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var18_18 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var18_18.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        if (supportClient) {
            is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/client.keystore");
            var18_18 = null;
            try {
                Files.copy(is, Paths.get(queryService2, "src.main.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var18_18 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var18_18 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var18_18.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/client.truststore");
            var18_18 = null;
            try {
                Files.copy(is, Paths.get(queryService2, "src.main.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var18_18 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var18_18 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var18_18.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/client.keystore");
        var18_18 = null;
        try {
            Files.copy(is, Paths.get(queryService2, "src.test.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var18_18 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var18_18 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var18_18.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        is = EventuateOpenApiGenerator.class.getResourceAsStream("/binaries/client.truststore");
        var18_18 = null;
        try {
            Files.copy(is, Paths.get(queryService2, "src.test.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var18_18 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var18_18 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var18_18.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        JsonStream.serialize(model2, new FileOutputStream(FileSystems.getDefault().getPath(queryService2, "src.main.resources.config".replace(".", File.separator), "openapi.json").toFile()));
    }

    public void generateModule(String path, Object model2, Any config) throws IOException {
        Any schemas;
        String modelPackage = config.toString("modelPackage");
        Any anyComponents = ((Any)model2).get((Object)"components");
        if (anyComponents.valueType() != ValueType.INVALID && (schemas = anyComponents.asMap().get("schemas")) != null && schemas.valueType() != ValueType.INVALID) {
            for (Map.Entry<String, Any> entry : schemas.asMap().entrySet()) {
                ArrayList<Map<String, Any>> props = new ArrayList<Map<String, Any>>();
                String key = entry.getKey();
                Map<String, Any> value = entry.getValue().asMap();
                String type = null;
                boolean isEnum = false;
                Map<String, Any> properties = null;
                List<Any> required = null;
                for (Map.Entry<String, Any> entrySchema : value.entrySet()) {
                    if ("type".equals(entrySchema.getKey()) && "enum".equals(type = entrySchema.getValue().toString())) {
                        isEnum = true;
                    }
                    if ("properties".equals(entrySchema.getKey())) {
                        properties = entrySchema.getValue().asMap();
                        for (Map.Entry<String, Any> entryProp : properties.entrySet()) {
                            HashMap<String, Object> propMap = new HashMap<String, Object>();
                            String name = entryProp.getKey();
                            propMap.put("jsonProperty", Any.wrap(name));
                            if (name.startsWith("@")) {
                                name = name.substring(1);
                            }
                            propMap.put("name", Any.wrap(name));
                            propMap.put("getter", Any.wrap("get" + name.substring(0, 1).toUpperCase() + name.substring(1)));
                            propMap.put("setter", Any.wrap("set" + name.substring(0, 1).toUpperCase() + name.substring(1)));
                            propMap.put("isEnum", Any.wrap(false));
                            boolean isArray = false;
                            for (Map.Entry<String, Any> entryElement : entryProp.getValue().asMap().entrySet()) {
                                Object t;
                                List<Any> list;
                                String s;
                                Any a;
                                if ("type".equals(entryElement.getKey())) {
                                    String t2 = this.typeMapping.get(entryElement.getValue().toString());
                                    if ("java.util.List".equals(t2)) {
                                        isArray = true;
                                    } else {
                                        propMap.put("type", Any.wrap(t2));
                                    }
                                }
                                if ("items".equals(entryElement.getKey())) {
                                    a = entryElement.getValue();
                                    if (a.get((Object)"$ref").valueType() != ValueType.INVALID && isArray) {
                                        String s2 = a.get((Object)"$ref").toString();
                                        s2 = s2.substring(s2.lastIndexOf(47) + 1);
                                        propMap.put("type", Any.wrap("java.util.List<" + s2 + ">"));
                                    }
                                    if (a.get((Object)"type").valueType() != ValueType.INVALID && isArray) {
                                        propMap.put("type", Any.wrap("java.util.List<" + this.typeMapping.get(a.get((Object)"type").toString()) + ">"));
                                    }
                                }
                                if ("$ref".equals(entryElement.getKey())) {
                                    s = entryElement.getValue().toString();
                                    s = s.substring(s.lastIndexOf(47) + 1);
                                    propMap.put("type", Any.wrap(s));
                                }
                                if ("default".equals(entryElement.getKey())) {
                                    a = entryElement.getValue();
                                    propMap.put("default", a);
                                }
                                if ("enum".equals(entryElement.getKey())) {
                                    propMap.put("isEnum", Any.wrap(true));
                                    propMap.put("nameWithEnum", Any.wrap(name.substring(0, 1).toUpperCase() + name.substring(1) + "Enum"));
                                    propMap.put("value", Any.wrap(entryElement.getValue()));
                                }
                                if ("format".equals(entryElement.getKey())) {
                                    s = entryElement.getValue().toString();
                                    if ("date-time".equals(s)) {
                                        propMap.put("type", Any.wrap("java.time.LocalDateTime"));
                                    }
                                    if ("date".equals(s)) {
                                        propMap.put("type", Any.wrap("java.time.LocalDate"));
                                    }
                                    if ("double".equals(s)) {
                                        propMap.put("type", Any.wrap(s));
                                    }
                                    if ("float".equals(s)) {
                                        propMap.put("type", Any.wrap(s));
                                    }
                                }
                                if ("oneOf".equals(entryElement.getKey())) {
                                    list = entryElement.getValue().asList();
                                    t = list.get(0).asMap().get("type").toString();
                                    if (t != null) {
                                        propMap.put("type", Any.wrap(this.typeMapping.get(t)));
                                    } else {
                                        propMap.put("type", Any.wrap("Object"));
                                    }
                                }
                                if ("anyOf".equals(entryElement.getKey())) {
                                    list = entryElement.getValue().asList();
                                    t = list.get(0).asMap().get("type").toString();
                                    if (t != null) {
                                        propMap.put("type", Any.wrap(this.typeMapping.get(t)));
                                    } else {
                                        propMap.put("type", Any.wrap("Object"));
                                    }
                                }
                                if ("allOf".equals(entryElement.getKey())) {
                                    list = entryElement.getValue().asList();
                                    t = list.get(0).asMap().get("type").toString();
                                    if (t != null) {
                                        propMap.put("type", Any.wrap(this.typeMapping.get(t)));
                                    } else {
                                        propMap.put("type", Any.wrap("Object"));
                                    }
                                }
                                if (!"not".equals(entryElement.getKey())) continue;
                                Map<String, Any> m = entryElement.getValue().asMap();
                                t = m.get("type");
                                if (t != null) {
                                    propMap.put("type", t);
                                    continue;
                                }
                                propMap.put("type", Any.wrap("Object"));
                            }
                            props.add(propMap);
                        }
                    }
                    if (!"required".equals(entrySchema.getKey())) continue;
                    required = entrySchema.getValue().asList();
                }
                String classVarName = key;
                String modelFileName = key.substring(0, 1).toUpperCase() + key.substring(1);
                this.transfer(path, ("src.main.java." + modelPackage).replace(".", File.separator), modelFileName + ".java", pojo.template(modelPackage, modelFileName, classVarName, props));
            }
        }
    }

    public void injectEndpoints(Object model2) {
        Any anyModel = (Any)model2;
        Map<String, Any> paths = anyModel.get((Object)"paths").asMap();
        Any components = anyModel.get((Object)"components");
        String authName = null;
        if (components != null) {
            Map<String, Any> cpMap = components.asMap();
            Map<String, Any> ssMap = cpMap.get("securitySchemes").asMap();
            for (String name : ssMap.keySet()) {
                Map<String, Any> def = ssMap.get(name).asMap();
                if (def == null || !"oauth2".equals(def.get("type").toString())) continue;
                authName = name;
                Map<String, Any> flows = def.get("flows").asMap();
                for (Map.Entry<String, Any> entry : flows.entrySet()) {
                    Any scopes;
                    Map<String, Any> oauthMap = entry.getValue().asMap();
                    if (oauthMap == null || (scopes = oauthMap.get("scopes")) == null) continue;
                    scopes.asMap().put("server.info.r", Any.wrap("read server info"));
                }
            }
        }
        HashMap<String, Cloneable> serverInfoMap = new HashMap<String, Cloneable>();
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("server.info.r");
        HashMap<String, ArrayList<String>> authMap = new HashMap<String, ArrayList<String>>();
        authMap.put(authName, scopes);
        ArrayList<HashMap<String, ArrayList<String>>> authList = new ArrayList<HashMap<String, ArrayList<String>>>();
        authList.add(authMap);
        serverInfoMap.put("security", authList);
        HashMap<String, String> descMap = new HashMap<String, String>();
        descMap.put("description", "successful operation");
        HashMap<String, HashMap<String, String>> codeMap = new HashMap<String, HashMap<String, String>>();
        codeMap.put("200", descMap);
        serverInfoMap.put("responses", codeMap);
        serverInfoMap.put("parameters", new ArrayList());
        HashMap<String, HashMap<String, Cloneable>> serverInfo = new HashMap<String, HashMap<String, Cloneable>>();
        serverInfo.put("get", serverInfoMap);
        paths.put("/server/info", Any.wrap(serverInfo));
        HashMap<String, Cloneable> healthMap = new HashMap<String, Cloneable>();
        healthMap.put("responses", codeMap);
        healthMap.put("parameters", new ArrayList());
        HashMap<String, HashMap<String, Cloneable>> health = new HashMap<String, HashMap<String, Cloneable>>();
        health.put("get", healthMap);
        paths.put("/health", Any.wrap(health));
        if (this.prometheusMetrics) {
            HashMap<String, Cloneable> prometheusMap = new HashMap<String, Cloneable>();
            prometheusMap.put("responses", codeMap);
            prometheusMap.put("parameters", new ArrayList());
            HashMap<String, HashMap<String, Cloneable>> prometheus = new HashMap<String, HashMap<String, Cloneable>>();
            prometheus.put("get", prometheusMap);
            paths.put("/prometheus", Any.wrap(prometheus));
        }
    }

    public List<Map<String, Object>> getOperationList(Object model2) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String s = ((Any)model2).toString();
        OpenApi3 openApi3 = null;
        try {
            openApi3 = (OpenApi3)new OpenApiParser().parse(s, new URL("https://oas.lightapi.net/"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String basePath = EventuateOpenApiGenerator.getBasePath(openApi3);
        Map<String, Path> paths = openApi3.getPaths();
        for (Map.Entry<String, Path> entryPath : paths.entrySet()) {
            String path = entryPath.getKey();
            Path pathValue = entryPath.getValue();
            for (Map.Entry<String, Operation> entryOps : pathValue.getOperations().entrySet()) {
                MediaType mediaType;
                if (entryOps.getKey().startsWith("x-")) continue;
                HashMap<String, Object> flattened = new HashMap<String, Object>();
                flattened.put("method", entryOps.getKey().toUpperCase());
                flattened.put("capMethod", entryOps.getKey().substring(0, 1).toUpperCase() + entryOps.getKey().substring(1));
                flattened.put("path", basePath + path);
                String normalizedPath = path.replace("{", "").replace("}", "");
                flattened.put("normalizedPath", basePath + normalizedPath);
                flattened.put("handlerName", Utils.camelize(normalizedPath) + Utils.camelize(entryOps.getKey()) + "Handler");
                Operation operation = entryOps.getValue();
                Response response = operation.getResponse("200");
                if (response != null && (mediaType = response.getContentMediaType("application/json")) != null) {
                    Object example = mediaType.getExample();
                    if (example != null) {
                        flattened.put("example", example);
                    } else {
                        Map.Entry<String, Example> entry;
                        Example e;
                        Map<String, Example> exampleMap = mediaType.getExamples();
                        if (exampleMap.size() > 0 && (e = (entry = exampleMap.entrySet().iterator().next()).getValue()) != null) {
                            flattened.put("example", e.getValue());
                        }
                    }
                }
                result.add(flattened);
            }
        }
        return result;
    }

    private static String getBasePath(OpenApi3 openApi3) {
        int protocolIndex;
        int pathIndex;
        String basePath = "";
        Server server2 = openApi3.getServer(0);
        String url = server2.getUrl();
        if (url != null && (pathIndex = url.indexOf(47, (protocolIndex = url.indexOf("://")) + 3)) > 0) {
            basePath = url.substring(pathIndex);
        }
        return basePath;
    }
}

