/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public abstract class Config {
    public static final String LIGHT_4J_CONFIG_DIR = "light-4j-config-dir";

    protected Config() {
    }

    public abstract Map<String, Object> getJsonMapConfig(String var1);

    public abstract Map<String, Object> getJsonMapConfigNoCache(String var1);

    public abstract Object getJsonObjectConfig(String var1, Class var2);

    public abstract String getStringFromFile(String var1);

    public abstract InputStream getInputStreamFromFile(String var1);

    public abstract ObjectMapper getMapper();

    public abstract Yaml getYaml();

    public abstract void clear();

    public static Config getInstance() {
        return FileConfigImpl.DEFAULT;
    }

    static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private static final class FileConfigImpl
    extends Config {
        static final String CONFIG_EXT_JSON = ".json";
        static final String CONFIG_EXT_YAML = ".yaml";
        static final String CONFIG_EXT_YML = ".yml";
        static final Logger logger = LoggerFactory.getLogger(Config.class);
        public final String EXTERNALIZED_PROPERTY_DIR = System.getProperty("light-4j-config-dir", "");
        private long cacheExpirationTime = 0L;
        private static final Config DEFAULT = FileConfigImpl.initialize();
        final Map<String, Object> configCache = new ConcurrentHashMap<String, Object>(10, 0.9f, 1);
        static final ObjectMapper mapper = new ObjectMapper();
        final Yaml yaml = new Yaml();

        private FileConfigImpl() {
        }

        private static Config initialize() {
            Iterator<Config> it = ServiceLoader.load(Config.class).iterator();
            return it.hasNext() ? it.next() : new FileConfigImpl();
        }

        @Override
        public ObjectMapper getMapper() {
            return mapper;
        }

        @Override
        public Yaml getYaml() {
            return this.yaml;
        }

        @Override
        public void clear() {
            this.configCache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getStringFromFile(String filename) {
            this.checkCacheExpiration();
            String content = (String)this.configCache.get(filename);
            if (content != null) return content;
            Class<FileConfigImpl> clazz = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                content = (String)this.configCache.get(filename);
                if (content != null || (content = this.loadStringFromFile(filename)) == null) return content;
                this.configCache.put(filename, content);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return content;
            }
        }

        @Override
        public InputStream getInputStreamFromFile(String filename) {
            return this.getConfigStream(filename);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getJsonObjectConfig(String configName, Class clazz) {
            this.checkCacheExpiration();
            Object config = this.configCache.get(configName);
            if (config != null) return config;
            Class<FileConfigImpl> clazz2 = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                config = this.configCache.get(configName);
                if (config != null || (config = this.loadObjectConfig(configName, clazz)) == null) return config;
                this.configCache.put(configName, config);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return config;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Map<String, Object> getJsonMapConfig(String configName) {
            this.checkCacheExpiration();
            Map<String, Object> config = (Map<String, Object>)this.configCache.get(configName);
            if (config != null) return config;
            Class<FileConfigImpl> clazz = FileConfigImpl.class;
            synchronized (FileConfigImpl.class) {
                config = (Map)this.configCache.get(configName);
                if (config != null || (config = this.loadMapConfig(configName)) == null) return config;
                this.configCache.put(configName, config);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return config;
            }
        }

        @Override
        public Map<String, Object> getJsonMapConfigNoCache(String configName) {
            return this.loadMapConfig(configName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String loadStringFromFile(String filename) {
            String content = null;
            InputStream inStream = null;
            try {
                inStream = this.getConfigStream(filename);
                if (inStream != null) {
                    content = FileConfigImpl.convertStreamToString(inStream);
                }
            }
            catch (Exception ioe) {
                logger.error("Exception", ioe);
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ioe) {
                        logger.error("IOException", ioe);
                    }
                }
            }
            return content;
        }

        private Object loadObjectConfig(String configName, Class clazz) {
            Object config = null;
            String ymlFilename = configName + CONFIG_EXT_YML;
            try (InputStream inStream = this.getConfigStream(ymlFilename);){
                if (inStream != null) {
                    config = this.yaml.loadAs(inStream, clazz);
                }
            }
            catch (IOException ioe) {
                logger.error("IOException", ioe);
            }
            if (config != null) {
                return config;
            }
            String yamlFilename = configName + CONFIG_EXT_YAML;
            try (InputStream inStream = this.getConfigStream(yamlFilename);){
                if (inStream != null) {
                    config = this.yaml.loadAs(inStream, clazz);
                }
            }
            catch (IOException ioe) {
                logger.error("IOException", ioe);
            }
            if (config != null) {
                return config;
            }
            String jsonFilename = configName + CONFIG_EXT_JSON;
            try (InputStream inStream = this.getConfigStream(jsonFilename);){
                if (inStream != null) {
                    config = mapper.readValue(inStream, clazz);
                }
            }
            catch (IOException ioe) {
                logger.error("IOException", ioe);
            }
            return config;
        }

        private Map<String, Object> loadMapConfig(String configName) {
            Map config = null;
            String ymlFilename = configName + CONFIG_EXT_YML;
            try (InputStream inStream = this.getConfigStream(ymlFilename);){
                if (inStream != null) {
                    config = (Map)this.yaml.load(inStream);
                }
            }
            catch (IOException ioe) {
                logger.error("IOException", ioe);
            }
            if (config != null) {
                return config;
            }
            String yamlFilename = configName + CONFIG_EXT_YAML;
            try (InputStream inStream = this.getConfigStream(yamlFilename);){
                if (inStream != null) {
                    config = (Map)this.yaml.load(inStream);
                }
            }
            catch (IOException ioe) {
                logger.error("IOException", ioe);
            }
            if (config != null) {
                return config;
            }
            String configFilename = configName + CONFIG_EXT_JSON;
            try (InputStream inStream = this.getConfigStream(configFilename);){
                if (inStream != null) {
                    config = (Map)mapper.readValue(inStream, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                }
            }
            catch (IOException ioe) {
                logger.error("IOException", ioe);
            }
            return config;
        }

        private InputStream getConfigStream(String configFilename) {
            InputStream inStream;
            block13: {
                inStream = null;
                try {
                    inStream = new FileInputStream(this.EXTERNALIZED_PROPERTY_DIR + "/" + configFilename);
                }
                catch (FileNotFoundException ex) {
                    if (!logger.isInfoEnabled()) break block13;
                    logger.info("Unable to load config from externalized folder for " + Encode.forJava(configFilename + " in " + this.EXTERNALIZED_PROPERTY_DIR));
                }
            }
            if (inStream != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Config loaded from externalized folder for " + Encode.forJava(configFilename + " in " + this.EXTERNALIZED_PROPERTY_DIR));
                }
                return inStream;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Trying to load config from classpath directory for file " + Encode.forJava(configFilename));
            }
            if ((inStream = this.getClass().getClassLoader().getResourceAsStream(configFilename)) != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("config loaded from classpath for " + Encode.forJava(configFilename));
                }
                return inStream;
            }
            inStream = this.getClass().getClassLoader().getResourceAsStream("config/" + configFilename);
            if (inStream != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Config loaded from default folder for " + Encode.forJava(configFilename));
                }
                return inStream;
            }
            if (configFilename.endsWith(CONFIG_EXT_YML)) {
                logger.info("Unable to load config " + Encode.forJava(configFilename) + ". Looking for the same file name with extension yaml...");
            } else if (configFilename.endsWith(CONFIG_EXT_YAML)) {
                logger.info("Unable to load config " + Encode.forJava(configFilename) + ". Looking for the same file name with extension json...");
            } else {
                logger.error("Unable to load config '" + Encode.forJava(configFilename.substring(0, configFilename.indexOf("."))) + "' with extension yml, yaml and json from external config, application config and module config");
            }
            return null;
        }

        private static long getNextMidNightTime() {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            ((Calendar)cal).add(5, 1);
            return cal.getTimeInMillis();
        }

        private void checkCacheExpiration() {
            if (System.currentTimeMillis() > this.cacheExpirationTime) {
                this.clear();
                logger.info("daily config cache refresh");
                this.cacheExpirationTime = FileConfigImpl.getNextMidNightTime();
            }
        }

        static {
            mapper.registerModule(new JavaTimeModule());
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        }
    }
}

