/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.jsonoverlay.IJsonOverlay;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.RefOverlay;
import com.networknt.jsonoverlay.Reference;
import com.networknt.jsonoverlay.ReferenceManager;

public abstract class OverlayFactory<V> {
    private final Class<? extends IJsonOverlay<? super V>> overlayClass = this.getOverlayClass();

    public JsonOverlay<V> create(V value, JsonOverlay<?> parent, ReferenceManager refMgr) {
        JsonOverlay<V> overlay = this._create(value, parent, refMgr);
        overlay._elaborate(true);
        return overlay;
    }

    public JsonOverlay<V> create(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
        JsonOverlay<Object> overlay;
        if (Reference.isReferenceNode(json)) {
            Reference reference = refMgr.getReference(json);
            RefOverlay refOverlay = new RefOverlay(reference, null, this, refMgr);
            overlay = refOverlay.getOverlay();
            if (overlay == null) {
                overlay = this._create((V)null, parent, refMgr);
            }
            if (overlay != null) {
                overlay = overlay._getFactory()._create(null, parent, refMgr);
                overlay._setReference(refOverlay);
            }
        } else {
            JsonOverlay<?> existing = refMgr.getRegistry().getOverlay(json, this.getSignature());
            if (existing != null) {
                overlay = existing;
                if (parent != null) {
                    overlay._setParent(parent);
                }
            } else {
                overlay = this._create(json, parent, refMgr);
                overlay._setParent(parent);
                refMgr.getRegistry().register(json, this.getSignature(), overlay);
                if (!overlay._isElaborated()) {
                    overlay._elaborate(true);
                }
            }
        }
        return overlay;
    }

    public boolean isCompatible(JsonOverlay<?> overlay) {
        return this.overlayClass.isAssignableFrom(overlay.getClass());
    }

    public String getSignature() {
        return this.getOverlayClass().getSimpleName();
    }

    protected boolean isExtendedType() {
        return false;
    }

    protected abstract Class<? extends JsonOverlay<? super V>> getOverlayClass();

    protected abstract JsonOverlay<V> _create(V var1, JsonOverlay<?> var2, ReferenceManager var3);

    protected abstract JsonOverlay<V> _create(JsonNode var1, JsonOverlay<?> var2, ReferenceManager var3);
}

