/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.Internal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@Internal
public class ExecutionResultImpl
implements ExecutionResult {
    private final Object data;
    private final List<GraphQLError> errors;
    private final transient boolean dataPresent;
    private final transient Map<Object, Object> extensions;

    public ExecutionResultImpl(GraphQLError error) {
        this(false, null, Collections.singletonList(error), null);
    }

    public ExecutionResultImpl(List<? extends GraphQLError> errors) {
        this(false, null, errors, null);
    }

    public ExecutionResultImpl(Object data, List<? extends GraphQLError> errors) {
        this(true, data, errors, null);
    }

    public ExecutionResultImpl(Object data, List<? extends GraphQLError> errors, Map<Object, Object> extensions) {
        this(true, data, errors, extensions);
    }

    private ExecutionResultImpl(boolean dataPresent, Object data, List<? extends GraphQLError> errors, Map<Object, Object> extensions) {
        this.dataPresent = dataPresent;
        this.data = data;
        this.errors = errors != null && !errors.isEmpty() ? Collections.unmodifiableList(new ArrayList<GraphQLError>(errors)) : Collections.emptyList();
        this.extensions = extensions;
    }

    public boolean isDataPresent() {
        return this.dataPresent;
    }

    @Override
    public <T> T getData() {
        return (T)this.data;
    }

    @Override
    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    @Override
    public Map<Object, Object> getExtensions() {
        return this.extensions;
    }

    @Override
    public Map<String, Object> toSpecification() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.dataPresent) {
            result.put("data", this.data);
        }
        if (this.errors != null && !this.errors.isEmpty()) {
            result.put("errors", this.errorsToSpec(this.errors));
        }
        if (this.extensions != null) {
            result.put("extensions", this.extensions);
        }
        return result;
    }

    private Object errorsToSpec(List<GraphQLError> errors) {
        return errors.stream().map(GraphQLError::toSpecification).collect(Collectors.toList());
    }

    public String toString() {
        return "ExecutionResultImpl{data=" + this.data + ", errors=" + this.errors + ", dataPresent=" + this.dataPresent + ", extensions=" + this.extensions + '}';
    }

    public ExecutionResultImpl transform(Consumer<Builder> builderConsumer) {
        Builder builder = ExecutionResultImpl.newExecutionResult().from(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newExecutionResult() {
        return new Builder();
    }

    public static class Builder {
        private boolean dataPresent;
        private Object data;
        private List<GraphQLError> errors = new ArrayList<GraphQLError>();
        private Map<Object, Object> extensions;

        public Builder from(ExecutionResultImpl executionResult) {
            this.dataPresent = executionResult.isDataPresent();
            this.data = executionResult.getData();
            this.errors = new ArrayList<GraphQLError>(executionResult.getErrors());
            this.extensions = executionResult.getExtensions();
            return this;
        }

        public Builder data(Object data) {
            this.dataPresent = true;
            this.data = data;
            return this;
        }

        public Builder errors(List<GraphQLError> errors) {
            this.errors = errors;
            return this;
        }

        public Builder addErrors(List<GraphQLError> errors) {
            this.errors.addAll(errors);
            return this;
        }

        public Builder addError(GraphQLError error) {
            this.errors.add(error);
            return this;
        }

        public Builder extensions(Map<Object, Object> extensions) {
            this.extensions = extensions;
            return this;
        }

        public Builder addExtension(String key, Object value) {
            this.extensions = this.extensions == null ? new LinkedHashMap() : this.extensions;
            this.extensions.put(key, value);
            return this;
        }

        public ExecutionResultImpl build() {
            return new ExecutionResultImpl(this.dataPresent, this.data, this.errors, this.extensions);
        }
    }
}

