/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Definition;
import graphql.language.Description;
import graphql.language.DirectiveLocation;
import graphql.language.InputValueDefinition;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;

public class DirectiveDefinition
extends AbstractNode<DirectiveDefinition>
implements Definition<DirectiveDefinition> {
    private final String name;
    private Description description;
    private final List<InputValueDefinition> inputValueDefinitions;
    private final List<DirectiveLocation> directiveLocations;

    public DirectiveDefinition(String name) {
        this(name, new ArrayList<InputValueDefinition>(), new ArrayList<DirectiveLocation>());
    }

    public DirectiveDefinition(String name, List<InputValueDefinition> inputValueDefinitions, List<DirectiveLocation> directiveLocations) {
        this.name = name;
        this.inputValueDefinitions = inputValueDefinitions;
        this.directiveLocations = directiveLocations;
    }

    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public List<InputValueDefinition> getInputValueDefinitions() {
        return this.inputValueDefinitions;
    }

    public List<DirectiveLocation> getDirectiveLocations() {
        return this.directiveLocations;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.inputValueDefinitions);
        result.addAll(this.directiveLocations);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectiveDefinition that = (DirectiveDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public DirectiveDefinition deepCopy() {
        return new DirectiveDefinition(this.name, this.deepCopy(this.inputValueDefinitions), this.deepCopy(this.directiveLocations));
    }

    public String toString() {
        return "DirectiveDefinition{name='" + this.name + "', inputValueDefinitions=" + this.inputValueDefinitions + ", directiveLocations=" + this.directiveLocations + "}";
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitDirectiveDefinition(this, context);
    }
}

