/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.OperationTypeDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SchemaDefinition
extends AbstractNode<SchemaDefinition>
implements Definition<SchemaDefinition> {
    private final List<Directive> directives;
    private final List<OperationTypeDefinition> operationTypeDefinitions;

    public SchemaDefinition() {
        this(new ArrayList<Directive>(), new ArrayList<OperationTypeDefinition>());
    }

    public SchemaDefinition(List<Directive> directives, List<OperationTypeDefinition> operationTypeDefinitions) {
        this.directives = directives;
        this.operationTypeDefinitions = operationTypeDefinitions;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public List<OperationTypeDefinition> getOperationTypeDefinitions() {
        return this.operationTypeDefinitions;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        result.addAll(this.operationTypeDefinitions);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaDefinition that = (SchemaDefinition)o;
        return true;
    }

    @Override
    public SchemaDefinition deepCopy() {
        return new SchemaDefinition(this.deepCopy(this.directives), this.deepCopy(this.operationTypeDefinitions));
    }

    public String toString() {
        return "SchemaDefinition{directives=" + this.directives + ", operationTypeDefinitions=" + this.operationTypeDefinitions + "}";
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitSchemaDefinition(this, context);
    }
}

