/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLDirective {
    private final String name;
    private final String description;
    private final EnumSet<Introspection.DirectiveLocation> locations;
    private final List<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
    private final boolean onOperation;
    private final boolean onFragment;
    private final boolean onField;

    public GraphQLDirective(String name, String description, EnumSet<Introspection.DirectiveLocation> locations, List<GraphQLArgument> arguments, boolean onOperation, boolean onFragment, boolean onField) {
        Assert.assertValidName(name);
        Assert.assertNotNull(arguments, "arguments can't be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.locations = locations;
        this.arguments.addAll(arguments);
        this.onOperation = onOperation;
        this.onFragment = onFragment;
        this.onField = onField;
    }

    public String getName() {
        return this.name;
    }

    public List<GraphQLArgument> getArguments() {
        return new ArrayList<GraphQLArgument>(this.arguments);
    }

    public GraphQLArgument getArgument(String name) {
        for (GraphQLArgument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    public EnumSet<Introspection.DirectiveLocation> validLocations() {
        return this.locations;
    }

    @Deprecated
    public boolean isOnOperation() {
        return this.onOperation;
    }

    @Deprecated
    public boolean isOnFragment() {
        return this.onFragment;
    }

    @Deprecated
    public boolean isOnField() {
        return this.onField;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "GraphQLDirective{name='" + this.name + '\'' + ", arguments=" + this.arguments + ", locations=" + this.locations + '}';
    }

    public static Builder newDirective() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private final EnumSet<Introspection.DirectiveLocation> locations = EnumSet.noneOf(Introspection.DirectiveLocation.class);
        private final List<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
        private String description;
        private boolean onOperation;
        private boolean onFragment;
        private boolean onField;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder validLocations(Introspection.DirectiveLocation ... validLocations) {
            Collections.addAll(this.locations, validLocations);
            return this;
        }

        public Builder argument(GraphQLArgument fieldArgument) {
            this.arguments.add(fieldArgument);
            return this;
        }

        public Builder argument(UnaryOperator<GraphQLArgument.Builder> builderFunction) {
            GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
            builder = (GraphQLArgument.Builder)builderFunction.apply(builder);
            return this.argument(builder);
        }

        public Builder argument(GraphQLArgument.Builder builder) {
            this.arguments.add(builder.build());
            return this;
        }

        @Deprecated
        public Builder onOperation(boolean onOperation) {
            this.onOperation = onOperation;
            return this;
        }

        @Deprecated
        public Builder onFragment(boolean onFragment) {
            this.onFragment = onFragment;
            return this;
        }

        @Deprecated
        public Builder onField(boolean onField) {
            this.onField = onField;
            return this;
        }

        public GraphQLDirective build() {
            return new GraphQLDirective(this.name, this.description, this.locations, this.arguments, this.onOperation, this.onFragment, this.onField);
        }
    }
}

