/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.ScalarTypeDefinition;
import graphql.schema.Coercing;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GraphQLScalarType
implements GraphQLType,
GraphQLInputType,
GraphQLOutputType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Coercing coercing;
    private final ScalarTypeDefinition definition;
    private final List<GraphQLDirective> directives;

    @Internal
    public GraphQLScalarType(String name, String description, Coercing coercing) {
        this(name, description, coercing, Collections.emptyList(), null);
    }

    @Internal
    public GraphQLScalarType(String name, String description, Coercing coercing, List<GraphQLDirective> directives, ScalarTypeDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(coercing, "coercing can't be null", new Object[0]);
        Assert.assertNotNull(directives, "directives can't be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.coercing = coercing;
        this.definition = definition;
        this.directives = directives;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Coercing getCoercing() {
        return this.coercing;
    }

    public ScalarTypeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public String toString() {
        return "GraphQLScalarType{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", coercing=" + this.coercing + '}';
    }

    public static Builder newScalar() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private String name;
        private String description;
        private Coercing coercing;
        private ScalarTypeDefinition definition;
        private final List<GraphQLDirective> directives = new ArrayList<GraphQLDirective>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder definition(ScalarTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            Collections.addAll(this.directives, directives);
            return this;
        }

        public GraphQLScalarType build() {
            return new GraphQLScalarType(this.name, this.description, this.coercing, this.directives, this.definition);
        }
    }
}

