/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Binding;
import com.jsoniter.spi.ClassDescriptor;
import com.jsoniter.spi.ClassInfo;
import com.jsoniter.spi.EncodeTo;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.OmitValue;
import com.jsoniter.spi.UnwrapperDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ReflectionObjectEncoder
implements Encoder.ReflectionEncoder {
    private final ClassDescriptor desc;
    private final List<EncodeTo> fields = new ArrayList<EncodeTo>();
    private final List<EncodeTo> getters = new ArrayList<EncodeTo>();

    public ReflectionObjectEncoder(ClassInfo classInfo) {
        this.desc = ClassDescriptor.getEncodingClassDescriptor(classInfo, true);
        for (EncodeTo encodeTo : this.desc.encodeTos()) {
            Binding binding = encodeTo.binding;
            if (binding.encoder == null) {
                binding.encoder = JsoniterSpi.getEncoder(binding.encoderCacheKey());
            }
            if (binding.field != null) {
                this.fields.add(encodeTo);
                continue;
            }
            this.getters.add(encodeTo);
        }
    }

    @Override
    public void encode(Object obj, JsonStream stream) throws IOException {
        try {
            this.enocde_(obj, stream);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    @Override
    public Any wrap(Object obj) {
        HashMap<String, Object> copied = new HashMap<String, Object>();
        try {
            Object val;
            for (EncodeTo encodeTo : this.fields) {
                val = encodeTo.binding.field.get(obj);
                copied.put(encodeTo.toName, val);
            }
            for (EncodeTo getter : this.getters) {
                val = getter.binding.method.invoke(obj, new Object[0]);
                copied.put(getter.toName, val);
            }
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
        return Any.wrap(copied);
    }

    private void enocde_(Object obj, JsonStream stream) throws Exception {
        Object val;
        if (obj == null) {
            stream.writeNull();
            return;
        }
        stream.writeObjectStart();
        boolean notFirst = false;
        for (EncodeTo encodeTo : this.fields) {
            val = encodeTo.binding.field.get(obj);
            notFirst = this.writeEncodeTo(stream, notFirst, encodeTo, val);
        }
        for (EncodeTo encodeTo : this.getters) {
            val = encodeTo.binding.method.invoke(obj, new Object[0]);
            notFirst = this.writeEncodeTo(stream, notFirst, encodeTo, val);
        }
        for (UnwrapperDescriptor unwrapper : this.desc.unwrappers) {
            if (unwrapper.isMap) {
                Map map = (Map)unwrapper.method.invoke(obj, new Object[0]);
                for (Map.Entry entry : map.entrySet()) {
                    if (notFirst) {
                        stream.writeMore();
                    } else {
                        notFirst = true;
                    }
                    stream.writeObjectField(entry.getKey().toString());
                    stream.writeVal(unwrapper.mapValueTypeLiteral, entry.getValue());
                }
                continue;
            }
            if (notFirst) {
                stream.writeMore();
            } else {
                notFirst = true;
            }
            unwrapper.method.invoke(obj, stream);
        }
        if (notFirst) {
            stream.writeObjectEnd();
        } else {
            stream.write(125);
        }
    }

    private boolean writeEncodeTo(JsonStream stream, boolean notFirst, EncodeTo encodeTo, Object val) throws IOException {
        OmitValue defaultValueToOmit = encodeTo.binding.defaultValueToOmit;
        if (defaultValueToOmit == null || !defaultValueToOmit.shouldOmit(val)) {
            if (notFirst) {
                stream.writeMore();
            } else {
                stream.writeIndention();
                notFirst = true;
            }
            stream.writeObjectField(encodeTo.toName);
            if (encodeTo.binding.encoder != null) {
                encodeTo.binding.encoder.encode(val, stream);
            } else {
                stream.writeVal(val);
            }
        }
        return notFirst;
    }
}

