/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.rest;

import com.jsoniter.JsonIterator;
import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.networknt.codegen.Generator;
import com.networknt.codegen.Utils;
import com.networknt.jsonoverlay.Overlay;
import com.networknt.oas.OpenApiParser;
import com.networknt.oas.model.Example;
import com.networknt.oas.model.MediaType;
import com.networknt.oas.model.OpenApi3;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Parameter;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.Response;
import com.networknt.oas.model.Schema;
import com.networknt.oas.model.Server;
import com.networknt.oas.model.impl.OpenApi3Impl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import templates.rest.LICENSE;
import templates.rest.README;
import templates.rest.buildSh;
import templates.rest.classpath;
import templates.rest.clientYml;
import templates.rest.dockerfile;
import templates.rest.dockerfileredhat;
import templates.rest.enumClass;
import templates.rest.gitignore;
import templates.rest.handler;
import templates.rest.logback;
import templates.rest.openapi.handlerTest;
import templates.rest.openapi.handlerYml;
import templates.rest.openapi.pom;
import templates.rest.openapi.service;
import templates.rest.openapiSecurity;
import templates.rest.openapiValidator;
import templates.rest.pojo;
import templates.rest.primaryCrt;
import templates.rest.project;
import templates.rest.secondaryCrt;
import templates.rest.secret;
import templates.rest.server;
import templates.rest.testServer;

public class OpenApiGenerator
implements Generator {
    private Map<String, String> typeMapping = new HashMap<String, String>();
    boolean prometheusMetrics = false;
    boolean skipHealthCheck = false;
    boolean skipServerInfo = false;
    boolean specChangeCodeReGenOnly = false;
    boolean enableParamDescription = true;

    public OpenApiGenerator() {
        this.typeMapping.put("array", "java.util.List");
        this.typeMapping.put("map", "java.util.Map");
        this.typeMapping.put("List", "java.util.List");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "java.math.BigDecimal");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("binary", "byte[]");
    }

    @Override
    public String getFramework() {
        return "openapi";
    }

    @Override
    public void generate(String targetPath, Object model2, Any config) throws IOException {
        Iterator<Map<String, Object>> schemas;
        Any anyComponents;
        String rootPackage = config.toString("rootPackage");
        String modelPackage = config.toString("modelPackage");
        String handlerPackage = config.toString("handlerPackage");
        boolean overwriteHandler = config.toBoolean("overwriteHandler");
        boolean overwriteHandlerTest = config.toBoolean("overwriteHandlerTest");
        boolean overwriteModel = config.toBoolean("overwriteModel");
        boolean enableHttp = config.toBoolean("enableHttp");
        String httpPort = config.toString("httpPort");
        boolean enableHttps = config.toBoolean("enableHttps");
        String httpsPort = config.toString("httpsPort");
        boolean enableRegistry = config.toBoolean("enableRegistry");
        boolean supportClient = config.toBoolean("supportClient");
        String dockerOrganization = config.toString("dockerOrganization");
        this.prometheusMetrics = config.toBoolean("prometheusMetrics");
        this.skipHealthCheck = config.toBoolean("skipHealthCheck");
        this.skipServerInfo = config.toBoolean("skipServerInfo");
        this.specChangeCodeReGenOnly = config.toBoolean("specChangeCodeReGenOnly");
        this.enableParamDescription = config.toBoolean("enableParamDescription");
        String version = config.toString("version");
        String serviceId = config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version");
        if (dockerOrganization == null || dockerOrganization.length() == 0) {
            dockerOrganization = "networknt";
        }
        if (!this.specChangeCodeReGenOnly) {
            this.transfer(targetPath, "", "pom.xml", pom.template(config));
            String expose = "";
            expose = enableHttps ? httpsPort : httpPort;
            this.transfer(targetPath, "docker", "Dockerfile", dockerfile.template(config, expose));
            this.transfer(targetPath, "docker", "Dockerfile-Redhat", dockerfileredhat.template(config, expose));
            this.transfer(targetPath, "", "build.sh", buildSh.template(dockerOrganization, serviceId));
            this.transfer(targetPath, "", ".gitignore", gitignore.template());
            this.transfer(targetPath, "", "README.md", README.template());
            this.transfer(targetPath, "", "LICENSE", LICENSE.template());
            this.transfer(targetPath, "", ".classpath", classpath.template());
            this.transfer(targetPath, "", ".project", project.template(config));
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", service.template(config));
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "server.yml", server.template(serviceId, enableHttp, httpPort, enableHttps, httpsPort, enableRegistry, version));
            this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "server.yml", server.template(serviceId, enableHttp, "49587", enableHttps, "49588", enableRegistry, version));
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secret.yml", secret.template());
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "openapi-security.yml", openapiSecurity.template());
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "openapi-validator.yml", openapiValidator.template());
            if (supportClient) {
                this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
            } else {
                this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
            }
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "primary.crt", primaryCrt.template());
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secondary.crt", secondaryCrt.template());
            this.transfer(targetPath, "src.main.resources".replace(".", File.separator), "logback.xml", logback.template());
            this.transfer(targetPath, "src.test.resources".replace(".", File.separator), "logback-test.xml", logback.template());
        }
        List<Map<String, Object>> operationList = this.getOperationList(model2);
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "handler.yml", handlerYml.template(serviceId, handlerPackage, operationList, this.prometheusMetrics, !this.skipHealthCheck, !this.skipServerInfo));
        if (model2 instanceof Any) {
            anyComponents = ((Any)model2).get((Object)"components");
        } else if (model2 instanceof String) {
            OpenApi3 openApi3 = null;
            try {
                openApi3 = (OpenApi3)new OpenApiParser().parse((String)model2, new URL("https://oas.lightapi.net/"));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to parse the model", e);
            }
            anyComponents = JsonIterator.deserialize(Overlay.toJson((OpenApi3Impl)openApi3).toString()).get((Object)"components");
        } else {
            throw new RuntimeException("Invalid Model Class: " + model2.getClass());
        }
        if (anyComponents.valueType() != ValueType.INVALID && (schemas = anyComponents.asMap().get("schemas")) != null && ((Any)((Object)schemas)).valueType() != ValueType.INVALID) {
            for (Map.Entry<String, Any> entry : ((Any)((Object)schemas)).asMap().entrySet()) {
                ArrayList<Map<String, Any>> props = new ArrayList<Map<String, Any>>();
                String key = entry.getKey();
                Map<String, Any> value = entry.getValue().asMap();
                String type = null;
                String enums = null;
                boolean isEnum = false;
                boolean isEnumClass = false;
                Map<String, Any> properties = null;
                List<Any> required = null;
                for (Map.Entry<String, Any> entrySchema : value.entrySet()) {
                    if ("type".equals(entrySchema.getKey()) && "enum".equals(type = entrySchema.getValue().toString())) {
                        isEnum = true;
                    }
                    if ("enum".equals(entrySchema.getKey())) {
                        isEnumClass = true;
                        enums = entrySchema.getValue().asList().toString();
                        enums = enums.substring(enums.indexOf("[") + 1, enums.indexOf("]"));
                    }
                    if ("properties".equals(entrySchema.getKey())) {
                        properties = entrySchema.getValue().asMap();
                        for (Map.Entry<String, Any> entryProp : properties.entrySet()) {
                            HashMap<String, Any> propMap = new HashMap<String, Any>();
                            String name = entryProp.getKey();
                            name = name.trim().replaceAll(" ", "_");
                            propMap.put("jsonProperty", Any.wrap(name));
                            if (name.startsWith("@")) {
                                name = name.substring(1);
                            }
                            propMap.put("name", Any.wrap(name));
                            propMap.put("getter", Any.wrap("get" + name.substring(0, 1).toUpperCase() + name.substring(1)));
                            propMap.put("setter", Any.wrap("set" + name.substring(0, 1).toUpperCase() + name.substring(1)));
                            propMap.put("isEnum", Any.wrap(false));
                            boolean isArray = false;
                            for (Map.Entry<String, Any> entryElement : entryProp.getValue().asMap().entrySet()) {
                                Any t;
                                List<Any> list;
                                String s;
                                Any a;
                                if ("type".equals(entryElement.getKey())) {
                                    String t2 = this.typeMapping.get(entryElement.getValue().toString());
                                    if ("java.util.List".equals(t2)) {
                                        isArray = true;
                                    } else {
                                        propMap.putIfAbsent("type", Any.wrap(t2));
                                    }
                                }
                                if ("items".equals(entryElement.getKey())) {
                                    a = entryElement.getValue();
                                    if (a.get((Object)"$ref").valueType() != ValueType.INVALID && isArray) {
                                        String s2 = a.get((Object)"$ref").toString();
                                        s2 = s2.substring(s2.lastIndexOf(47) + 1);
                                        propMap.put("type", Any.wrap("java.util.List<" + s2 + ">"));
                                    }
                                    if (a.get((Object)"type").valueType() != ValueType.INVALID && isArray) {
                                        propMap.put("type", Any.wrap("java.util.List<" + this.typeMapping.get(a.get((Object)"type").toString()) + ">"));
                                    }
                                }
                                if ("$ref".equals(entryElement.getKey())) {
                                    s = entryElement.getValue().toString();
                                    s = s.substring(s.lastIndexOf(47) + 1);
                                    propMap.put("type", Any.wrap(s));
                                }
                                if ("default".equals(entryElement.getKey())) {
                                    a = entryElement.getValue();
                                    propMap.put("default", a);
                                }
                                if ("enum".equals(entryElement.getKey())) {
                                    propMap.put("isEnum", Any.wrap(true));
                                    propMap.put("nameWithEnum", Any.wrap(name.substring(0, 1).toUpperCase() + name.substring(1) + "Enum"));
                                    OpenApiGenerator.addUnderscores(entryElement);
                                    propMap.put("value", Any.wrap(entryElement.getValue()));
                                }
                                if ("format".equals(entryElement.getKey())) {
                                    s = entryElement.getValue().toString();
                                    if ("date-time".equals(s)) {
                                        propMap.put("type", Any.wrap("java.time.LocalDateTime"));
                                    }
                                    if ("date".equals(s)) {
                                        propMap.put("type", Any.wrap("java.time.LocalDate"));
                                    }
                                    if ("double".equals(s)) {
                                        propMap.put("type", Any.wrap("java.lang.Double"));
                                    }
                                    if ("float".equals(s)) {
                                        propMap.put("type", Any.wrap("java.lang.Float"));
                                    }
                                    if ("int64".equals(s)) {
                                        propMap.put("type", Any.wrap("java.lang.Long"));
                                    }
                                }
                                if ("oneOf".equals(entryElement.getKey())) {
                                    list = entryElement.getValue().asList();
                                    t = list.get(0).asMap().get("type");
                                    if (t != null) {
                                        propMap.put("type", Any.wrap(this.typeMapping.get(t.toString())));
                                    } else {
                                        propMap.put("type", Any.wrap("Object"));
                                    }
                                }
                                if ("anyOf".equals(entryElement.getKey())) {
                                    list = entryElement.getValue().asList();
                                    t = list.get(0).asMap().get("type");
                                    if (t != null) {
                                        propMap.put("type", Any.wrap(this.typeMapping.get(t.toString())));
                                    } else {
                                        propMap.put("type", Any.wrap("Object"));
                                    }
                                }
                                if ("allOf".equals(entryElement.getKey())) {
                                    list = entryElement.getValue().asList();
                                    t = list.get(0).asMap().get("type");
                                    if (t != null) {
                                        propMap.put("type", Any.wrap(this.typeMapping.get(t.toString())));
                                    } else {
                                        propMap.put("type", Any.wrap("Object"));
                                    }
                                }
                                if (!"not".equals(entryElement.getKey())) continue;
                                Map<String, Any> m = entryElement.getValue().asMap();
                                t = m.get("type");
                                if (t != null) {
                                    propMap.put("type", t);
                                    continue;
                                }
                                propMap.put("type", Any.wrap("Object"));
                            }
                            props.add(propMap);
                        }
                    }
                    if (!"required".equals(entrySchema.getKey())) continue;
                    required = entrySchema.getValue().asList();
                }
                String classVarName = key;
                String modelFileName = key.substring(0, 1).toUpperCase() + key.substring(1);
                if (!overwriteModel && this.checkExist(targetPath, ("src.main.java." + modelPackage).replace(".", File.separator), modelFileName + ".java")) continue;
                if (isEnumClass) {
                    this.transfer(targetPath, ("src.main.java." + modelPackage).replace(".", File.separator), modelFileName + ".java", enumClass.template(modelPackage, modelFileName, enums));
                    continue;
                }
                this.transfer(targetPath, ("src.main.java." + modelPackage).replace(".", File.separator), modelFileName + ".java", pojo.template(modelPackage, modelFileName, classVarName, props));
            }
        }
        for (Map<String, Object> op : operationList) {
            String className = op.get("handlerName").toString();
            String example = null;
            List parameters = (List)op.get("parameters");
            if (op.get("example") != null) {
                example = JsonStream.serialize(op.get("example"));
            }
            if (this.checkExist(targetPath, ("src.main.java." + handlerPackage).replace(".", File.separator), className + ".java") && !overwriteHandler) continue;
            this.transfer(targetPath, ("src.main.java." + handlerPackage).replace(".", File.separator), className + ".java", handler.template(handlerPackage, className, example, parameters));
        }
        this.transfer(targetPath, ("src.test.java." + handlerPackage + ".").replace(".", File.separator), "TestServer.java", testServer.template(handlerPackage));
        for (Map<String, Object> op : operationList) {
            if (this.checkExist(targetPath, ("src.test.java." + handlerPackage).replace(".", File.separator), op.get("handlerName") + "Test.java") && !overwriteHandlerTest) continue;
            this.transfer(targetPath, ("src.test.java." + handlerPackage).replace(".", File.separator), op.get("handlerName") + "Test.java", handlerTest.template(handlerPackage, op));
        }
        try (InputStream is = OpenApiGenerator.class.getResourceAsStream("/binaries/server.keystore");){
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "server.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        is = OpenApiGenerator.class.getResourceAsStream("/binaries/server.truststore");
        var22_23 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "server.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var22_23 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var22_23 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var22_23.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        if (supportClient) {
            is = OpenApiGenerator.class.getResourceAsStream("/binaries/client.keystore");
            var22_23 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var22_23 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var22_23 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var22_23.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            is = OpenApiGenerator.class.getResourceAsStream("/binaries/client.truststore");
            var22_23 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var22_23 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var22_23 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var22_23.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        is = OpenApiGenerator.class.getResourceAsStream("/binaries/client.keystore");
        var22_23 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var22_23 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var22_23 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var22_23.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        is = OpenApiGenerator.class.getResourceAsStream("/binaries/client.truststore");
        var22_23 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var22_23 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var22_23 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var22_23.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        if (model2 instanceof Any) {
            is = new ByteArrayInputStream(model2.toString().getBytes(StandardCharsets.UTF_8));
            var22_23 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "openapi.json"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var22_23 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var22_23 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var22_23.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        if (model2 instanceof String) {
            is = new ByteArrayInputStream(((String)model2).getBytes(StandardCharsets.UTF_8));
            var22_23 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "openapi.yaml"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var22_23 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var22_23 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var22_23.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
    }

    public List<Map<String, Object>> getOperationList(Object model2) {
        String s;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (model2 instanceof Any) {
            s = ((Any)model2).toString();
        } else if (model2 instanceof String) {
            s = (String)model2;
        } else {
            throw new RuntimeException("Invalid Model Class: " + model2.getClass());
        }
        OpenApi3 openApi3 = null;
        try {
            openApi3 = (OpenApi3)new OpenApiParser().parse(s, new URL("https://oas.lightapi.net/"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String basePath = OpenApiGenerator.getBasePath(openApi3);
        Map<String, Path> paths = openApi3.getPaths();
        for (Map.Entry<String, Path> entryPath : paths.entrySet()) {
            String path = entryPath.getKey();
            Path pathValue = entryPath.getValue();
            for (Map.Entry<String, Operation> entryOps : pathValue.getOperations().entrySet()) {
                MediaType mediaType;
                Response response;
                if (entryOps.getKey().startsWith("x-")) continue;
                HashMap<String, Object> flattened = new HashMap<String, Object>();
                flattened.put("method", entryOps.getKey().toUpperCase());
                flattened.put("capMethod", entryOps.getKey().substring(0, 1).toUpperCase() + entryOps.getKey().substring(1));
                flattened.put("path", basePath + path);
                String normalizedPath = path.replace("{", "").replace("}", "");
                flattened.put("normalizedPath", basePath + normalizedPath);
                flattened.put("handlerName", Utils.camelize(normalizedPath) + Utils.camelize(entryOps.getKey()) + "Handler");
                Operation operation = entryOps.getValue();
                if (this.enableParamDescription) {
                    List<Parameter> parameterRawList = operation.getParameters();
                    LinkedList parametersResultList = new LinkedList();
                    parameterRawList.forEach(parameter -> {
                        Schema schema;
                        HashMap<String, String> parameterMap = new HashMap<String, String>();
                        parameterMap.put("name", parameter.getName());
                        parameterMap.put("description", parameter.getDescription());
                        if (parameter.getRequired() != null) {
                            parameterMap.put("required", String.valueOf(parameter.getRequired()));
                        }
                        if ((schema = parameter.getSchema()) != null) {
                            parameterMap.put("type", schema.getType());
                            if (schema.getMinLength() != null) {
                                parameterMap.put("minLength", String.valueOf(schema.getMinLength()));
                            }
                            if (schema.getMaxLength() != null) {
                                parameterMap.put("maxLength", String.valueOf(schema.getMaxLength()));
                            }
                        }
                        parametersResultList.add(parameterMap);
                    });
                    flattened.put("parameters", parametersResultList);
                }
                if ((response = operation.getResponse("200")) != null && (mediaType = response.getContentMediaType("application/json")) != null) {
                    Object example = mediaType.getExample();
                    if (example != null) {
                        flattened.put("example", example);
                    } else {
                        Map.Entry<String, Example> entry;
                        Example e;
                        Map<String, Example> exampleMap = mediaType.getExamples();
                        if (exampleMap.size() > 0 && (e = (entry = exampleMap.entrySet().iterator().next()).getValue()) != null) {
                            flattened.put("example", e.getValue());
                        }
                    }
                }
                result.add(flattened);
            }
        }
        return result;
    }

    private static String getBasePath(OpenApi3 openApi3) {
        int protocolIndex;
        int pathIndex;
        String basePath = "";
        String url = null;
        if (openApi3.getServers().size() > 0) {
            Server server2 = openApi3.getServer(0);
            url = server2.getUrl();
        }
        if (url != null && (pathIndex = url.indexOf(47, (protocolIndex = url.indexOf("://")) + 3)) > 0) {
            basePath = url.substring(pathIndex);
        }
        return basePath;
    }

    private static void addUnderscores(Map.Entry<String, Any> entryElement) {
        Iterator<Any> iterator = entryElement.getValue().iterator();
        ArrayList<Any> list = new ArrayList<Any>();
        while (iterator.hasNext()) {
            Any any = iterator.next();
            String value = any.toString().trim().replaceAll(" ", "_");
            list.add(Any.wrap(value));
        }
        entryElement.setValue(Any.wrap(list));
    }
}

