/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.rest;

import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.networknt.codegen.Generator;
import com.networknt.codegen.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import templates.rest.LICENSE;
import templates.rest.README;
import templates.rest.buildSh;
import templates.rest.classpath;
import templates.rest.clientYml;
import templates.rest.dockerfile;
import templates.rest.dockerfileredhat;
import templates.rest.gitignore;
import templates.rest.handler;
import templates.rest.logback;
import templates.rest.pojo;
import templates.rest.primaryCrt;
import templates.rest.project;
import templates.rest.secondaryCrt;
import templates.rest.secret;
import templates.rest.server;
import templates.rest.swagger.handlerTest;
import templates.rest.swagger.handlerYml;
import templates.rest.swagger.pom;
import templates.rest.swagger.service;
import templates.rest.swaggerSecurity;
import templates.rest.swaggerValidator;
import templates.rest.testServer;

public class SwaggerGenerator
implements Generator {
    private Map<String, String> typeMapping = new HashMap<String, String>();
    boolean prometheusMetrics = false;
    boolean skipHealthCheck = false;
    boolean skipServerInfo = false;
    boolean enableParamDescription = true;

    public SwaggerGenerator() {
        this.typeMapping.put("array", "java.util.List");
        this.typeMapping.put("map", "java.util.Map");
        this.typeMapping.put("List", "java.util.List");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "java.math.BigDecimal");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("ByteArray", "byte[]");
        this.typeMapping.put("binary", "byte[]");
    }

    @Override
    public String getFramework() {
        return "swagger";
    }

    @Override
    public void generate(String targetPath, Object model2, Any config) throws IOException {
        String rootPackage = config.toString("rootPackage");
        String modelPackage = config.toString("modelPackage");
        String handlerPackage = config.toString("handlerPackage");
        boolean overwriteHandler = config.toBoolean("overwriteHandler");
        boolean overwriteHandlerTest = config.toBoolean("overwriteHandlerTest");
        boolean overwriteModel = config.toBoolean("overwriteModel");
        boolean enableHttp = config.toBoolean("enableHttp");
        String httpPort = config.toString("httpPort");
        boolean enableHttps = config.toBoolean("enableHttps");
        String httpsPort = config.toString("httpsPort");
        boolean enableRegistry = config.toBoolean("enableRegistry");
        boolean supportClient = config.toBoolean("supportClient");
        String dockerOrganization = config.toString("dockerOrganization");
        this.prometheusMetrics = config.toBoolean("prometheusMetrics");
        this.skipHealthCheck = config.toBoolean("skipHealthCheck");
        this.skipServerInfo = config.toBoolean("skipServerInfo");
        String version = config.toString("version");
        String serviceId = config.get((Object)"groupId") + "." + config.get((Object)"artifactId") + "-" + config.get((Object)"version");
        this.enableParamDescription = config.toBoolean("enableParamDescription");
        if (dockerOrganization == null || dockerOrganization.length() == 0) {
            dockerOrganization = "networknt";
        }
        this.transfer(targetPath, "", "pom.xml", pom.template(config));
        String expose = "";
        expose = enableHttps ? httpsPort : httpPort;
        this.transfer(targetPath, "docker", "Dockerfile", dockerfile.template(config, expose));
        this.transfer(targetPath, "docker", "Dockerfile-Redhat", dockerfileredhat.template(config, expose));
        this.transfer(targetPath, "", "build.sh", buildSh.template(dockerOrganization, serviceId));
        this.transfer(targetPath, "", ".gitignore", gitignore.template());
        this.transfer(targetPath, "", "README.md", README.template());
        this.transfer(targetPath, "", "LICENSE", LICENSE.template());
        this.transfer(targetPath, "", ".classpath", classpath.template());
        this.transfer(targetPath, "", ".project", project.template(config));
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", service.template(config));
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "server.yml", server.template(serviceId, enableHttp, httpPort, enableHttps, httpsPort, enableRegistry, version));
        this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "server.yml", server.template(serviceId, enableHttp, "49587", enableHttps, "49588", enableRegistry, version));
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secret.yml", secret.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "swagger-security.yml", swaggerSecurity.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "swagger-validator.yml", swaggerValidator.template());
        if (supportClient) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        } else {
            this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        }
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "primary.crt", primaryCrt.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secondary.crt", secondaryCrt.template());
        this.transfer(targetPath, "src.main.resources".replace(".", File.separator), "logback.xml", logback.template());
        this.transfer(targetPath, "src.test.resources".replace(".", File.separator), "logback-test.xml", logback.template());
        List<Map<String, Any>> operationList = this.getOperationList(model2);
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "handler.yml", handlerYml.template(serviceId, handlerPackage, operationList, this.prometheusMetrics, !this.skipHealthCheck, !this.skipServerInfo));
        Any any = ((Any)model2).get((Object)"definitions");
        if (any.valueType() != ValueType.INVALID) {
            for (Map.Entry entry : any.asMap().entrySet()) {
                ArrayList<Map<String, Any>> props = new ArrayList<Map<String, Any>>();
                String key = (String)entry.getKey();
                Map<String, Any> value = ((Any)entry.getValue()).asMap();
                String type = null;
                boolean isEnum = false;
                Map<String, Any> properties = null;
                List<Any> required = null;
                for (Map.Entry<String, Any> entrySchema : value.entrySet()) {
                    if ("type".equals(entrySchema.getKey()) && "enum".equals(type = entrySchema.getValue().toString())) {
                        isEnum = true;
                    }
                    if ("properties".equals(entrySchema.getKey())) {
                        properties = entrySchema.getValue().asMap();
                        for (Map.Entry<String, Any> entryProp : properties.entrySet()) {
                            HashMap<String, Any> propMap = new HashMap<String, Any>();
                            String name = entryProp.getKey();
                            name = name.trim().replaceAll(" ", "_");
                            propMap.put("jsonProperty", Any.wrap(name));
                            if (name.startsWith("@")) {
                                name = name.substring(1);
                            }
                            propMap.put("name", Any.wrap(name));
                            propMap.put("getter", Any.wrap("get" + name.substring(0, 1).toUpperCase() + name.substring(1)));
                            propMap.put("setter", Any.wrap("set" + name.substring(0, 1).toUpperCase() + name.substring(1)));
                            propMap.put("isEnum", Any.wrap(false));
                            boolean isArray = false;
                            for (Map.Entry<String, Any> entryElement : entryProp.getValue().asMap().entrySet()) {
                                String s;
                                Any a;
                                if ("type".equals(entryElement.getKey())) {
                                    String t = this.typeMapping.get(entryElement.getValue().toString());
                                    if ("java.util.List".equals(t)) {
                                        isArray = true;
                                    } else {
                                        propMap.put("type", Any.wrap(t));
                                    }
                                }
                                if ("items".equals(entryElement.getKey())) {
                                    a = entryElement.getValue();
                                    if (a.get((Object)"$ref").valueType() != ValueType.INVALID && isArray) {
                                        String s2 = a.get((Object)"$ref").toString();
                                        s2 = s2.substring(s2.lastIndexOf(47) + 1);
                                        propMap.put("type", Any.wrap("java.util.List<" + s2 + ">"));
                                    }
                                    if (a.get((Object)"type").valueType() != ValueType.INVALID && isArray) {
                                        propMap.put("type", Any.wrap("java.util.List<" + this.typeMapping.get(a.get((Object)"type").toString()) + ">"));
                                    }
                                }
                                if ("$ref".equals(entryElement.getKey())) {
                                    s = entryElement.getValue().toString();
                                    s = s.substring(s.lastIndexOf(47) + 1);
                                    propMap.put("type", Any.wrap(s));
                                }
                                if ("default".equals(entryElement.getKey())) {
                                    a = entryElement.getValue();
                                    propMap.put("default", a);
                                }
                                if ("enum".equals(entryElement.getKey())) {
                                    propMap.put("isEnum", Any.wrap(true));
                                    propMap.put("nameWithEnum", Any.wrap(name.substring(0, 1).toUpperCase() + name.substring(1) + "Enum"));
                                    SwaggerGenerator.addUnderscores(entryElement);
                                    propMap.put("value", Any.wrap(entryElement.getValue()));
                                }
                                if (!"format".equals(entryElement.getKey())) continue;
                                s = entryElement.getValue().toString();
                                if ("date-time".equals(s)) {
                                    propMap.put("type", Any.wrap("java.time.LocalDateTime"));
                                }
                                if ("date".equals(s)) {
                                    propMap.put("type", Any.wrap("java.time.LocalDate"));
                                }
                                if ("double".equals(s)) {
                                    propMap.put("type", Any.wrap(s));
                                }
                                if ("float".equals(s)) {
                                    propMap.put("type", Any.wrap(s));
                                }
                                if (!"int64".equals(s)) continue;
                                propMap.put("type", Any.wrap("java.lang.Long"));
                            }
                            props.add(propMap);
                        }
                    }
                    if (!"required".equals(entrySchema.getKey())) continue;
                    required = entrySchema.getValue().asList();
                }
                String classVarName = key;
                String modelFileName = key.substring(0, 1).toUpperCase() + key.substring(1);
                if (!overwriteModel && this.checkExist(targetPath, ("src.main.java." + modelPackage).replace(".", File.separator), modelFileName + ".java")) continue;
                this.transfer(targetPath, ("src.main.java." + modelPackage).replace(".", File.separator), modelFileName + ".java", pojo.template(modelPackage, modelFileName, classVarName, props));
            }
        }
        for (Map map : operationList) {
            String className = ((Any)map.get("handlerName")).toString();
            String example = null;
            if (map.get("example") != null) {
                example = JsonStream.serialize(map.get("example"));
            }
            if (this.checkExist(targetPath, ("src.main.java." + handlerPackage).replace(".", File.separator), className + ".java") && !overwriteHandler) continue;
            Any parametersRaw = (Any)map.get("parameters");
            ArrayList<Map> parameterList = new ArrayList<Map>();
            if (parametersRaw != null) {
                List<Any> parameters = parametersRaw.asList();
                for (Any parameterRaw : parameters) {
                    Map<String, Any> parameterMap = parameterRaw.asMap();
                    HashMap parameterResultMap = new HashMap();
                    parameterMap.forEach((k, v) -> parameterResultMap.put(k, String.valueOf(v)));
                    parameterList.add(parameterResultMap);
                }
            }
            this.transfer(targetPath, ("src.main.java." + handlerPackage).replace(".", File.separator), className + ".java", handler.template(handlerPackage, className, example, parameterList));
        }
        this.transfer(targetPath, ("src.test.java." + handlerPackage + ".").replace(".", File.separator), "TestServer.java", testServer.template(handlerPackage));
        for (Map map : operationList) {
            if (this.checkExist(targetPath, ("src.test.java." + handlerPackage).replace(".", File.separator), map.get("handlerName") + "Test.java") && !overwriteHandlerTest) continue;
            this.transfer(targetPath, ("src.test.java." + handlerPackage).replace(".", File.separator), map.get("handlerName") + "Test.java", handlerTest.template(handlerPackage, map));
        }
        Throwable throwable = null;
        try (InputStream is = SwaggerGenerator.class.getResourceAsStream("/binaries/server.keystore");){
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "server.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        is = SwaggerGenerator.class.getResourceAsStream("/binaries/server.truststore");
        Throwable throwable4 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "server.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            throw throwable5;
        }
        finally {
            if (is != null) {
                if (throwable4 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable7) {
                        throwable4.addSuppressed(throwable7);
                    }
                } else {
                    is.close();
                }
            }
        }
        if (supportClient) {
            is = SwaggerGenerator.class.getResourceAsStream("/binaries/client.keystore");
            Throwable throwable8 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable9) {
                Throwable throwable10 = throwable9;
                throw throwable9;
            }
            finally {
                if (is != null) {
                    if (throwable8 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable11) {
                            throwable8.addSuppressed(throwable11);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            is = SwaggerGenerator.class.getResourceAsStream("/binaries/client.truststore");
            Throwable throwable12 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable13) {
                Throwable throwable14 = throwable13;
                throw throwable13;
            }
            finally {
                if (is != null) {
                    if (throwable12 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable15) {
                            throwable12.addSuppressed(throwable15);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        is = SwaggerGenerator.class.getResourceAsStream("/binaries/client.keystore");
        Throwable throwable16 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable17) {
            Throwable throwable18 = throwable17;
            throw throwable17;
        }
        finally {
            if (is != null) {
                if (throwable16 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable19) {
                        throwable16.addSuppressed(throwable19);
                    }
                } else {
                    is.close();
                }
            }
        }
        is = SwaggerGenerator.class.getResourceAsStream("/binaries/client.truststore");
        Throwable throwable20 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable21) {
            Throwable throwable22 = throwable21;
            throw throwable21;
        }
        finally {
            if (is != null) {
                if (throwable20 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable23) {
                        throwable20.addSuppressed(throwable23);
                    }
                } else {
                    is.close();
                }
            }
        }
        JsonStream.serialize(model2, new FileOutputStream(FileSystems.getDefault().getPath(targetPath, "src.main.resources.config".replace(".", File.separator), "swagger.json").toFile()));
    }

    public List<Map<String, Any>> getOperationList(Object model2) {
        ArrayList<Map<String, Any>> result = new ArrayList<Map<String, Any>>();
        Any anyModel = (Any)model2;
        String basePath = anyModel.get((Object)"basePath").toString();
        Map<String, Any> paths = anyModel.get((Object)"paths").asMap();
        for (Map.Entry<String, Any> entryPath : paths.entrySet()) {
            String path = entryPath.getKey();
            Map<String, Any> pathValues = entryPath.getValue().asMap();
            for (Map.Entry<String, Any> entryOps : pathValues.entrySet()) {
                Any parametersRaw;
                Any examples;
                Any response;
                if (entryOps.getKey().startsWith("x-")) continue;
                HashMap<String, Any> flattened = new HashMap<String, Any>();
                flattened.put("method", Any.wrap(entryOps.getKey().toUpperCase()));
                flattened.put("capMethod", Any.wrap(entryOps.getKey().substring(0, 1).toUpperCase() + entryOps.getKey().substring(1)));
                flattened.put("path", Any.wrap(basePath + path));
                String normalizedPath = path.replace("{", "").replace("}", "");
                flattened.put("normalizedPath", Any.wrap(basePath + normalizedPath));
                flattened.put("handlerName", Any.wrap(Utils.camelize(normalizedPath) + Utils.camelize(entryOps.getKey()) + "Handler"));
                Any any = entryOps.getValue();
                if (any.valueType() != ValueType.OBJECT) continue;
                Map<String, Any> values = any.asMap();
                Any responses = values.get("responses");
                if (responses != null && (response = responses.asMap().get("200")) != null && (examples = response.asMap().get("examples")) != null) {
                    Any jsonRes = examples.asMap().get("application/json");
                    flattened.put("example", jsonRes);
                }
                if (this.enableParamDescription && (parametersRaw = values.get("parameters")) != null) {
                    flattened.put("parameters", parametersRaw);
                }
                result.add(flattened);
            }
        }
        return result;
    }

    private static void addUnderscores(Map.Entry<String, Any> entryElement) {
        Iterator<Any> iterator = entryElement.getValue().iterator();
        ArrayList<Any> list = new ArrayList<Any>();
        while (iterator.hasNext()) {
            Any any = iterator.next();
            String value = any.toString().trim().replaceAll(" ", "_");
            list.add(Any.wrap(value));
        }
        entryElement.setValue(Any.wrap(list));
    }
}

