/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.Selection;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FragmentSpread
extends AbstractNode<FragmentSpread>
implements Selection<FragmentSpread> {
    private String name;
    private List<Directive> directives = new ArrayList<Directive>();

    public FragmentSpread() {
    }

    public FragmentSpread(String name) {
        this.name = name;
    }

    public FragmentSpread(String name, List<Directive> directives) {
        this.name = name;
        this.directives = directives;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public void setDirectives(List<Directive> directives) {
        this.directives = directives;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentSpread that = (FragmentSpread)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        return result;
    }

    @Override
    public FragmentSpread deepCopy() {
        return new FragmentSpread(this.name, this.deepCopy(this.directives));
    }

    public String toString() {
        return "FragmentSpread{name='" + this.name + '\'' + ", directives=" + this.directives + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitFragmentSpread(this, context);
    }
}

