/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.SelectionSet;
import graphql.language.VariableDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OperationDefinition
extends AbstractNode<OperationDefinition>
implements Definition<OperationDefinition> {
    private String name;
    private Operation operation;
    private List<VariableDefinition> variableDefinitions = new ArrayList<VariableDefinition>();
    private List<Directive> directives = new ArrayList<Directive>();
    private SelectionSet selectionSet;

    public OperationDefinition() {
    }

    public OperationDefinition(String name, Operation operation, List<VariableDefinition> variableDefinitions, List<Directive> directives, SelectionSet selectionSet) {
        this.name = name;
        this.operation = operation;
        this.variableDefinitions = variableDefinitions;
        this.directives = directives;
        this.selectionSet = selectionSet;
    }

    public OperationDefinition(String name, Operation operation, List<VariableDefinition> variableDefinitions, SelectionSet selectionSet) {
        this.name = name;
        this.operation = operation;
        this.variableDefinitions = variableDefinitions;
        this.selectionSet = selectionSet;
    }

    public OperationDefinition(String name, Operation operation, SelectionSet selectionSet) {
        this.name = name;
        this.operation = operation;
        this.selectionSet = selectionSet;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.variableDefinitions);
        result.addAll(this.directives);
        result.add(this.selectionSet);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public List<VariableDefinition> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    public void setVariableDefinitions(List<VariableDefinition> variableDefinitions) {
        this.variableDefinitions = variableDefinitions;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public void setDirectives(List<Directive> directives) {
        this.directives = directives;
    }

    public SelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    public void setSelectionSet(SelectionSet selectionSet) {
        this.selectionSet = selectionSet;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationDefinition that = (OperationDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name) && this.operation == that.operation;
    }

    @Override
    public OperationDefinition deepCopy() {
        return new OperationDefinition(this.name, this.operation, this.deepCopy(this.variableDefinitions), this.deepCopy(this.directives), this.deepCopy(this.selectionSet));
    }

    public String toString() {
        return "OperationDefinition{name='" + this.name + '\'' + ", operation=" + (Object)((Object)this.operation) + ", variableDefinitions=" + this.variableDefinitions + ", directives=" + this.directives + ", selectionSet=" + this.selectionSet + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitOperationDefinition(this, context);
    }

    public static enum Operation {
        QUERY,
        MUTATION,
        SUBSCRIPTION;

    }
}

