/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.Type;
import graphql.language.Value;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;

public class VariableDefinition
extends AbstractNode<VariableDefinition> {
    private String name;
    private Type type;
    private Value defaultValue;

    public VariableDefinition() {
        this(null, null, null);
    }

    public VariableDefinition(String name, Type type) {
        this(name, type, null);
    }

    public VariableDefinition(String name, Type type, Value defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Value defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.type);
        if (this.defaultValue != null) {
            result.add(this.defaultValue);
        }
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableDefinition that = (VariableDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public VariableDefinition deepCopy() {
        return new VariableDefinition(this.name, this.deepCopy(this.type), this.deepCopy(this.defaultValue));
    }

    public String toString() {
        return "VariableDefinition{name='" + this.name + '\'' + ", type=" + this.type + ", defaultValue=" + this.defaultValue + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitVariableDefinition(this, context);
    }
}

