/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diff.reporting;

import graphql.PublicApi;
import graphql.schema.diff.DiffEvent;
import graphql.schema.diff.DiffLevel;
import graphql.schema.diff.reporting.DifferenceReporter;
import java.io.PrintStream;

@PublicApi
public class PrintStreamReporter
implements DifferenceReporter {
    int breakageCount = 0;
    int dangerCount = 0;
    final PrintStream out;

    public PrintStreamReporter() {
        this(System.out);
    }

    public PrintStreamReporter(PrintStream out) {
        this.out = out;
    }

    @Override
    public void report(DiffEvent differenceEvent) {
        if (differenceEvent.getLevel() == DiffLevel.BREAKING) {
            ++this.breakageCount;
        }
        if (differenceEvent.getLevel() == DiffLevel.DANGEROUS) {
            ++this.dangerCount;
        }
        this.printEvent(differenceEvent);
    }

    private void printEvent(DiffEvent event2) {
        String indent = event2.getLevel() == DiffLevel.INFO ? "\t" : "";
        String level = event2.getLevel() == DiffLevel.INFO ? "info" : event2.getLevel().toString();
        String objectName = event2.getTypeName();
        if (event2.getFieldName() != null) {
            objectName = objectName + "." + event2.getFieldName();
        }
        this.out.println(String.format("%s%s - '%s' : '%s' : %s", new Object[]{indent, level, event2.getTypeKind(), objectName, event2.getReasonMsg()}));
    }

    @Override
    public void onEnd() {
        this.out.println("\n");
        this.out.println(String.format("%d errors", this.breakageCount));
        this.out.println(String.format("%d warnings", this.dangerCount));
        this.out.println("\n");
    }
}

