/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.PublicApi;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.parser.Parser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.SchemaProblem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.misc.ParseCancellationException;

@PublicApi
public class SchemaParser {
    public TypeDefinitionRegistry parse(File file) throws SchemaProblem {
        try {
            return this.parse(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypeDefinitionRegistry parse(Reader reader) throws SchemaProblem {
        try (Reader input = reader;){
            TypeDefinitionRegistry typeDefinitionRegistry = this.parse(this.read(input));
            return typeDefinitionRegistry;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TypeDefinitionRegistry parse(String schemaInput) throws SchemaProblem {
        try {
            Parser parser = new Parser();
            Document document = parser.parseDocument(schemaInput);
            return this.buildRegistry(document);
        }
        catch (ParseCancellationException e) {
            throw this.handleParseException(e);
        }
    }

    private SchemaProblem handleParseException(ParseCancellationException e) throws RuntimeException {
        InvalidSyntaxError invalidSyntaxError = InvalidSyntaxError.toInvalidSyntaxError(e);
        return new SchemaProblem(Collections.singletonList(invalidSyntaxError));
    }

    public TypeDefinitionRegistry buildRegistry(Document document) {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        TypeDefinitionRegistry typeRegistry = new TypeDefinitionRegistry();
        List<Definition> definitions = document.getDefinitions();
        for (Definition definition : definitions) {
            typeRegistry.add(definition).ifPresent(errors::add);
        }
        if (errors.size() > 0) {
            throw new SchemaProblem(errors);
        }
        return typeRegistry;
    }

    private String read(Reader reader) throws IOException {
        int n;
        char[] buffer = new char[4096];
        StringWriter sw = new StringWriter();
        while (-1 != (n = reader.read(buffer))) {
            sw.write(buffer, 0, n);
        }
        return sw.toString();
    }
}

