/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;

public final class EnumValues
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<Enum<?>> _enumClass;
    private final Enum<?>[] _values;
    private final SerializableString[] _textual;
    private transient EnumMap<?, SerializableString> _asMap;

    private EnumValues(Class<Enum<?>> enumClass2, SerializableString[] textual) {
        this._enumClass = enumClass2;
        this._values = enumClass2.getEnumConstants();
        this._textual = textual;
    }

    public static EnumValues construct(SerializationConfig config2, Class<Enum<?>> enumClass2) {
        if (config2.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            return EnumValues.constructFromToString(config2, enumClass2);
        }
        return EnumValues.constructFromName(config2, enumClass2);
    }

    public static EnumValues constructFromName(MapperConfig<?> config2, Class<Enum<?>> enumClass2) {
        Class<Enum<?>> enumCls = ClassUtil.findEnumType(enumClass2);
        Enum<?>[] enumValues = enumCls.getEnumConstants();
        if (enumValues == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + enumClass2.getName());
        }
        String[] names = config2.getAnnotationIntrospector().findEnumValues(enumCls, enumValues, new String[enumValues.length]);
        SerializableString[] textual = new SerializableString[enumValues.length];
        int len = enumValues.length;
        for (int i = 0; i < len; ++i) {
            Enum<?> en = enumValues[i];
            String name = names[i];
            if (name == null) {
                name = en.name();
            }
            textual[en.ordinal()] = config2.compileString(name);
        }
        return new EnumValues(enumClass2, textual);
    }

    public static EnumValues constructFromToString(MapperConfig<?> config2, Class<Enum<?>> enumClass2) {
        Class<Enum<?>> cls = ClassUtil.findEnumType(enumClass2);
        Enum<?>[] values2 = cls.getEnumConstants();
        if (values2 != null) {
            SerializableString[] textual = new SerializableString[values2.length];
            for (Enum<?> en : values2) {
                textual[en.ordinal()] = config2.compileString(en.toString());
            }
            return new EnumValues(enumClass2, textual);
        }
        throw new IllegalArgumentException("Cannot determine enum constants for Class " + enumClass2.getName());
    }

    public SerializableString serializedValueFor(Enum<?> key) {
        return this._textual[key.ordinal()];
    }

    public Collection<SerializableString> values() {
        return Arrays.asList(this._textual);
    }

    public List<Enum<?>> enums() {
        return Arrays.asList(this._values);
    }

    public EnumMap<?, SerializableString> internalMap() {
        EnumMap<Object, SerializableString> result = this._asMap;
        if (result == null) {
            LinkedHashMap map = new LinkedHashMap();
            for (Enum<?> en : this._values) {
                map.put(en, this._textual[en.ordinal()]);
            }
            result = new EnumMap(map);
        }
        return result;
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

