/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.spi.ClassInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CodegenImplEnum {
    CodegenImplEnum() {
    }

    public static String genEnum(ClassInfo classInfo) {
        StringBuilder lines = new StringBuilder();
        CodegenImplEnum.append(lines, "if (iter.readNull()) { return null; }");
        CodegenImplEnum.append(lines, "com.jsoniter.spi.Slice field = com.jsoniter.CodegenAccess.readSlice(iter);");
        CodegenImplEnum.append(lines, "switch (field.len()) {");
        CodegenImplEnum.append(lines, CodegenImplEnum.renderTriTree(CodegenImplEnum.buildTriTree(Arrays.asList(classInfo.clazz.getEnumConstants()))));
        CodegenImplEnum.append(lines, "}");
        CodegenImplEnum.append(lines, String.format("throw iter.reportError(\"decode enum\", field + \" is not valid enum for %s\");", classInfo.clazz.getName()));
        return lines.toString();
    }

    private static Map<Integer, Object> buildTriTree(List<Object> allConsts) {
        HashMap<Integer, Object> trieTree = new HashMap<Integer, Object>();
        for (Object e : allConsts) {
            byte[] fromNameBytes = e.toString().getBytes();
            HashMap<Byte, Object> current = (HashMap<Byte, Object>)trieTree.get(fromNameBytes.length);
            if (current == null) {
                current = new HashMap<Byte, Object>();
                trieTree.put(fromNameBytes.length, current);
            }
            for (int i = 0; i < fromNameBytes.length - 1; ++i) {
                byte b = fromNameBytes[i];
                HashMap next = (HashMap)current.get(b);
                if (next == null) {
                    next = new HashMap();
                    current.put(b, next);
                }
                current = next;
            }
            current.put(fromNameBytes[fromNameBytes.length - 1], e);
        }
        return trieTree;
    }

    private static String renderTriTree(Map<Integer, Object> trieTree) {
        StringBuilder switchBody = new StringBuilder();
        for (Map.Entry<Integer, Object> entry : trieTree.entrySet()) {
            Integer len = entry.getKey();
            CodegenImplEnum.append(switchBody, "case " + len + ": ");
            Map current = (Map)entry.getValue();
            CodegenImplEnum.addFieldDispatch(switchBody, len, 0, current, new ArrayList<Byte>());
            CodegenImplEnum.append(switchBody, "break;");
        }
        return switchBody.toString();
    }

    private static void addFieldDispatch(StringBuilder lines, int len, int i, Map<Byte, Object> current, List<Byte> bytesToCompare) {
        for (Map.Entry<Byte, Object> entry : current.entrySet()) {
            Byte b = entry.getKey();
            if (i == len - 1) {
                CodegenImplEnum.append(lines, "if (");
                for (int j = 0; j < bytesToCompare.size(); ++j) {
                    Byte a = bytesToCompare.get(j);
                    CodegenImplEnum.append(lines, String.format("field.at(%d)==%s && ", i - bytesToCompare.size() + j, a));
                }
                CodegenImplEnum.append(lines, String.format("field.at(%d)==%s", i, b));
                CodegenImplEnum.append(lines, ") {");
                Object e = entry.getValue();
                CodegenImplEnum.append(lines, String.format("return %s.%s;", e.getClass().getName(), e.toString()));
                CodegenImplEnum.append(lines, "}");
                continue;
            }
            Map next = (Map)entry.getValue();
            if (next.size() == 1) {
                ArrayList<Byte> nextBytesToCompare = new ArrayList<Byte>(bytesToCompare);
                nextBytesToCompare.add(b);
                CodegenImplEnum.addFieldDispatch(lines, len, i + 1, next, nextBytesToCompare);
                continue;
            }
            CodegenImplEnum.append(lines, "if (");
            for (int j = 0; j < bytesToCompare.size(); ++j) {
                Byte a = bytesToCompare.get(j);
                CodegenImplEnum.append(lines, String.format("field.at(%d)==%s && ", i - bytesToCompare.size() + j, a));
            }
            CodegenImplEnum.append(lines, String.format("field.at(%d)==%s", i, b));
            CodegenImplEnum.append(lines, ") {");
            CodegenImplEnum.addFieldDispatch(lines, len, i + 1, next, new ArrayList<Byte>());
            CodegenImplEnum.append(lines, "}");
        }
    }

    private static void append(StringBuilder lines, String str) {
        lines.append(str);
        lines.append("\n");
    }
}

