/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter;

import com.jsoniter.JsonIterator;
import com.jsoniter.JsonIteratorPool;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.MapKeyDecoder;
import com.jsoniter.spi.Slice;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.Type;

class DefaultMapKeyDecoder
implements MapKeyDecoder {
    private final TypeLiteral mapKeyTypeLiteral;

    public static MapKeyDecoder registerOrGetExisting(Type mapKeyType) {
        String cacheKey = JsoniterSpi.getMapKeyDecoderCacheKey(mapKeyType);
        MapKeyDecoder mapKeyDecoder = JsoniterSpi.getMapKeyDecoder(cacheKey);
        if (null != mapKeyDecoder) {
            return mapKeyDecoder;
        }
        mapKeyDecoder = new DefaultMapKeyDecoder(TypeLiteral.create(mapKeyType));
        JsoniterSpi.addNewMapDecoder(cacheKey, mapKeyDecoder);
        return mapKeyDecoder;
    }

    private DefaultMapKeyDecoder(TypeLiteral mapKeyTypeLiteral) {
        this.mapKeyTypeLiteral = mapKeyTypeLiteral;
    }

    @Override
    public Object decode(Slice encodedMapKey) {
        JsonIterator iter = JsonIteratorPool.borrowJsonIterator();
        iter.reset(encodedMapKey);
        try {
            Object t = iter.read(this.mapKeyTypeLiteral);
            return t;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }
}

