/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.JsonIterator;
import com.jsoniter.JsonIteratorPool;
import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;

abstract class LazyAny
extends Any {
    protected final byte[] data;
    protected final int head;
    protected final int tail;

    public LazyAny(byte[] data, int head, int tail) {
        this.data = data;
        this.head = head;
        this.tail = tail;
    }

    @Override
    public abstract ValueType valueType();

    @Override
    public final <T> T bindTo(T obj) {
        JsonIterator iter = this.parse();
        try {
            T t = iter.read(obj);
            return t;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }

    @Override
    public final <T> T bindTo(TypeLiteral<T> typeLiteral, T obj) {
        JsonIterator iter = this.parse();
        try {
            T t = iter.read(typeLiteral, obj);
            return t;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }

    @Override
    public final <T> T as(Class<T> clazz) {
        JsonIterator iter = this.parse();
        try {
            T t = iter.read(clazz);
            return t;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }

    @Override
    public final <T> T as(TypeLiteral<T> typeLiteral) {
        JsonIterator iter = this.parse();
        try {
            T t = iter.read(typeLiteral);
            return t;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }

    @Override
    public String toString() {
        return new String(this.data, this.head, this.tail - this.head);
    }

    protected final JsonIterator parse() {
        JsonIterator iter = JsonIteratorPool.borrowJsonIterator();
        iter.reset(this.data, this.head, this.tail);
        return iter;
    }

    @Override
    public void writeTo(JsonStream stream) throws IOException {
        stream.write(this.data, this.head, this.tail - this.head);
    }
}

