/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.extra;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Since;
import com.google.gson.annotations.Until;
import com.jsoniter.JsonIterator;
import com.jsoniter.ValueType;
import com.jsoniter.annotation.JsonIgnore;
import com.jsoniter.annotation.JsonProperty;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Binding;
import com.jsoniter.spi.ClassDescriptor;
import com.jsoniter.spi.Config;
import com.jsoniter.spi.Decoder;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.OmitValue;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class GsonCompatibilityMode
extends Config {
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;

    private GsonCompatibilityMode(String configName, Builder builder) {
        super(configName, builder);
    }

    @Override
    protected Builder builder() {
        return (Builder)super.builder();
    }

    @Override
    protected OmitValue createOmitValue(Type valueType) {
        Class clazz;
        if (valueType instanceof Class && (clazz = (Class)valueType).isPrimitive()) {
            return null;
        }
        return super.createOmitValue(valueType);
    }

    @Override
    public Encoder createEncoder(String cacheKey, Type type) {
        if (Date.class == type) {
            return new Encoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    DateFormat dateFormat = (DateFormat)GsonCompatibilityMode.this.builder().dateFormat.get();
                    stream.writeVal(dateFormat.format(obj));
                }
            };
        }
        if (String.class == type) {
            final String[] replacements = this.builder().disableHtmlEscaping ? REPLACEMENT_CHARS : HTML_SAFE_REPLACEMENT_CHARS;
            return new Encoder(){

                @Override
                public void encode(Object obj, JsonStream stream) throws IOException {
                    String value = (String)obj;
                    stream.write(34);
                    for (int i = 0; i < value.length(); ++i) {
                        int c = value.charAt(i);
                        if (c < 128) {
                            String replacement = replacements[c];
                            if (replacement == null) {
                                stream.write(c);
                                continue;
                            }
                            stream.writeRaw(replacement);
                            continue;
                        }
                        if (c == 8232) {
                            stream.writeRaw("\\u2028");
                            continue;
                        }
                        if (c == 8233) {
                            stream.writeRaw("\\u2029");
                            continue;
                        }
                        if (c < 2048) {
                            stream.write((byte)(0xC0 | c >> 6), (byte)(0x80 | c & 0x3F));
                            continue;
                        }
                        if (c < 55296 || c > 57343) {
                            stream.write((byte)(0xE0 | c >> 12), (byte)(0x80 | c >> 6 & 0x3F), (byte)(0x80 | c & 0x3F));
                            continue;
                        }
                        if (c > 56319) {
                            throw new JsonException("illegalSurrogate");
                        }
                        int _surrogate = c;
                        if (i >= value.length()) break;
                        int firstPart = _surrogate;
                        _surrogate = 0;
                        if (c < 56320 || c > 57343) {
                            throw new JsonException("Broken surrogate pair: first char 0x" + Integer.toHexString(firstPart) + ", second 0x" + Integer.toHexString(c) + "; illegal combination");
                        }
                        if ((c = 65536 + (firstPart - 55296 << 10) + (c - 56320)) > 0x10FFFF) {
                            throw new JsonException("illegalSurrogate");
                        }
                        stream.write((byte)(0xF0 | c >> 18), (byte)(0x80 | c >> 12 & 0x3F), (byte)(0x80 | c >> 6 & 0x3F), (byte)(0x80 | c & 0x3F));
                    }
                    stream.write(34);
                }
            };
        }
        return super.createEncoder(cacheKey, type);
    }

    @Override
    public Decoder createDecoder(String cacheKey, Type type) {
        if (Date.class == type) {
            return new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    DateFormat dateFormat = (DateFormat)GsonCompatibilityMode.this.builder().dateFormat.get();
                    try {
                        String input = iter.readString();
                        return dateFormat.parse(input);
                    }
                    catch (ParseException e) {
                        throw new JsonException(e);
                    }
                }
            };
        }
        if (String.class == type) {
            return new Decoder(){

                @Override
                public Object decode(JsonIterator iter) throws IOException {
                    ValueType valueType = iter.whatIsNext();
                    if (valueType == ValueType.STRING) {
                        return iter.readString();
                    }
                    if (valueType == ValueType.NUMBER) {
                        return iter.readNumberAsString();
                    }
                    if (valueType == ValueType.BOOLEAN) {
                        return iter.readBoolean() ? "true" : "false";
                    }
                    if (valueType == ValueType.NULL) {
                        iter.skip();
                        return null;
                    }
                    throw new JsonException("expect string, but found " + (Object)((Object)valueType));
                }
            };
        }
        if (Boolean.TYPE == type) {
            return new Decoder.BooleanDecoder(){

                @Override
                public boolean decodeBoolean(JsonIterator iter) throws IOException {
                    ValueType valueType = iter.whatIsNext();
                    if (valueType == ValueType.BOOLEAN) {
                        return iter.readBoolean();
                    }
                    if (valueType == ValueType.NULL) {
                        iter.skip();
                        return false;
                    }
                    throw new JsonException("expect boolean, but found " + (Object)((Object)valueType));
                }
            };
        }
        if (Long.TYPE == type) {
            return new Decoder.LongDecoder(){

                @Override
                public long decodeLong(JsonIterator iter) throws IOException {
                    ValueType valueType = iter.whatIsNext();
                    if (valueType == ValueType.NUMBER) {
                        return iter.readLong();
                    }
                    if (valueType == ValueType.NULL) {
                        iter.skip();
                        return 0L;
                    }
                    throw new JsonException("expect long, but found " + (Object)((Object)valueType));
                }
            };
        }
        if (Integer.TYPE == type) {
            return new Decoder.IntDecoder(){

                @Override
                public int decodeInt(JsonIterator iter) throws IOException {
                    ValueType valueType = iter.whatIsNext();
                    if (valueType == ValueType.NUMBER) {
                        return iter.readInt();
                    }
                    if (valueType == ValueType.NULL) {
                        iter.skip();
                        return 0;
                    }
                    throw new JsonException("expect int, but found " + (Object)((Object)valueType));
                }
            };
        }
        if (Float.TYPE == type) {
            return new Decoder.FloatDecoder(){

                @Override
                public float decodeFloat(JsonIterator iter) throws IOException {
                    ValueType valueType = iter.whatIsNext();
                    if (valueType == ValueType.NUMBER) {
                        return iter.readFloat();
                    }
                    if (valueType == ValueType.NULL) {
                        iter.skip();
                        return 0.0f;
                    }
                    throw new JsonException("expect float, but found " + (Object)((Object)valueType));
                }
            };
        }
        if (Double.TYPE == type) {
            return new Decoder.DoubleDecoder(){

                @Override
                public double decodeDouble(JsonIterator iter) throws IOException {
                    ValueType valueType = iter.whatIsNext();
                    if (valueType == ValueType.NUMBER) {
                        return iter.readDouble();
                    }
                    if (valueType == ValueType.NULL) {
                        iter.skip();
                        return 0.0;
                    }
                    throw new JsonException("expect float, but found " + (Object)((Object)valueType));
                }
            };
        }
        return super.createDecoder(cacheKey, type);
    }

    @Override
    public void updateClassDescriptor(ClassDescriptor desc) {
        FieldNamingStrategy fieldNamingStrategy = this.builder().fieldNamingStrategy;
        for (Binding binding : desc.allBindings()) {
            if (binding.method != null) {
                binding.toNames = new String[0];
                binding.fromNames = new String[0];
            }
            if (fieldNamingStrategy != null && binding.field != null) {
                String translated = fieldNamingStrategy.translateName(binding.field);
                binding.toNames = new String[]{translated};
                binding.fromNames = new String[]{translated};
            }
            if (this.builder().version != null) {
                Until until;
                Since since = binding.getAnnotation(Since.class);
                if (since != null && this.builder().version < since.value()) {
                    binding.toNames = new String[0];
                    binding.fromNames = new String[0];
                }
                if ((until = binding.getAnnotation(Until.class)) != null && this.builder().version >= until.value()) {
                    binding.toNames = new String[0];
                    binding.fromNames = new String[0];
                }
            }
            for (ExclusionStrategy strategy : this.builder().serializationExclusionStrategies) {
                if (strategy.shouldSkipClass(binding.clazz)) {
                    binding.toNames = new String[0];
                    continue;
                }
                if (!strategy.shouldSkipField(new FieldAttributes(binding.field))) continue;
                binding.toNames = new String[0];
            }
            for (ExclusionStrategy strategy : this.builder().deserializationExclusionStrategies) {
                if (strategy.shouldSkipClass(binding.clazz)) {
                    binding.fromNames = new String[0];
                    continue;
                }
                if (!strategy.shouldSkipField(new FieldAttributes(binding.field))) continue;
                binding.fromNames = new String[0];
            }
        }
        super.updateClassDescriptor(desc);
    }

    @Override
    protected JsonProperty getJsonProperty(Annotation[] annotations) {
        JsonProperty jsoniterObj = super.getJsonProperty(annotations);
        if (jsoniterObj != null) {
            return jsoniterObj;
        }
        final SerializedName gsonObj = GsonCompatibilityMode.getAnnotation(annotations, SerializedName.class);
        if (gsonObj == null) {
            return null;
        }
        return new JsonProperty(){

            @Override
            public String value() {
                return "";
            }

            @Override
            public String[] from() {
                return new String[]{gsonObj.value()};
            }

            @Override
            public String[] to() {
                return new String[]{gsonObj.value()};
            }

            @Override
            public boolean required() {
                return false;
            }

            @Override
            public Class<? extends Decoder> decoder() {
                return Decoder.class;
            }

            @Override
            public Class<?> implementation() {
                return Object.class;
            }

            @Override
            public Class<? extends Encoder> encoder() {
                return Encoder.class;
            }

            @Override
            public boolean nullable() {
                return true;
            }

            @Override
            public boolean collectionValueNullable() {
                return true;
            }

            @Override
            public String defaultValueToOmit() {
                return "";
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return JsonProperty.class;
            }
        };
    }

    @Override
    protected JsonIgnore getJsonIgnore(Annotation[] annotations) {
        JsonIgnore jsoniterObj = super.getJsonIgnore(annotations);
        if (jsoniterObj != null) {
            return jsoniterObj;
        }
        if (this.builder().excludeFieldsWithoutExposeAnnotation) {
            final Expose gsonObj = GsonCompatibilityMode.getAnnotation(annotations, Expose.class);
            if (gsonObj != null) {
                return new JsonIgnore(){

                    @Override
                    public boolean ignoreDecoding() {
                        return !gsonObj.deserialize();
                    }

                    @Override
                    public boolean ignoreEncoding() {
                        return !gsonObj.serialize();
                    }

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return JsonIgnore.class;
                    }
                };
            }
            return new JsonIgnore(){

                @Override
                public boolean ignoreDecoding() {
                    return true;
                }

                @Override
                public boolean ignoreEncoding() {
                    return true;
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return JsonIgnore.class;
                }
            };
        }
        return null;
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            GsonCompatibilityMode.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        GsonCompatibilityMode.REPLACEMENT_CHARS[34] = "\\\"";
        GsonCompatibilityMode.REPLACEMENT_CHARS[92] = "\\\\";
        GsonCompatibilityMode.REPLACEMENT_CHARS[9] = "\\t";
        GsonCompatibilityMode.REPLACEMENT_CHARS[8] = "\\b";
        GsonCompatibilityMode.REPLACEMENT_CHARS[10] = "\\n";
        GsonCompatibilityMode.REPLACEMENT_CHARS[13] = "\\r";
        GsonCompatibilityMode.REPLACEMENT_CHARS[12] = "\\f";
        HTML_SAFE_REPLACEMENT_CHARS = (String[])REPLACEMENT_CHARS.clone();
        GsonCompatibilityMode.HTML_SAFE_REPLACEMENT_CHARS[60] = "\\u003c";
        GsonCompatibilityMode.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        GsonCompatibilityMode.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        GsonCompatibilityMode.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        GsonCompatibilityMode.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
    }

    public static class Builder
    extends Config.Builder {
        private boolean excludeFieldsWithoutExposeAnnotation = false;
        private boolean disableHtmlEscaping = false;
        private ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return DateFormat.getDateTimeInstance(2, 2, Locale.US);
            }
        };
        private FieldNamingStrategy fieldNamingStrategy;
        private Double version;
        private Set<ExclusionStrategy> serializationExclusionStrategies = new HashSet<ExclusionStrategy>();
        private Set<ExclusionStrategy> deserializationExclusionStrategies = new HashSet<ExclusionStrategy>();

        public Builder() {
            this.omitDefaultValue(true);
        }

        public Builder excludeFieldsWithoutExposeAnnotation() {
            this.excludeFieldsWithoutExposeAnnotation = true;
            return this;
        }

        public Builder serializeNulls() {
            this.omitDefaultValue(false);
            return this;
        }

        public Builder setDateFormat(int dateStyle) {
            return this;
        }

        public Builder setDateFormat(final int dateStyle, final int timeStyle) {
            this.dateFormat = new ThreadLocal<DateFormat>(){

                @Override
                protected DateFormat initialValue() {
                    return DateFormat.getDateTimeInstance(dateStyle, timeStyle, Locale.US);
                }
            };
            return this;
        }

        public Builder setDateFormat(final String pattern) {
            this.dateFormat = new ThreadLocal<DateFormat>(){

                @Override
                protected DateFormat initialValue() {
                    return new SimpleDateFormat(pattern, Locale.US);
                }
            };
            return this;
        }

        public Builder setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
            this.fieldNamingStrategy = fieldNamingStrategy;
            return this;
        }

        public Builder setFieldNamingPolicy(FieldNamingPolicy namingConvention) {
            this.fieldNamingStrategy = namingConvention;
            return this;
        }

        public Builder setPrettyPrinting() {
            this.indentionStep(2);
            return this;
        }

        public Builder disableHtmlEscaping() {
            this.disableHtmlEscaping = true;
            return this;
        }

        public Builder setVersion(double version) {
            this.version = version;
            return this;
        }

        public Builder setExclusionStrategies(ExclusionStrategy ... strategies) {
            for (ExclusionStrategy strategy : strategies) {
                this.addSerializationExclusionStrategy(strategy);
            }
            return this;
        }

        public Builder addSerializationExclusionStrategy(ExclusionStrategy exclusionStrategy) {
            this.serializationExclusionStrategies.add(exclusionStrategy);
            return this;
        }

        public Builder addDeserializationExclusionStrategy(ExclusionStrategy exclusionStrategy) {
            this.deserializationExclusionStrategies.add(exclusionStrategy);
            return this;
        }

        @Override
        public GsonCompatibilityMode build() {
            this.escapeUnicode(false);
            return (GsonCompatibilityMode)super.build();
        }

        @Override
        protected Config doBuild(String configName) {
            return new GsonCompatibilityMode(configName, this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Builder builder = (Builder)o;
            if (this.excludeFieldsWithoutExposeAnnotation != builder.excludeFieldsWithoutExposeAnnotation) {
                return false;
            }
            if (this.disableHtmlEscaping != builder.disableHtmlEscaping) {
                return false;
            }
            if (!this.dateFormat.get().equals(builder.dateFormat.get())) {
                return false;
            }
            if (this.fieldNamingStrategy != null ? !this.fieldNamingStrategy.equals(builder.fieldNamingStrategy) : builder.fieldNamingStrategy != null) {
                return false;
            }
            if (this.version != null ? !this.version.equals(builder.version) : builder.version != null) {
                return false;
            }
            if (this.serializationExclusionStrategies != null ? !this.serializationExclusionStrategies.equals(builder.serializationExclusionStrategies) : builder.serializationExclusionStrategies != null) {
                return false;
            }
            return this.deserializationExclusionStrategies != null ? this.deserializationExclusionStrategies.equals(builder.deserializationExclusionStrategies) : builder.deserializationExclusionStrategies == null;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.excludeFieldsWithoutExposeAnnotation ? 1 : 0);
            result = 31 * result + (this.disableHtmlEscaping ? 1 : 0);
            result = 31 * result + this.dateFormat.get().hashCode();
            result = 31 * result + (this.fieldNamingStrategy != null ? this.fieldNamingStrategy.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.serializationExclusionStrategies != null ? this.serializationExclusionStrategies.hashCode() : 0);
            result = 31 * result + (this.deserializationExclusionStrategies != null ? this.deserializationExclusionStrategies.hashCode() : 0);
            return result;
        }

        @Override
        public Config.Builder copy() {
            Builder copied = (Builder)super.copy();
            copied.excludeFieldsWithoutExposeAnnotation = this.excludeFieldsWithoutExposeAnnotation;
            copied.disableHtmlEscaping = this.disableHtmlEscaping;
            copied.dateFormat = this.dateFormat;
            copied.fieldNamingStrategy = this.fieldNamingStrategy;
            copied.version = this.version;
            copied.serializationExclusionStrategies = new HashSet<ExclusionStrategy>(this.serializationExclusionStrategies);
            copied.deserializationExclusionStrategies = new HashSet<ExclusionStrategy>(this.deserializationExclusionStrategies);
            return copied;
        }
    }
}

