/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.any.Any;
import com.jsoniter.output.Codegen;
import com.jsoniter.output.CodegenImplNative;
import com.jsoniter.output.EncodingMode;
import com.jsoniter.output.JsonStreamPool;
import com.jsoniter.output.StreamImplNumber;
import com.jsoniter.output.StreamImplString;
import com.jsoniter.spi.Config;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.Slice;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;

public class JsonStream
extends OutputStream {
    public Config configCache;
    int indention = 0;
    private OutputStream out;
    byte[] buf;
    int count;

    public JsonStream(OutputStream out, int bufSize) {
        if (bufSize < 32) {
            throw new JsonException("buffer size must be larger than 32: " + bufSize);
        }
        this.out = out;
        this.buf = new byte[bufSize];
    }

    public void reset(OutputStream out) {
        this.out = out;
        this.count = 0;
    }

    final void ensure(int minimal) throws IOException {
        int available = this.buf.length - this.count;
        if (available < minimal) {
            if (this.count > 1024) {
                this.flushBuffer();
            }
            this.growAtLeast(minimal);
        }
    }

    private final void growAtLeast(int minimal) {
        int toGrow = this.buf.length;
        if (toGrow < minimal) {
            toGrow = minimal;
        }
        byte[] newBuf = new byte[this.buf.length + toGrow];
        System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
        this.buf = newBuf;
    }

    @Override
    public final void write(int b) throws IOException {
        this.ensure(1);
        this.buf[this.count++] = (byte)b;
    }

    public final void write(byte b1, byte b2) throws IOException {
        this.ensure(2);
        this.buf[this.count++] = b1;
        this.buf[this.count++] = b2;
    }

    public final void write(byte b1, byte b2, byte b3) throws IOException {
        this.ensure(3);
        this.buf[this.count++] = b1;
        this.buf[this.count++] = b2;
        this.buf[this.count++] = b3;
    }

    public final void write(byte b1, byte b2, byte b3, byte b4) throws IOException {
        this.ensure(4);
        this.buf[this.count++] = b1;
        this.buf[this.count++] = b2;
        this.buf[this.count++] = b3;
        this.buf[this.count++] = b4;
    }

    public final void write(byte b1, byte b2, byte b3, byte b4, byte b5) throws IOException {
        this.ensure(5);
        this.buf[this.count++] = b1;
        this.buf[this.count++] = b2;
        this.buf[this.count++] = b3;
        this.buf[this.count++] = b4;
        this.buf[this.count++] = b5;
    }

    public final void write(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6) throws IOException {
        this.ensure(6);
        this.buf[this.count++] = b1;
        this.buf[this.count++] = b2;
        this.buf[this.count++] = b3;
        this.buf[this.count++] = b4;
        this.buf[this.count++] = b5;
        this.buf[this.count++] = b6;
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        if (this.out == null) {
            this.ensure(len);
        } else if (len >= this.buf.length - this.count) {
            if (len >= this.buf.length) {
                this.flushBuffer();
                this.out.write(b, off, len);
                return;
            }
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        if (this.count > 0) {
            this.flushBuffer();
        }
        this.out.close();
        this.out = null;
        this.count = 0;
    }

    final void flushBuffer() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.write(this.buf, 0, this.count);
        this.count = 0;
    }

    public final void writeVal(String val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            StreamImplString.writeString(this, val);
        }
    }

    public final void writeRaw(String val) throws IOException {
        this.writeRaw(val, val.length());
    }

    public final void writeRaw(String val, int remaining) throws IOException {
        int j;
        int available;
        if (this.out == null) {
            this.ensure(remaining);
            val.getBytes(0, remaining, this.buf, this.count);
            this.count += remaining;
            return;
        }
        int i = 0;
        while ((available = this.buf.length - this.count) < remaining) {
            remaining -= available;
            j = i + available;
            val.getBytes(i, j, this.buf, this.count);
            this.count = this.buf.length;
            this.flushBuffer();
            i = j;
        }
        j = i + remaining;
        val.getBytes(i, j, this.buf, this.count);
        this.count += remaining;
    }

    public final void writeVal(Boolean val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else if (val.booleanValue()) {
            this.writeTrue();
        } else {
            this.writeFalse();
        }
    }

    public final void writeVal(boolean val) throws IOException {
        if (val) {
            this.writeTrue();
        } else {
            this.writeFalse();
        }
    }

    public final void writeTrue() throws IOException {
        this.write((byte)116, (byte)114, (byte)117, (byte)101);
    }

    public final void writeFalse() throws IOException {
        this.write((byte)102, (byte)97, (byte)108, (byte)115, (byte)101);
    }

    public final void writeVal(Short val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            this.writeVal(val.intValue());
        }
    }

    public final void writeVal(short val) throws IOException {
        this.writeVal((int)val);
    }

    public final void writeVal(Integer val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            this.writeVal((int)val);
        }
    }

    public final void writeVal(int val) throws IOException {
        StreamImplNumber.writeInt(this, val);
    }

    public final void writeVal(Long val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            this.writeVal((long)val);
        }
    }

    public final void writeVal(long val) throws IOException {
        StreamImplNumber.writeLong(this, val);
    }

    public final void writeVal(Float val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            this.writeVal(val.floatValue());
        }
    }

    public final void writeVal(float val) throws IOException {
        StreamImplNumber.writeFloat(this, val);
    }

    public final void writeVal(Double val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            this.writeVal((double)val);
        }
    }

    public final void writeVal(double val) throws IOException {
        StreamImplNumber.writeDouble(this, val);
    }

    public final void writeVal(Any val) throws IOException {
        val.writeTo(this);
    }

    public final void writeNull() throws IOException {
        this.write((byte)110, (byte)117, (byte)108, (byte)108);
    }

    public final void writeEmptyObject() throws IOException {
        this.write((byte)123, (byte)125);
    }

    public final void writeEmptyArray() throws IOException {
        this.write((byte)91, (byte)93);
    }

    public final void writeArrayStart() throws IOException {
        this.indention += this.currentConfig().indentionStep();
        this.write(91);
    }

    public final void writeMore() throws IOException {
        this.write(44);
        this.writeIndention();
    }

    public void writeIndention() throws IOException {
        this.writeIndention(0);
    }

    private void writeIndention(int delta) throws IOException {
        if (this.indention == 0) {
            return;
        }
        this.write(10);
        int toWrite = this.indention - delta;
        this.ensure(toWrite);
        for (int i = 0; i < toWrite && this.count < this.buf.length; ++i) {
            this.buf[this.count++] = 32;
        }
    }

    public final void writeArrayEnd() throws IOException {
        int indentionStep = this.currentConfig().indentionStep();
        this.writeIndention(indentionStep);
        this.indention -= indentionStep;
        this.write(93);
    }

    public final void writeObjectStart() throws IOException {
        int indentionStep = this.currentConfig().indentionStep();
        this.indention += indentionStep;
        this.write(123);
    }

    public final void writeObjectField(String field) throws IOException {
        this.writeVal(field);
        if (this.indention > 0) {
            this.write((byte)58, (byte)32);
        } else {
            this.write(58);
        }
    }

    public final void writeObjectEnd() throws IOException {
        int indentionStep = this.currentConfig().indentionStep();
        this.writeIndention(indentionStep);
        this.indention -= indentionStep;
        this.write(125);
    }

    public final void writeVal(Object obj) throws IOException {
        if (obj == null) {
            this.writeNull();
            return;
        }
        Class<?> clazz = obj.getClass();
        String cacheKey = this.currentConfig().getEncoderCacheKey(clazz);
        Codegen.getEncoder(cacheKey, clazz).encode(obj, this);
    }

    public final <T> void writeVal(TypeLiteral<T> typeLiteral, T obj) throws IOException {
        if (null == obj) {
            this.writeNull();
        } else {
            Config config2 = this.currentConfig();
            String cacheKey = config2.getEncoderCacheKey(typeLiteral.getType());
            Codegen.getEncoder(cacheKey, typeLiteral.getType()).encode(obj, this);
        }
    }

    public final <T> void writeVal(Type type, T obj) throws IOException {
        if (null == obj) {
            this.writeNull();
        } else {
            Config config2 = this.currentConfig();
            String cacheKey = config2.getEncoderCacheKey(type);
            Codegen.getEncoder(cacheKey, type).encode(obj, this);
        }
    }

    public Config currentConfig() {
        if (this.configCache != null) {
            return this.configCache;
        }
        this.configCache = JsoniterSpi.getCurrentConfig();
        return this.configCache;
    }

    public static void serialize(Config config2, Object obj, OutputStream out) {
        JsoniterSpi.setCurrentConfig(config2);
        try {
            JsonStream.serialize(obj, out);
        }
        finally {
            JsoniterSpi.clearCurrentConfig();
        }
    }

    public static void serialize(Object obj, OutputStream out) {
        JsonStream stream = JsonStreamPool.borrowJsonStream();
        try {
            try {
                stream.reset(out);
                stream.writeVal(obj);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonStreamPool.returnJsonStream(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Config config2, TypeLiteral typeLiteral, Object obj, OutputStream out) {
        JsoniterSpi.setCurrentConfig(config2);
        try {
            JsonStream.serialize(typeLiteral, obj, out);
        }
        finally {
            JsoniterSpi.clearCurrentConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(TypeLiteral typeLiteral, Object obj, OutputStream out) {
        JsonStream stream = JsonStreamPool.borrowJsonStream();
        try {
            try {
                stream.reset(out);
                stream.writeVal(typeLiteral, obj);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonStreamPool.returnJsonStream(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Type type, Object obj, OutputStream out) {
        JsonStream stream = JsonStreamPool.borrowJsonStream();
        try {
            try {
                stream.reset(out);
                stream.writeVal(type, obj);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonStreamPool.returnJsonStream(stream);
        }
    }

    public static String serialize(Config config2, Object obj) {
        JsoniterSpi.setCurrentConfig(config2);
        try {
            String string = JsonStream.serialize(config2.escapeUnicode(), obj.getClass(), obj);
            return string;
        }
        finally {
            JsoniterSpi.clearCurrentConfig();
        }
    }

    public static String serialize(Object obj) {
        return JsonStream.serialize(JsoniterSpi.getCurrentConfig().escapeUnicode(), obj.getClass(), obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serialize(Config config2, TypeLiteral typeLiteral, Object obj) {
        JsoniterSpi.setCurrentConfig(config2);
        try {
            String string = JsonStream.serialize(config2.escapeUnicode(), typeLiteral.getType(), obj);
            return string;
        }
        finally {
            JsoniterSpi.clearCurrentConfig();
        }
    }

    public static String serialize(TypeLiteral typeLiteral, Object obj) {
        return JsonStream.serialize(JsoniterSpi.getCurrentConfig().escapeUnicode(), typeLiteral.getType(), obj);
    }

    public static String serialize(boolean escapeUnicode, Type type, Object obj) {
        JsonStream stream = JsonStreamPool.borrowJsonStream();
        try {
            stream.reset(null);
            stream.writeVal(type, obj);
            if (escapeUnicode) {
                String string = new String(stream.buf, 0, stream.count);
                return string;
            }
            String string = new String(stream.buf, 0, stream.count, "UTF8");
            return string;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonStreamPool.returnJsonStream(stream);
        }
    }

    public static void setMode(EncodingMode mode) {
        Config newConfig = JsoniterSpi.getDefaultConfig().copyBuilder().encodingMode(mode).build();
        JsoniterSpi.setDefaultConfig(newConfig);
        JsoniterSpi.setCurrentConfig(newConfig);
    }

    public static void setIndentionStep(int indentionStep) {
        Config newConfig = JsoniterSpi.getDefaultConfig().copyBuilder().indentionStep(indentionStep).build();
        JsoniterSpi.setDefaultConfig(newConfig);
        JsoniterSpi.setCurrentConfig(newConfig);
    }

    public static void registerNativeEncoder(Class clazz, Encoder.ReflectionEncoder encoder) {
        CodegenImplNative.NATIVE_ENCODERS.put(clazz, encoder);
    }

    public Slice buffer() {
        return new Slice(this.buf, 0, this.count);
    }
}

