/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.eventuate;

import com.jsoniter.any.Any;
import com.networknt.codegen.Generator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import templates.eventuate.hybrid.LICENSE;
import templates.eventuate.hybrid.classpath;
import templates.eventuate.hybrid.clientYml;
import templates.eventuate.hybrid.eventuateClient;
import templates.eventuate.hybrid.gitignore;
import templates.eventuate.hybrid.kafka;
import templates.eventuate.hybrid.logback;
import templates.eventuate.hybrid.primaryCrt;
import templates.eventuate.hybrid.project;
import templates.eventuate.hybrid.secondaryCrt;
import templates.eventuate.hybrid.secretYml;
import templates.eventuate.hybrid.securityYml;
import templates.eventuate.hybrid.server.README;
import templates.eventuate.hybrid.server.buildSh;
import templates.eventuate.hybrid.server.dockerfile;
import templates.eventuate.hybrid.server.dockerfileredhat;
import templates.eventuate.hybrid.server.pom;
import templates.eventuate.hybrid.serverYml;
import templates.eventuate.hybrid.serviceYml;

public class EventuateHybridServerGenerator
implements Generator {
    @Override
    public String getFramework() {
        return "light-hybrid-4j-server";
    }

    @Override
    public void generate(String targetPath, Object model2, Any config2) throws IOException {
        String rootPackage = config2.get((Object)"rootPackage").toString();
        String modelPackage = config2.get((Object)"modelPackage").toString();
        String handlerPackage = config2.get((Object)"handlerPackage").toString();
        boolean enableHttp = config2.toBoolean("enableHttp");
        String httpPort = config2.toString("httpPort");
        boolean enableHttps = config2.toBoolean("enableHttps");
        String httpsPort = config2.toString("httpsPort");
        boolean enableRegistry = config2.toBoolean("enableRegistry");
        String dockerOrganization = config2.toString("dockerOrganization");
        String version = config2.toString("version");
        if (dockerOrganization == null || dockerOrganization.length() == 0) {
            dockerOrganization = "networknt";
        }
        boolean supportClient = config2.toBoolean("supportClient");
        boolean eventuateQueryModule = config2.toBoolean("eventuateQueryModule");
        boolean eventuateCommandModule = config2.toBoolean("eventuateCommandModule");
        this.transfer(targetPath, "", "pom.xml", pom.template(config2));
        String expose = "";
        expose = enableHttps ? httpsPort : httpPort;
        this.transfer(targetPath, "docker", "Dockerfile", dockerfile.template(config2, expose));
        this.transfer(targetPath, "docker", "Dockerfile-Redhat", dockerfileredhat.template(config2, expose));
        this.transfer(targetPath, "", "build.sh", buildSh.template(dockerOrganization, config2.get((Object)"groupId") + "." + config2.get((Object)"artifactId") + "-" + config2.get((Object)"version")));
        this.transfer(targetPath, "", ".gitignore", gitignore.template());
        this.transfer(targetPath, "", "README.md", README.template());
        this.transfer(targetPath, "", "LICENSE", LICENSE.template());
        this.transfer(targetPath, "", ".classpath", classpath.template());
        this.transfer(targetPath, "", ".project", project.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", serviceYml.template(config2));
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "server.yml", serverYml.template(config2.get((Object)"groupId") + "." + config2.get((Object)"artifactId") + "-" + config2.get((Object)"version"), enableHttp, httpPort, enableHttps, httpsPort, enableRegistry, version));
        this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "server.yml", serverYml.template(config2.get((Object)"groupId") + "." + config2.get((Object)"artifactId") + "-" + config2.get((Object)"version"), enableHttp, "49587", enableHttps, "49588", enableRegistry, version));
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secret.yml", secretYml.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "hybrid-security.yml", securityYml.template());
        if (supportClient) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        } else {
            this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        }
        if (eventuateQueryModule) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "kafka.yml", kafka.template());
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "eventuate-client.yml", eventuateClient.template());
        }
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "primary.crt", primaryCrt.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secondary.crt", secondaryCrt.template());
        this.transfer(targetPath, "src.main.resources".replace(".", File.separator), "logback.xml", logback.template());
        this.transfer(targetPath, "src.test.resources".replace(".", File.separator), "logback-test.xml", logback.template());
        try (InputStream is = EventuateHybridServerGenerator.class.getResourceAsStream("/binaries/server.keystore");){
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "server.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        is = EventuateHybridServerGenerator.class.getResourceAsStream("/binaries/server.truststore");
        var19_19 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "server.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var19_19 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var19_19 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var19_19.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        if (supportClient) {
            is = EventuateHybridServerGenerator.class.getResourceAsStream("/binaries/client.keystore");
            var19_19 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var19_19 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var19_19 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var19_19.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            is = EventuateHybridServerGenerator.class.getResourceAsStream("/binaries/client.truststore");
            var19_19 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var19_19 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var19_19 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var19_19.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        is = EventuateHybridServerGenerator.class.getResourceAsStream("/binaries/client.keystore");
        var19_19 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var19_19 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var19_19 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var19_19.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        is = EventuateHybridServerGenerator.class.getResourceAsStream("/binaries/client.truststore");
        var19_19 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var19_19 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var19_19 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var19_19.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
    }
}

