/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.graphql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jsoniter.any.Any;
import com.networknt.codegen.Generator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import templates.graphql.LICENSE;
import templates.graphql.README;
import templates.graphql.buildSh;
import templates.graphql.classpath;
import templates.graphql.clientYml;
import templates.graphql.dockerfile;
import templates.graphql.dockerfileredhat;
import templates.graphql.gitignore;
import templates.graphql.logback;
import templates.graphql.pom;
import templates.graphql.primaryCrt;
import templates.graphql.project;
import templates.graphql.schemaClass;
import templates.graphql.schemaClassExample;
import templates.graphql.secondaryCrt;
import templates.graphql.secretYml;
import templates.graphql.securityYml;
import templates.graphql.serverYml;
import templates.graphql.serviceYml;
import templates.graphql.validatorYml;

public class GraphqlGenerator
implements Generator {
    static ObjectMapper mapper = new ObjectMapper();

    @Override
    public String getFramework() {
        return "light-graphql-4j";
    }

    @Override
    public void generate(String targetPath, Object model2, Any config2) throws IOException {
        String schemaPackage = config2.get((Object)"schemaPackage").toString();
        String schemaClass2 = config2.get((Object)"schemaClass").toString();
        boolean overwriteSchemaClass = config2.toBoolean("overwriteSchemaClass");
        boolean enableHttp = config2.toBoolean("enableHttp");
        String httpPort = config2.toString("httpPort");
        boolean enableHttps = config2.toBoolean("enableHttps");
        String httpsPort = config2.toString("httpsPort");
        boolean enableRegistry = config2.toBoolean("enableRegistry");
        boolean supportClient = config2.toBoolean("supportClient");
        String dockerOrganization = config2.toString("dockerOrganization");
        String version = config2.toString("version");
        if (dockerOrganization == null || dockerOrganization.length() == 0) {
            dockerOrganization = "networknt";
        }
        this.transfer(targetPath, "", "pom.xml", pom.template(config2));
        String expose = "";
        expose = enableHttps ? httpsPort : httpPort;
        this.transfer(targetPath, "docker", "Dockerfile", dockerfile.template(config2, expose));
        this.transfer(targetPath, "docker", "Dockerfile-Redhat", dockerfileredhat.template(config2, expose));
        this.transfer(targetPath, "", "build.sh", buildSh.template(dockerOrganization, config2.get((Object)"groupId") + "." + config2.get((Object)"artifactId") + "-" + config2.get((Object)"version")));
        this.transfer(targetPath, "", ".gitignore", gitignore.template());
        this.transfer(targetPath, "", "README.md", README.template());
        this.transfer(targetPath, "", "LICENSE", LICENSE.template());
        this.transfer(targetPath, "", ".classpath", classpath.template());
        this.transfer(targetPath, "", ".project", project.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", serviceYml.template(config2));
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "server.yml", serverYml.template(config2.get((Object)"groupId") + "." + config2.get((Object)"artifactId") + "-" + config2.get((Object)"version"), enableHttp, httpPort, enableHttps, httpsPort, enableRegistry, version));
        this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "server.yml", serverYml.template(config2.get((Object)"groupId") + "." + config2.get((Object)"artifactId") + "-" + config2.get((Object)"version"), enableHttp, "49587", enableHttps, "49588", enableRegistry, version));
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secret.yml", secretYml.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "graphql-security.yml", securityYml.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "graphql-validator.yml", validatorYml.template());
        if (supportClient) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        } else {
            this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        }
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "primary.crt", primaryCrt.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secondary.crt", secondaryCrt.template());
        this.transfer(targetPath, "src.main.resources".replace(".", File.separator), "logback.xml", logback.template());
        this.transfer(targetPath, "src.test.resources".replace(".", File.separator), "logback-test.xml", logback.template());
        if (overwriteSchemaClass) {
            if (model2 == null) {
                this.transfer(targetPath, ("src.main.java." + schemaPackage).replace(".", File.separator), schemaClass2 + ".java", schemaClassExample.template(schemaPackage, schemaClass2));
            } else {
                Files.write(FileSystems.getDefault().getPath(targetPath, "src.main.resources".replace(".", File.separator), "schema.graphqls"), ((String)model2).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                this.transfer(targetPath, ("src.main.java." + schemaPackage).replace(".", File.separator), schemaClass2 + ".java", schemaClass.template(schemaPackage, schemaClass2));
            }
        }
        try (InputStream is = GraphqlGenerator.class.getResourceAsStream("/binaries/server.keystore");){
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "server.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        is = GraphqlGenerator.class.getResourceAsStream("/binaries/server.truststore");
        var17_17 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "server.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var17_17 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var17_17 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var17_17.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        if (supportClient) {
            is = GraphqlGenerator.class.getResourceAsStream("/binaries/client.keystore");
            var17_17 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var17_17 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var17_17 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var17_17.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            is = GraphqlGenerator.class.getResourceAsStream("/binaries/client.truststore");
            var17_17 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var17_17 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var17_17 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var17_17.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        is = GraphqlGenerator.class.getResourceAsStream("/binaries/client.keystore");
        var17_17 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var17_17 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var17_17 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var17_17.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        is = GraphqlGenerator.class.getResourceAsStream("/binaries/client.truststore");
        var17_17 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var17_17 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var17_17 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var17_17.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
    }
}

