/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.hybrid;

import com.jsoniter.any.Any;
import com.networknt.codegen.Generator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import templates.hybrid.LICENSE;
import templates.hybrid.classpath;
import templates.hybrid.clientYml;
import templates.hybrid.gitignore;
import templates.hybrid.logback;
import templates.hybrid.primaryCrt;
import templates.hybrid.project;
import templates.hybrid.secondaryCrt;
import templates.hybrid.secretYml;
import templates.hybrid.securityYml;
import templates.hybrid.server.README;
import templates.hybrid.server.buildSh;
import templates.hybrid.server.dockerfile;
import templates.hybrid.server.dockerfileredhat;
import templates.hybrid.server.pom;
import templates.hybrid.serverYml;
import templates.hybrid.serviceYml;

public class HybridServerGenerator
implements Generator {
    @Override
    public String getFramework() {
        return "light-hybrid-4j-server";
    }

    @Override
    public void generate(String targetPath, Object model2, Any config2) throws IOException {
        String rootPackage = config2.get((Object)"rootPackage").toString();
        String modelPackage = config2.get((Object)"modelPackage").toString();
        String handlerPackage = config2.get((Object)"handlerPackage").toString();
        boolean enableHttp = config2.toBoolean("enableHttp");
        String httpPort = config2.toString("httpPort");
        boolean enableHttps = config2.toBoolean("enableHttps");
        String httpsPort = config2.toString("httpsPort");
        boolean enableRegistry = config2.toBoolean("enableRegistry");
        String dockerOrganization = config2.toString("dockerOrganization");
        String version = config2.toString("version");
        if (dockerOrganization == null || dockerOrganization.length() == 0) {
            dockerOrganization = "networknt";
        }
        boolean supportClient = config2.toBoolean("supportClient");
        this.transfer(targetPath, "", "pom.xml", pom.template(config2));
        String expose = "";
        expose = enableHttps ? httpsPort : httpPort;
        this.transfer(targetPath, "docker", "Dockerfile", dockerfile.template(config2, expose));
        this.transfer(targetPath, "docker", "Dockerfile-Redhat", dockerfileredhat.template(config2, expose));
        this.transfer(targetPath, "", "build.sh", buildSh.template(dockerOrganization, config2.get((Object)"groupId") + "." + config2.get((Object)"artifactId") + "-" + config2.get((Object)"version")));
        this.transfer(targetPath, "", ".gitignore", gitignore.template());
        this.transfer(targetPath, "", "README.md", README.template());
        this.transfer(targetPath, "", "LICENSE", LICENSE.template());
        this.transfer(targetPath, "", ".classpath", classpath.template());
        this.transfer(targetPath, "", ".project", project.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "service.yml", serviceYml.template(config2));
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "server.yml", serverYml.template(config2.get((Object)"groupId") + "." + config2.get((Object)"artifactId") + "-" + config2.get((Object)"version"), enableHttp, httpPort, enableHttps, httpsPort, enableRegistry, version));
        this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "server.yml", serverYml.template(config2.get((Object)"groupId") + "." + config2.get((Object)"artifactId") + "-" + config2.get((Object)"version"), enableHttp, "49587", enableHttps, "49588", enableRegistry, version));
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secret.yml", secretYml.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "hybrid-security.yml", securityYml.template());
        if (supportClient) {
            this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        } else {
            this.transfer(targetPath, "src.test.resources.config".replace(".", File.separator), "client.yml", clientYml.template());
        }
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "primary.crt", primaryCrt.template());
        this.transfer(targetPath, "src.main.resources.config".replace(".", File.separator), "secondary.crt", secondaryCrt.template());
        this.transfer(targetPath, "src.main.resources".replace(".", File.separator), "logback.xml", logback.template());
        this.transfer(targetPath, "src.test.resources".replace(".", File.separator), "logback-test.xml", logback.template());
        try (InputStream is = HybridServerGenerator.class.getResourceAsStream("/binaries/server.keystore");){
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "server.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        is = HybridServerGenerator.class.getResourceAsStream("/binaries/server.truststore");
        var17_17 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "server.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var17_17 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var17_17 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var17_17.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        if (supportClient) {
            is = HybridServerGenerator.class.getResourceAsStream("/binaries/client.keystore");
            var17_17 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var17_17 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var17_17 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var17_17.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            is = HybridServerGenerator.class.getResourceAsStream("/binaries/client.truststore");
            var17_17 = null;
            try {
                Files.copy(is, Paths.get(targetPath, "src.main.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable) {
                var17_17 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var17_17 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var17_17.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        is = HybridServerGenerator.class.getResourceAsStream("/binaries/client.keystore");
        var17_17 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config".replace(".", File.separator), "client.keystore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var17_17 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var17_17 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var17_17.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
        is = HybridServerGenerator.class.getResourceAsStream("/binaries/client.truststore");
        var17_17 = null;
        try {
            Files.copy(is, Paths.get(targetPath, "src.test.resources.config".replace(".", File.separator), "client.truststore"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            var17_17 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var17_17 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        var17_17.addSuppressed(throwable);
                    }
                } else {
                    is.close();
                }
            }
        }
    }
}

