/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.rest;

import com.networknt.oas.model.Parameter;
import com.networknt.oas.model.Schema;
import com.networknt.utility.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlGenerator {
    private static final String NUMBER = "number";
    private static final String INTEGER = "integer";
    private static final String STRING = "string";
    private static final String BOOLEAN = "boolean";
    private static final String INT32 = "int32";
    private static final String INT64 = "int64";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final int DEFAULT_MIN_NUM = 1;
    private static final int DEFAULT_MAX_NUM = 100;
    private static final int DEFAULT_MIN_LENGTH = 5;
    private static final int DEFAULT_MAX_LENGTH = 30;
    private static final String PATH_TEMPLATE_PATTERN = "\\{(.*?)\\}";
    private static final String IN_PATH = "path";
    private static final String IN_QUERY = "query";
    private static final Logger logger = LoggerFactory.getLogger(UrlGenerator.class);

    public static String generateUrl(String basePath, String path, List<Parameter> parameters) {
        String url = basePath + path;
        if (!parameters.isEmpty()) {
            Optional<Parameter> pathParameter = parameters.stream().filter(parameter -> IN_PATH.equals(parameter.getIn())).findFirst();
            if (pathParameter.isPresent()) {
                String pathParameterStr = UrlGenerator.generateValidParam(pathParameter.get());
                path = path.replaceAll(PATH_TEMPLATE_PATTERN, pathParameterStr);
            }
            url = basePath + path + UrlGenerator.generateQueryParamUrl(parameters);
        }
        return url;
    }

    public static String generateQueryParamUrl(List<Parameter> parameters) {
        String url = "";
        url = StringUtils.isBlank(url = url + parameters.stream().filter(parameter -> IN_QUERY.equals(parameter.getIn())).map(parameter -> parameter.getName() + "=" + UrlGenerator.generateValidParam(parameter)).collect(Collectors.joining("&"))) ? "" : "?" + url;
        return url;
    }

    private static String generateEncodedValidParam(Parameter parameter) {
        String encoded = "";
        try {
            encoded = URLEncoder.encode(UrlGenerator.generateValidParam(parameter), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encoded;
    }

    protected static String generateValidParam(Parameter parameter) {
        String type;
        String validParam = "";
        Schema schema = parameter.getSchema();
        if (!schema.getAllOfSchemas().isEmpty() || !schema.getOneOfSchemas().isEmpty()) {
            logger.info("dont support one of/ all of schema test case generation");
            return "";
        }
        if (!schema.getAnyOfSchemas().isEmpty()) {
            schema = schema.getAnyOfSchemas().get(0);
        }
        if (!StringUtils.isEmpty(type = schema.getType())) {
            if (NUMBER.equals(type.toLowerCase()) || INTEGER.equals(type.toLowerCase())) {
                validParam = UrlGenerator.generateValidNum(schema);
            } else if (type.toLowerCase().equals(STRING)) {
                validParam = UrlGenerator.generateValidStr(schema);
            } else if (type.toLowerCase().equals(BOOLEAN)) {
                validParam = UrlGenerator.generateValidBool(schema);
            } else {
                logger.info("unsupported param type to generate test case: {}/ {}", (Object)parameter.getName(), (Object)type);
            }
        }
        return validParam;
    }

    private static String generateValidBool(Schema schema) {
        return ThreadLocalRandom.current().nextBoolean() ? TRUE : FALSE;
    }

    private static String generateValidStr(Schema schema) {
        String validStr;
        int maxLength;
        int minLength = schema.getMinLength() == null ? 5 : schema.getMinLength();
        int n = maxLength = schema.getMaxLength() == null ? 30 : schema.getMaxLength();
        if (maxLength <= minLength) {
            logger.error("maximum length {} should be larger than minimum length {}", (Object)maxLength, (Object)minLength);
            validStr = RandomStringUtils.random(ThreadLocalRandom.current().nextInt(5, 30), true, false);
        } else {
            validStr = RandomStringUtils.random(ThreadLocalRandom.current().nextInt(minLength, maxLength), true, false);
        }
        return validStr;
    }

    private static String generateValidNum(Schema schema) {
        String format = StringUtils.isBlank(schema.getFormat()) ? INT32 : schema.getFormat();
        Number min = schema.getMinimum() == null ? (Number)1 : (Number)schema.getMinimum();
        Number max = schema.getMaximum() == null ? (Number)100 : (Number)schema.getMaximum();
        String validNumStr = "";
        if (INT32.equals(format) || INT64.equals(format)) {
            int validInt;
            do {
                validInt = ThreadLocalRandom.current().nextInt(min.intValue(), max.intValue());
            } while (Boolean.TRUE.equals(schema.getExclusiveMinimum()) && validInt == min.intValue() || Boolean.TRUE.equals(schema.getExclusiveMaximum()) && validInt == max.intValue());
            validNumStr = String.valueOf(validInt);
        } else if (DOUBLE.equals(format) || FLOAT.equals(format)) {
            double validDouble;
            do {
                validDouble = ThreadLocalRandom.current().nextDouble(min.doubleValue(), max.doubleValue());
            } while (Boolean.TRUE.equals(schema.getExclusiveMinimum()) && validDouble == (double)min.intValue() || Boolean.TRUE.equals(schema.getExclusiveMaximum()) && validDouble == (double)max.intValue());
            validNumStr = String.valueOf(validDouble);
        }
        return validNumStr;
    }
}

