/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.rest;

import com.jsoniter.any.Any;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.resolver.Resolver;

public class YAMLFileParameterizer {
    private static final Logger logger = LoggerFactory.getLogger(YAMLFileParameterizer.class);
    private static final String KEY_SEPARATOR = ".";
    private static final String YML_EXT = ".yml";
    private static final String BAK_EXT = ".bak";
    private static final String SLASH = "/";
    public static final String GENERATE_ENV_VARS = "generateEnvVars";
    public static final String CLASS_PATH_PREFIX = "classpath:";
    public static final String DEFAULT_RESOURCE_LOCATION = "classpath:handlerconfig/";
    public static final String DEFAULT_DEST_DIR = "src/main/resources/config";
    protected static final String KEY_GENERATE = "generate";
    protected static final String KEY_SKIP_ARRAY = "skipArray";
    protected static final String KEY_SKIP_MAP = "skipMap";
    protected static final String KEY_IN_PLACE = "inPlace";
    protected static final String KEY_EXCLUDE = "exclude";

    public static void rewriteAll(String dir, Map<String, Any> generateEnvVars) {
        if (logger.isDebugEnabled()) {
            logger.debug("rewriting files in {}", (Object)dir);
        }
        generateEnvVars.put(KEY_IN_PLACE, Any.wrap(true));
        YAMLFileParameterizer.rewriteFiles(new File(dir), new File(dir), generateEnvVars);
    }

    public static void rewriteAll(String srcLocation, String destDir, Map<String, Any> generateEnvVars) {
        if (logger.isDebugEnabled()) {
            logger.debug("rewriting files in {}", (Object)srcLocation);
        }
        if (YAMLFileParameterizer.fromClasspath(srcLocation)) {
            YAMLFileParameterizer.rewriteResources(YAMLFileParameterizer.resolveLocation(srcLocation), destDir, generateEnvVars);
        } else {
            YAMLFileParameterizer.rewriteFiles(new File(srcLocation), new File(destDir), generateEnvVars);
        }
    }

    public static void rewriteFiles(File sourceDir, File destDir, Map<String, Any> generateEnvVars) {
        File[] files;
        if (!sourceDir.exists() || !sourceDir.isDirectory()) {
            logger.error("{} does not exist or is not a folder.", (Object)sourceDir);
            return;
        }
        if (!(destDir.isDirectory() && destDir.exists() || destDir.mkdirs())) {
            logger.error("Failed to create dir {}", (Object)destDir);
            return;
        }
        String dirPath = YAMLFileParameterizer.getAbsolutePath(sourceDir);
        if (null == dirPath) {
            logger.error("dir does not exist.", (Object)sourceDir.getAbsolutePath());
            return;
        }
        Set<String> excludeSet = YAMLFileParameterizer.buildFileExcludeSet(dirPath, generateEnvVars);
        for (File file : files = sourceDir.listFiles((dir, name) -> name.toLowerCase().endsWith(YML_EXT) && !YAMLFileParameterizer.excludeFile(dir, name, excludeSet))) {
            YAMLFileParameterizer.rewriteFile(file, new File(destDir, file.getName()), generateEnvVars);
        }
    }

    public static void rewriteResources(String resourceLocation, String destDir, Map<String, Any> generateEnvVars) {
        File dest;
        if (StringUtils.isBlank(resourceLocation)) {
            return;
        }
        String location = StringUtils.trimToEmpty(resourceLocation);
        if (!location.endsWith(SLASH)) {
            location = location + SLASH;
        }
        List<String> filenames = YAMLFileParameterizer.listClasspathDir(resourceLocation);
        if (logger.isDebugEnabled()) {
            logger.debug("files in {}: {}", (Object)resourceLocation, (Object)String.join((CharSequence)",", filenames));
        }
        Set<String> excludeSet = YAMLFileParameterizer.buildResourceExcludeSet(resourceLocation, generateEnvVars);
        List ymlFileNames = filenames.stream().filter(name -> name.toLowerCase().endsWith(YML_EXT) && !YAMLFileParameterizer.excludeResource(resourceLocation, name, excludeSet)).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            logger.debug("ymlFileNames in {}: {}", (Object)resourceLocation, (Object)String.join((CharSequence)",", ymlFileNames));
        }
        if (!((dest = new File(destDir)).isDirectory() && dest.exists() || dest.mkdirs())) {
            logger.error("Failed to create dir {}", (Object)destDir);
            return;
        }
        for (String filename : ymlFileNames) {
            YAMLFileParameterizer.rewriteResource(YAMLFileParameterizer.stripExtension(filename), resourceLocation + filename, destDir + File.separator + filename, generateEnvVars);
        }
    }

    public static void copyResources(String resourceLocation, String destDir) {
        File dest;
        String location = YAMLFileParameterizer.resolveLocation(resourceLocation);
        List<String> filenames = YAMLFileParameterizer.listClasspathDir(location);
        if (logger.isDebugEnabled()) {
            logger.debug("files in {}: {}", (Object)resourceLocation, (Object)String.join((CharSequence)",", filenames));
        }
        List ymlFileNames = filenames.stream().filter(name -> name.toLowerCase().endsWith(YML_EXT)).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            logger.debug("ymlFileNames in {}: {}", (Object)resourceLocation, (Object)String.join((CharSequence)",", ymlFileNames));
        }
        if (!((dest = new File(destDir)).isDirectory() && dest.exists() || dest.mkdirs())) {
            logger.error("Failed to create dir {}", (Object)destDir);
            return;
        }
        for (String filename : ymlFileNames) {
            YAMLFileParameterizer.copyResource(location + filename, destDir + File.separator + filename);
        }
    }

    public static void rewriteResource(String filename, String resourceLocation, String destFilename, Map<String, Any> generateEnvVars) {
        if (logger.isDebugEnabled()) {
            logger.debug("rewriting resource {}", (Object)resourceLocation);
        }
        if (!YAMLFileParameterizer.getValue(generateEnvVars, KEY_GENERATE)) {
            YAMLFileParameterizer.copyResource(resourceLocation, destFilename);
        } else {
            Node document = YAMLFileParameterizer.loadResource(resourceLocation);
            List<String> lines = YAMLFileParameterizer.readResource(resourceLocation);
            if (null != document && null != lines) {
                YAMLFileParameterizer.parameterize(filename, document, lines, new File(destFilename), generateEnvVars);
            }
        }
    }

    public static void rewriteFile(File srcFile, File destFile, Map<String, Any> generateEnvVars) {
        if (logger.isDebugEnabled()) {
            logger.debug("rewriting file {}", (Object)srcFile.getAbsolutePath());
        }
        if (!YAMLFileParameterizer.getValue(generateEnvVars, KEY_GENERATE)) {
            if (!YAMLFileParameterizer.getValue(generateEnvVars, KEY_IN_PLACE)) {
                YAMLFileParameterizer.copyFile(srcFile, destFile);
            }
        } else {
            try {
                String filename = YAMLFileParameterizer.stripExtension(srcFile.getName());
                String srcFilename = YAMLFileParameterizer.getAbsolutePath(srcFile);
                if (null == srcFilename) {
                    logger.error("file {} does not exist.", (Object)srcFile.getAbsolutePath());
                    return;
                }
                File inputFile = srcFile;
                boolean inPlace = YAMLFileParameterizer.getValue(generateEnvVars, KEY_IN_PLACE);
                if (inPlace) {
                    String bakFilename = srcFilename + BAK_EXT;
                    File bakFile = new File(bakFilename);
                    if (!srcFile.renameTo(bakFile)) {
                        logger.error("Failed to reanme file {} to {}.", (Object)srcFilename, (Object)bakFilename);
                        return;
                    }
                    inputFile = bakFile;
                }
                List<String> lines = YAMLFileParameterizer.readFile(inputFile);
                Node document = YAMLFileParameterizer.loadFile(inputFile);
                if (null != document && null != lines) {
                    YAMLFileParameterizer.parameterize(filename, document, lines, destFile, generateEnvVars);
                }
                if (inPlace) {
                    inputFile.delete();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    protected static boolean fromClasspath(String location) {
        return StringUtils.trimToEmpty(location).toLowerCase().startsWith(CLASS_PATH_PREFIX);
    }

    protected static String resolveLocation(String location) {
        if (StringUtils.isNotBlank(location) && location.contains(CLASS_PATH_PREFIX)) {
            return StringUtils.trimToEmpty(location).substring(CLASS_PATH_PREFIX.length());
        }
        return location;
    }

    protected static boolean getValue(Map<String, Any> generateEnvVars, String key) {
        if (generateEnvVars.containsKey(key)) {
            return generateEnvVars.get(key).toBoolean();
        }
        return false;
    }

    protected static void copyResource(String resourceLocation, String destFilename) {
        try (InputStream in = YAMLFileParameterizer.getResourceAsStream(resourceLocation);
             FileOutputStream out = new FileOutputStream(destFilename);){
            IOUtils.copy(in, (OutputStream)out);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
    }

    protected static void copyFile(File srcFile, File destFile) {
        if (!srcFile.exists()) {
            logger.error("The file {} cannot be found", (Object)srcFile.getAbsolutePath());
            return;
        }
        try {
            FileUtils.copyFile(srcFile, destFile);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
    }

    protected static URL getResourceURL(String resource) {
        return YAMLFileParameterizer.class.getClassLoader().getResource(resource);
    }

    protected static InputStream getResourceAsStream(String resource) {
        return YAMLFileParameterizer.class.getClassLoader().getResourceAsStream(resource);
    }

    protected static List<String> listClasspathDir(String dir) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            URL dirURL = YAMLFileParameterizer.getResourceURL(dir);
            if (null == dirURL) {
                logger.error("cannot locate file {} in classpath.", (Object)dir);
                return result;
            }
            if (dirURL.getProtocol().equals("file")) {
                result.addAll(Arrays.asList(new File(dirURL.toURI()).list()));
                return result;
            }
            if (dirURL.getProtocol().equals("jar")) {
                String path = dirURL.getPath();
                String jarPath = path.substring("file:".length(), path.indexOf("!"));
                JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
                Enumeration<JarEntry> entries = jar.entries();
                int length = dir.length();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    int pathIndex = name.lastIndexOf(dir);
                    if (pathIndex < 0) continue;
                    result.add(name.substring(pathIndex + length));
                }
                jar.close();
                return result;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        throw new UnsupportedOperationException("Cannot list files in " + dir);
    }

    /*
     * Exception decompiling
     */
    protected static Node loadResource(String resourceLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static List<String> readResource(String resourceLocation) {
        ArrayList<String> lines = new ArrayList<String>();
        try (InputStream in = YAMLFileParameterizer.getResourceAsStream(resourceLocation);
             InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            lines.addAll(IOUtils.readLines(reader));
            lines.add("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return lines;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Node loadFile(File file) {
        try (FileReader inputReader = new FileReader(file);){
            Composer composer = new Composer(new ParserImpl(new StreamReader(inputReader)), new Resolver());
            Node node = composer.getSingleNode();
            return node;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    protected static List<String> readFile(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            lines.addAll(FileUtils.readLines(file, (String)null));
            lines.add("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return lines;
    }

    protected static void parameterize(String filename, Node document, List<String> srclines, File destFile, Map<String, Any> generateEnvVars) {
        block15: {
            try (FileWriter writer = new FileWriter(destFile);){
                if (document instanceof MappingNode) {
                    List<String> destlines = YAMLFileParameterizer.parameterize(filename, srclines, (MappingNode)document, generateEnvVars);
                    FileUtils.writeLines(destFile, destlines);
                    break block15;
                }
                throw new UnsupportedNodeTypeException(document.getClass().getCanonicalName());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    protected static List<String> parameterize(String filename, List<String> srclines, MappingNode node, Map<String, Any> generateEnvVars) {
        ArrayList<String> destlines = new ArrayList<String>();
        List<NodeTuple> tuples = node.getValue();
        boolean skipArray = YAMLFileParameterizer.getValue(generateEnvVars, KEY_SKIP_ARRAY);
        boolean skipMap = YAMLFileParameterizer.getValue(generateEnvVars, KEY_SKIP_MAP);
        int pos = 0;
        int tupleNum = tuples.size();
        for (int i = 0; i < tupleNum; ++i) {
            NodeTuple tuple = tuples.get(i);
            NodeTuple nextTuple = null;
            if (i + 1 < tupleNum) {
                nextTuple = tuples.get(i + 1);
            }
            Node k = tuple.getKeyNode();
            Node v = tuple.getValueNode();
            int startLine = k.getStartMark().getLine();
            int stopLine = v.getEndMark().getLine();
            if (null != nextTuple && nextTuple.getKeyNode().getStartMark().getLine() == stopLine) {
                --stopLine;
            }
            if (k instanceof ScalarNode) {
                ScalarNode sk = (ScalarNode)k;
                if (v instanceof ScalarNode) {
                    ScalarNode sv = (ScalarNode)v;
                    YAMLFileParameterizer.copy(srclines, destlines, pos, startLine - 1);
                    destlines.add(String.format("%s: ${%s%s%s:%s}", sk.getValue(), filename, KEY_SEPARATOR, sk.getValue(), sv.getValue()));
                } else if (v instanceof SequenceNode && !skipArray || v instanceof MappingNode && !skipMap) {
                    YAMLFileParameterizer.copy(srclines, destlines, pos, startLine - 1);
                    destlines.add(String.format("%s: ${%s%s%s}", sk.getValue(), filename, KEY_SEPARATOR, sk.getValue()));
                } else {
                    YAMLFileParameterizer.copy(srclines, destlines, pos, stopLine);
                }
            } else {
                throw new UnsupportedNodeTypeException(k.getClass().getCanonicalName());
            }
            pos = stopLine + 1;
        }
        return destlines;
    }

    protected static void copy(List<String> srclines, List<String> destlines, int start, int end) {
        if (end >= srclines.size()) {
            logger.error("attemp to read line {}. total length {}", (Object)end, (Object)srclines.size());
            throw new IndexOutOfBoundsException();
        }
        for (int i = start; i <= end; ++i) {
            destlines.add(srclines.get(i));
        }
    }

    protected static String stripExtension(String str) {
        if (StringUtils.isBlank(str)) {
            return str;
        }
        int pos = str.lastIndexOf(KEY_SEPARATOR);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    protected static Set<String> buildFileExcludeSet(String sourceDir, Map<String, Any> generateEnvVars) {
        if (generateEnvVars.containsKey(KEY_EXCLUDE)) {
            return YAMLFileParameterizer.buildFileExcludeSet(sourceDir, generateEnvVars.get(KEY_EXCLUDE).asList());
        }
        return Collections.emptySet();
    }

    protected static Set<String> buildFileExcludeSet(String sourceDir, Collection<Any> excludes) {
        return excludes.stream().map(Any::toString).filter(StringUtils::isNotBlank).map(s -> sourceDir + YAMLFileParameterizer.normalizeFilename(s)).collect(Collectors.toSet());
    }

    protected static Set<String> buildResourceExcludeSet(String resourceLocation, Map<String, Any> generateEnvVars) {
        if (generateEnvVars.containsKey(KEY_EXCLUDE)) {
            return YAMLFileParameterizer.buildResourceExcludeSet(resourceLocation, generateEnvVars.get(KEY_EXCLUDE).asList());
        }
        return Collections.emptySet();
    }

    protected static Set<String> buildResourceExcludeSet(String resourceLocation, Collection<Any> excludes) {
        return excludes.stream().map(Any::toString).filter(StringUtils::isNotBlank).map(s -> YAMLFileParameterizer.toNonNullString(YAMLFileParameterizer.getResourceURL(resourceLocation + s))).collect(Collectors.toSet());
    }

    protected static String normalizeFilename(String filename) {
        return StringUtils.trimToEmpty(filename).replaceAll("\\\\|/", File.separator);
    }

    public static String toNonNullString(URL url) {
        return null == url ? "" : url.toString();
    }

    public static String getAbsolutePath(File f) {
        try {
            String path = f.getCanonicalFile().getAbsolutePath();
            if (f.isDirectory() && !path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            return path;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    protected static boolean excludeFile(File f, Set<String> excludeSet) {
        if (excludeSet.isEmpty()) {
            return false;
        }
        String filename = YAMLFileParameterizer.getAbsolutePath(f);
        return null == filename ? true : excludeSet.contains(filename);
    }

    protected static boolean excludeFile(File dir, String name, Set<String> excludeSet) {
        return YAMLFileParameterizer.excludeFile(new File(dir, name), excludeSet);
    }

    protected static boolean excludeResource(String resourceLocation, String name, Set<String> excludeSet) {
        if (excludeSet.isEmpty()) {
            return false;
        }
        String url = YAMLFileParameterizer.toNonNullString(YAMLFileParameterizer.getResourceURL(resourceLocation + name));
        return excludeSet.contains(url);
    }

    public static class UnsupportedNodeTypeException
    extends RuntimeException {
        public UnsupportedNodeTypeException(String nodeType) {
            super(StringUtils.isBlank(nodeType) ? "Unsupported node type." : String.format("Nodetype %s is not supported", nodeType));
        }
    }
}

