/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.tracing;

import graphql.PublicApi;
import graphql.execution.ExecutionTypeInfo;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.schema.DataFetchingEnvironment;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

@PublicApi
public class TracingSupport
implements InstrumentationState {
    private final Instant startRequestTime;
    private final long startRequestNanos;
    private final ConcurrentLinkedQueue<Map<String, Object>> fieldData;
    private final Map<String, Object> parseMap = new LinkedHashMap<String, Object>();
    private final Map<String, Object> validationMap = new LinkedHashMap<String, Object>();

    public TracingSupport() {
        this.startRequestNanos = System.nanoTime();
        this.startRequestTime = Instant.now();
        this.fieldData = new ConcurrentLinkedQueue();
    }

    public TracingContext beginField(DataFetchingEnvironment dataFetchingEnvironment) {
        long startFieldFetch = System.nanoTime();
        return () -> {
            long now = System.nanoTime();
            long duration = now - startFieldFetch;
            long startOffset = startFieldFetch - this.startRequestNanos;
            ExecutionTypeInfo typeInfo = dataFetchingEnvironment.getFieldTypeInfo();
            LinkedHashMap<String, Object> fetchMap = new LinkedHashMap<String, Object>();
            fetchMap.put("path", typeInfo.getPath().toList());
            fetchMap.put("parentType", typeInfo.getParentTypeInfo().getType().getName());
            fetchMap.put("returnType", typeInfo.toAst());
            fetchMap.put("fieldName", typeInfo.getFieldDefinition().getName());
            fetchMap.put("startOffset", startOffset);
            fetchMap.put("duration", duration);
            this.fieldData.add(fetchMap);
        };
    }

    public TracingContext beginParse() {
        return this.traceToMap(this.parseMap);
    }

    public TracingContext beginValidation() {
        return this.traceToMap(this.validationMap);
    }

    private TracingContext traceToMap(Map<String, Object> map) {
        long start = System.nanoTime();
        return () -> {
            long now = System.nanoTime();
            long duration = now - start;
            long startOffset = now - this.startRequestNanos;
            map.put("startOffset", startOffset);
            map.put("duration", duration);
        };
    }

    public Map<String, Object> snapshotTracingData() {
        LinkedHashMap<String, Object> traceMap = new LinkedHashMap<String, Object>();
        traceMap.put("version", 1L);
        traceMap.put("startTime", this.rfc3339(this.startRequestTime));
        traceMap.put("endTime", this.rfc3339(Instant.now()));
        traceMap.put("duration", System.nanoTime() - this.startRequestNanos);
        traceMap.put("parsing", this.copyMap(this.parseMap));
        traceMap.put("validation", this.copyMap(this.validationMap));
        traceMap.put("execution", this.executionData());
        return traceMap;
    }

    private Object copyMap(Map<String, Object> map) {
        LinkedHashMap<String, Object> mapCopy = new LinkedHashMap<String, Object>();
        mapCopy.putAll(map);
        return mapCopy;
    }

    private Map<String, Object> executionData() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(this.fieldData);
        map.put("resolvers", list);
        return map;
    }

    private String rfc3339(Instant time) {
        return DateTimeFormatter.ISO_INSTANT.format(time);
    }

    public static interface TracingContext {
        public void onEnd();
    }
}

