/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.EnumValueDefinition;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.TypeDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnumTypeDefinition
extends AbstractNode<EnumTypeDefinition>
implements TypeDefinition<EnumTypeDefinition> {
    private final String name;
    private Description description;
    private final List<EnumValueDefinition> enumValueDefinitions;
    private final List<Directive> directives;

    public EnumTypeDefinition(String name) {
        this(name, null);
    }

    public EnumTypeDefinition(String name, List<Directive> directives) {
        this(name, new ArrayList<EnumValueDefinition>(), directives);
    }

    public EnumTypeDefinition(String name, List<EnumValueDefinition> enumValueDefinitions, List<Directive> directives) {
        this.name = name;
        this.directives = null == directives ? new ArrayList() : directives;
        this.enumValueDefinitions = enumValueDefinitions;
    }

    public List<EnumValueDefinition> getEnumValueDefinitions() {
        return this.enumValueDefinitions;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.enumValueDefinitions);
        result.addAll(this.directives);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumTypeDefinition that = (EnumTypeDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public EnumTypeDefinition deepCopy() {
        return new EnumTypeDefinition(this.name, this.deepCopy(this.enumValueDefinitions), this.deepCopy(this.directives));
    }

    public String toString() {
        return "EnumTypeDefinition{name='" + this.name + '\'' + ", enumValueDefinitions=" + this.enumValueDefinitions + ", directives=" + this.directives + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitEnumTypeDefinition(this, context);
    }
}

