/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@PublicApi
public class GraphQLEnumType
implements GraphQLType,
GraphQLInputType,
GraphQLOutputType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Map<String, GraphQLEnumValueDefinition> valueDefinitionMap = new LinkedHashMap<String, GraphQLEnumValueDefinition>();
    private final EnumTypeDefinition definition;
    private final List<GraphQLDirective> directives;
    private final Coercing coercing = new Coercing(){

        public Object serialize(Object input) {
            return GraphQLEnumType.this.getNameByValue(input);
        }

        public Object parseValue(Object input) {
            return GraphQLEnumType.this.getValueByName(input);
        }

        private String typeName(Object input) {
            if (input == null) {
                return "null";
            }
            return input.getClass().getSimpleName();
        }

        public Object parseLiteral(Object input) {
            if (!(input instanceof EnumValue)) {
                throw new CoercingParseLiteralException("Expected AST type 'EnumValue' but was '" + this.typeName(input) + "'.");
            }
            EnumValue enumValue = (EnumValue)input;
            GraphQLEnumValueDefinition enumValueDefinition = (GraphQLEnumValueDefinition)GraphQLEnumType.this.valueDefinitionMap.get(enumValue.getName());
            if (enumValueDefinition == null) {
                throw new CoercingParseLiteralException("Expected enum literal value not in allowable values -  '" + String.valueOf(input) + "'.");
            }
            return enumValueDefinition.getValue();
        }
    };

    @Internal
    public GraphQLEnumType(String name, String description, List<GraphQLEnumValueDefinition> values2) {
        this(name, description, values2, Collections.emptyList(), null);
    }

    @Internal
    public GraphQLEnumType(String name, String description, List<GraphQLEnumValueDefinition> values2, List<GraphQLDirective> directives, EnumTypeDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(directives, "directives cannot be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.definition = definition;
        this.directives = directives;
        this.buildMap(values2);
    }

    public List<GraphQLEnumValueDefinition> getValues() {
        return new ArrayList<GraphQLEnumValueDefinition>(this.valueDefinitionMap.values());
    }

    public GraphQLEnumValueDefinition getValue(String name) {
        return this.valueDefinitionMap.get(name);
    }

    private void buildMap(List<GraphQLEnumValueDefinition> values2) {
        for (GraphQLEnumValueDefinition valueDefinition : values2) {
            String name = valueDefinition.getName();
            if (this.valueDefinitionMap.containsKey(name)) {
                throw new AssertException("value " + name + " redefined");
            }
            this.valueDefinitionMap.put(name, valueDefinition);
        }
    }

    private Object getValueByName(Object value) {
        GraphQLEnumValueDefinition enumValueDefinition = this.valueDefinitionMap.get(value.toString());
        if (enumValueDefinition != null) {
            return enumValueDefinition.getValue();
        }
        throw new CoercingParseValueException("Invalid input for Enum '" + this.name + "'. No value found for name '" + value.toString() + "'");
    }

    private Object getNameByValue(Object value) {
        for (GraphQLEnumValueDefinition valueDefinition : this.valueDefinitionMap.values()) {
            Object definitionValue = valueDefinition.getValue();
            if (value.equals(definitionValue)) {
                return valueDefinition.getName();
            }
            if (!(definitionValue instanceof Enum) || !(value instanceof String) || !value.equals(((Enum)definitionValue).name())) continue;
            return valueDefinition.getName();
        }
        if (value instanceof Enum) {
            String enumNameValue = ((Enum)value).name();
            for (GraphQLEnumValueDefinition valueDefinition : this.valueDefinitionMap.values()) {
                String definitionValue = String.valueOf(valueDefinition.getValue());
                if (!enumNameValue.equals(definitionValue)) continue;
                return valueDefinition.getName();
            }
        }
        throw new CoercingSerializeException("Invalid input for Enum '" + this.name + "'. Unknown value '" + value + "'");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Coercing getCoercing() {
        return this.coercing;
    }

    public EnumTypeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public static Builder newEnum() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private EnumTypeDefinition definition;
        private final List<GraphQLEnumValueDefinition> values = new ArrayList<GraphQLEnumValueDefinition>();
        private final List<GraphQLDirective> directives = new ArrayList<GraphQLDirective>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder definition(EnumTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder value(String name, Object value, String description, String deprecationReason) {
            this.values.add(new GraphQLEnumValueDefinition(name, description, value, deprecationReason));
            return this;
        }

        public Builder value(String name, Object value, String description) {
            this.values.add(new GraphQLEnumValueDefinition(name, description, value));
            return this;
        }

        public Builder value(String name, Object value) {
            Assert.assertNotNull(value, "value can't be null", new Object[0]);
            this.values.add(new GraphQLEnumValueDefinition(name, null, value));
            return this;
        }

        public Builder value(String name) {
            this.values.add(new GraphQLEnumValueDefinition(name, null, name));
            return this;
        }

        public Builder value(GraphQLEnumValueDefinition enumValueDefinition) {
            this.values.add(enumValueDefinition);
            return this;
        }

        public boolean hasValue(String name) {
            return this.values.stream().anyMatch(evd -> evd.getName().equals(name));
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            Collections.addAll(this.directives, directives);
            return this;
        }

        public GraphQLEnumType build() {
            return new GraphQLEnumType(this.name, this.description, this.values, this.directives, this.definition);
        }
    }
}

