/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diff;

import graphql.introspection.IntrospectionResultToSchema;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeKind;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.Value;
import graphql.schema.diff.DiffCategory;
import graphql.schema.diff.DiffCtx;
import graphql.schema.diff.DiffEvent;
import graphql.schema.diff.DiffLevel;
import graphql.schema.diff.DiffSet;
import graphql.schema.diff.reporting.DifferenceReporter;
import graphql.schema.idl.TypeInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SchemaDiff {
    private final Options options;
    private static final Set<String> SYSTEM_SCALARS = new HashSet<String>();

    public SchemaDiff() {
        this(Options.defaultOptions());
    }

    public SchemaDiff(Options options) {
        this.options = options;
    }

    public int diffSchema(DiffSet diffSet, DifferenceReporter reporter) {
        CountingReporter countingReporter = new CountingReporter(reporter);
        this.diffSchemaImpl(diffSet, countingReporter);
        return countingReporter.breakingCount;
    }

    private void diffSchemaImpl(DiffSet diffSet, DifferenceReporter reporter) {
        Map<String, Object> oldApi = diffSet.getOld();
        Map<String, Object> newApi = diffSet.getNew();
        Document oldDoc = new IntrospectionResultToSchema().createSchemaDefinition(oldApi);
        Document newDoc = new IntrospectionResultToSchema().createSchemaDefinition(newApi);
        DiffCtx ctx = new DiffCtx(reporter, oldDoc, newDoc);
        Optional<SchemaDefinition> oldSchemaDef = this.getSchemaDef(oldDoc);
        Optional<SchemaDefinition> newSchemaDef = this.getSchemaDef(newDoc);
        this.checkOperation(ctx, "query", oldSchemaDef, newSchemaDef);
        this.checkOperation(ctx, "mutation", oldSchemaDef, newSchemaDef);
        this.checkOperation(ctx, "subscription", oldSchemaDef, newSchemaDef);
        reporter.onEnd();
    }

    private void checkOperation(DiffCtx ctx, String opName, Optional<SchemaDefinition> oldSchemaDef, Optional<SchemaDefinition> newSchemaDef) {
        Optional oldOpTypeDef = oldSchemaDef.map(schemaDefinition -> this.getOpDef(opName, (SchemaDefinition)schemaDefinition)).orElseGet(() -> this.synthOperationTypeDefinition(type -> ctx.getOldTypeDef((Type)type, ObjectTypeDefinition.class), opName));
        Optional newOpTypeDef = newSchemaDef.map(schemaDefinition -> this.getOpDef(opName, (SchemaDefinition)schemaDefinition)).orElseGet(() -> this.synthOperationTypeDefinition(type -> ctx.getNewTypeDef((Type)type, ObjectTypeDefinition.class), opName));
        if (!oldOpTypeDef.isPresent()) {
            return;
        }
        ctx.report(DiffEvent.apiInfo().typeName(SchemaDiff.capitalize(opName)).typeKind(TypeKind.Operation).components(opName).reasonMsg("Examining operation '%s' ...", SchemaDiff.capitalize(opName)).build());
        if (oldOpTypeDef.isPresent() && !newOpTypeDef.isPresent()) {
            ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(SchemaDiff.capitalize(opName)).typeKind(TypeKind.Operation).components(opName).reasonMsg("The new API no longer has the operation '%s'", opName).build());
            return;
        }
        OperationTypeDefinition oldOpTypeDefinition = (OperationTypeDefinition)oldOpTypeDef.get();
        OperationTypeDefinition newOpTypeDefinition = (OperationTypeDefinition)newOpTypeDef.get();
        Type oldType = oldOpTypeDefinition.getType();
        Optional<TypeDefinition> oldTD = ctx.getOldTypeDef(oldType, TypeDefinition.class);
        if (!oldTD.isPresent()) {
            return;
        }
        this.checkType(ctx, oldType, newOpTypeDefinition.getType());
    }

    private void checkType(DiffCtx ctx, Type oldType, Type newType) {
        String typeName = SchemaDiff.getTypeName(oldType);
        if (ctx.examiningType(typeName)) {
            return;
        }
        if (this.isSystemScalar(typeName)) {
            return;
        }
        if (this.isReservedType(typeName)) {
            return;
        }
        Optional<TypeDefinition> oldTD = ctx.getOldTypeDef(oldType, TypeDefinition.class);
        Optional<TypeDefinition> newTD = ctx.getNewTypeDef(newType, TypeDefinition.class);
        if (!oldTD.isPresent()) {
            ctx.report(DiffEvent.apiInfo().typeName(typeName).reasonMsg("Type '%s' is missing", typeName).build());
            return;
        }
        TypeDefinition oldDef = oldTD.get();
        ctx.report(DiffEvent.apiInfo().typeName(typeName).typeKind(TypeKind.getTypeKind(oldDef)).reasonMsg("Examining type '%s' ...", typeName).build());
        if (!newTD.isPresent()) {
            ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(typeName).typeKind(TypeKind.getTypeKind(oldDef)).reasonMsg("The new API does not have a type called '%s'", typeName).build());
            ctx.exitType();
            return;
        }
        TypeDefinition newDef = newTD.get();
        if (!oldDef.getClass().equals(newDef.getClass())) {
            ctx.report(DiffEvent.apiBreakage().category(DiffCategory.INVALID).typeName(typeName).typeKind(TypeKind.getTypeKind(oldDef)).components(new Object[]{TypeKind.getTypeKind(oldDef), TypeKind.getTypeKind(newDef)}).reasonMsg("The new API has changed '%s' from a '%s' to a '%s'", new Object[]{typeName, TypeKind.getTypeKind(oldDef), TypeKind.getTypeKind(newDef)}).build());
            ctx.exitType();
            return;
        }
        if (oldDef instanceof ObjectTypeDefinition) {
            this.checkObjectType(ctx, (ObjectTypeDefinition)oldDef, (ObjectTypeDefinition)newDef);
        }
        if (oldDef instanceof InterfaceTypeDefinition) {
            this.checkInterfaceType(ctx, (InterfaceTypeDefinition)oldDef, (InterfaceTypeDefinition)newDef);
        }
        if (oldDef instanceof UnionTypeDefinition) {
            this.checkUnionType(ctx, (UnionTypeDefinition)oldDef, (UnionTypeDefinition)newDef);
        }
        if (oldDef instanceof InputObjectTypeDefinition) {
            this.checkInputObjectType(ctx, (InputObjectTypeDefinition)oldDef, (InputObjectTypeDefinition)newDef);
        }
        if (oldDef instanceof EnumTypeDefinition) {
            this.checkEnumType(ctx, (EnumTypeDefinition)oldDef, (EnumTypeDefinition)newDef);
        }
        if (oldDef instanceof ScalarTypeDefinition) {
            this.checkScalarType(ctx, (ScalarTypeDefinition)oldDef, (ScalarTypeDefinition)newDef);
        }
        ctx.exitType();
    }

    private boolean isReservedType(String typeName) {
        return typeName.startsWith("__");
    }

    private boolean isSystemScalar(String typeName) {
        return SYSTEM_SCALARS.contains(typeName);
    }

    private void checkObjectType(DiffCtx ctx, ObjectTypeDefinition oldDef, ObjectTypeDefinition newDef) {
        Map<String, FieldDefinition> oldFields = this.sortedMap(oldDef.getFieldDefinitions(), FieldDefinition::getName);
        Map<String, FieldDefinition> newFields = this.sortedMap(newDef.getFieldDefinitions(), FieldDefinition::getName);
        this.checkFields(ctx, oldDef, oldFields, newDef, newFields);
        this.checkImplements(ctx, oldDef, oldDef.getImplements(), newDef.getImplements());
        this.checkDirectives(ctx, oldDef, newDef);
    }

    private void checkInterfaceType(DiffCtx ctx, InterfaceTypeDefinition oldDef, InterfaceTypeDefinition newDef) {
        Map<String, FieldDefinition> oldFields = this.sortedMap(oldDef.getFieldDefinitions(), FieldDefinition::getName);
        Map<String, FieldDefinition> newFields = this.sortedMap(newDef.getFieldDefinitions(), FieldDefinition::getName);
        this.checkFields(ctx, oldDef, oldFields, newDef, newFields);
        this.checkDirectives(ctx, oldDef, newDef);
    }

    private void checkUnionType(DiffCtx ctx, UnionTypeDefinition oldDef, UnionTypeDefinition newDef) {
        Map<String, Type> oldMemberTypes = this.sortedMap(oldDef.getMemberTypes(), SchemaDiff::getTypeName);
        Map<String, Type> newMemberTypes = this.sortedMap(newDef.getMemberTypes(), SchemaDiff::getTypeName);
        for (Map.Entry<String, Type> entry : oldMemberTypes.entrySet()) {
            String oldMemberTypeName = entry.getKey();
            if (newMemberTypes.containsKey(oldMemberTypeName)) continue;
            ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).components(oldMemberTypeName).reasonMsg("The new API does not contain union member type '%s'", oldMemberTypeName).build());
        }
        for (Map.Entry<String, Type> entry : newMemberTypes.entrySet()) {
            String newMemberTypeName = entry.getKey();
            if (oldMemberTypes.containsKey(newMemberTypeName)) continue;
            ctx.report(DiffEvent.apiDanger().category(DiffCategory.ADDITION).typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).components(newMemberTypeName).reasonMsg("The new API has added a new union member type '%s'", newMemberTypeName).build());
        }
        this.checkDirectives(ctx, oldDef, newDef);
    }

    private void checkInputObjectType(DiffCtx ctx, InputObjectTypeDefinition oldDef, InputObjectTypeDefinition newDef) {
        this.checkInputFields(ctx, oldDef, oldDef.getInputValueDefinitions(), newDef.getInputValueDefinitions());
        this.checkDirectives(ctx, oldDef, newDef);
    }

    private void checkInputFields(DiffCtx ctx, TypeDefinition old, List<InputValueDefinition> oldIVD, List<InputValueDefinition> newIVD) {
        Map<String, InputValueDefinition> oldDefinitionMap = this.sortedMap(oldIVD, InputValueDefinition::getName);
        Map<String, InputValueDefinition> newDefinitionMap = this.sortedMap(newIVD, InputValueDefinition::getName);
        for (String inputFieldName : oldDefinitionMap.keySet()) {
            InputValueDefinition oldField = oldDefinitionMap.get(inputFieldName);
            Optional<InputValueDefinition> newField = Optional.ofNullable(newDefinitionMap.get(inputFieldName));
            ctx.report(DiffEvent.apiInfo().typeName(old.getName()).typeKind(TypeKind.getTypeKind(old)).fieldName(oldField.getName()).reasonMsg("\tExamining input field '%s' ...", this.mkDotName(old.getName(), oldField.getName())).build());
            if (!newField.isPresent()) {
                ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(old.getName()).typeKind(TypeKind.getTypeKind(old)).fieldName(oldField.getName()).reasonMsg("The new API is missing an input field '%s'", this.mkDotName(old.getName(), oldField.getName())).build());
                continue;
            }
            DiffCategory category = this.checkTypeWithNonNullAndList(oldField.getType(), newField.get().getType());
            if (category == null) continue;
            ctx.report(DiffEvent.apiBreakage().category(category).typeName(old.getName()).typeKind(TypeKind.getTypeKind(old)).fieldName(oldField.getName()).components(TypeInfo.getAstDesc(oldField.getType()), TypeInfo.getAstDesc(newField.get().getType())).reasonMsg("The new API has changed input field '%s' from type '%s' to '%s'", oldField.getName(), TypeInfo.getAstDesc(oldField.getType()), TypeInfo.getAstDesc(newField.get().getType())).build());
        }
        for (String inputFieldName : newDefinitionMap.keySet()) {
            InputValueDefinition newField = newDefinitionMap.get(inputFieldName);
            Optional<InputValueDefinition> oldField = Optional.ofNullable(oldDefinitionMap.get(inputFieldName));
            if (oldField.isPresent() || !TypeInfo.typeInfo(newField.getType()).isNonNull()) continue;
            ctx.report(DiffEvent.apiBreakage().category(DiffCategory.STRICTER).typeName(old.getName()).typeKind(TypeKind.getTypeKind(old)).fieldName(newField.getName()).reasonMsg("The new API has made the new input field '%s' non null and hence more strict for old consumers", newField.getName()).build());
        }
    }

    private void checkEnumType(DiffCtx ctx, EnumTypeDefinition oldDef, EnumTypeDefinition newDef) {
        EnumValueDefinition oldEnum;
        Map<String, EnumValueDefinition> oldDefinitionMap = this.sortedMap(oldDef.getEnumValueDefinitions(), EnumValueDefinition::getName);
        Map<String, EnumValueDefinition> newDefinitionMap = this.sortedMap(newDef.getEnumValueDefinitions(), EnumValueDefinition::getName);
        for (String enumName : oldDefinitionMap.keySet()) {
            oldEnum = oldDefinitionMap.get(enumName);
            Optional<EnumValueDefinition> newEnum = Optional.ofNullable(newDefinitionMap.get(enumName));
            if (!newEnum.isPresent()) {
                ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).components(oldEnum.getName()).reasonMsg("The new API is missing an enum value '%s'", oldEnum.getName()).build());
                continue;
            }
            this.checkDirectives(ctx, oldDef, oldEnum.getDirectives(), newEnum.get().getDirectives());
        }
        for (String enumName : newDefinitionMap.keySet()) {
            oldEnum = oldDefinitionMap.get(enumName);
            if (oldEnum != null) continue;
            ctx.report(DiffEvent.apiDanger().category(DiffCategory.ADDITION).typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).components(enumName).reasonMsg("The new API has added a new enum value '%s'", enumName).build());
        }
        this.checkDirectives(ctx, oldDef, newDef);
    }

    private void checkScalarType(DiffCtx ctx, ScalarTypeDefinition oldDef, ScalarTypeDefinition newDef) {
        this.checkDirectives(ctx, oldDef, newDef);
    }

    private void checkImplements(DiffCtx ctx, ObjectTypeDefinition old, List<Type> oldImplements, List<Type> newImplements) {
        Map<String, Type> oldImplementsMap = this.sortedMap(oldImplements, t -> ((TypeName)t).getName());
        Map<String, Type> newImplementsMap = this.sortedMap(newImplements, t -> ((TypeName)t).getName());
        for (Map.Entry<String, Type> entry : oldImplementsMap.entrySet()) {
            InterfaceTypeDefinition oldInterface = ctx.getOldTypeDef(entry.getValue(), InterfaceTypeDefinition.class).get();
            Optional<InterfaceTypeDefinition> newInterface = ctx.getNewTypeDef(newImplementsMap.get(entry.getKey()), InterfaceTypeDefinition.class);
            if (!newInterface.isPresent()) {
                ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(old.getName()).typeKind(TypeKind.getTypeKind(old)).components(oldInterface.getName()).reasonMsg("The new API is missing the interface named '%s'", oldInterface.getName()).build());
                continue;
            }
            this.checkInterfaceType(ctx, oldInterface, newInterface.get());
        }
    }

    private void checkFields(DiffCtx ctx, TypeDefinition oldDef, Map<String, FieldDefinition> oldFields, TypeDefinition newDef, Map<String, FieldDefinition> newFields) {
        this.checkFieldRemovals(ctx, oldDef, oldFields, newFields);
        this.checkFieldAdditions(ctx, newDef, oldFields, newFields);
    }

    private void checkFieldRemovals(DiffCtx ctx, TypeDefinition oldDef, Map<String, FieldDefinition> oldFields, Map<String, FieldDefinition> newFields) {
        for (Map.Entry<String, FieldDefinition> entry : oldFields.entrySet()) {
            String fieldName = entry.getKey();
            ctx.report(DiffEvent.apiInfo().typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).fieldName(fieldName).reasonMsg("\tExamining field '%s' ...", this.mkDotName(oldDef.getName(), fieldName)).build());
            FieldDefinition newField = newFields.get(fieldName);
            if (newField == null) {
                ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).fieldName(fieldName).reasonMsg("The new API is missing the field '%s'", this.mkDotName(oldDef.getName(), fieldName)).build());
                continue;
            }
            this.checkField(ctx, oldDef, entry.getValue(), newField);
        }
    }

    private void checkFieldAdditions(DiffCtx ctx, TypeDefinition newDef, Map<String, FieldDefinition> oldFields, Map<String, FieldDefinition> newFields) {
        for (Map.Entry<String, FieldDefinition> entry : newFields.entrySet()) {
            String fieldName = entry.getKey();
            ctx.report(DiffEvent.apiInfo().typeName(newDef.getName()).typeKind(TypeKind.getTypeKind(newDef)).fieldName(fieldName).reasonMsg("\tExamining field '%s' ...", this.mkDotName(newDef.getName(), fieldName)).build());
            FieldDefinition oldField = oldFields.get(fieldName);
            if (oldField != null) continue;
            ctx.report(DiffEvent.apiInfo().category(DiffCategory.ADDITION).typeName(newDef.getName()).typeKind(TypeKind.getTypeKind(newDef)).fieldName(fieldName).reasonMsg("The new API adds the field '%s'", this.mkDotName(newDef.getName(), fieldName)).build());
        }
    }

    private void checkField(DiffCtx ctx, TypeDefinition old, FieldDefinition oldField, FieldDefinition newField) {
        Type newFieldType;
        Type oldFieldType = oldField.getType();
        DiffCategory category = this.checkTypeWithNonNullAndList(oldFieldType, newFieldType = newField.getType());
        if (category != null) {
            ctx.report(DiffEvent.apiBreakage().category(category).typeName(old.getName()).typeKind(TypeKind.getTypeKind(old)).fieldName(oldField.getName()).components(TypeInfo.getAstDesc(oldFieldType), TypeInfo.getAstDesc(newFieldType)).reasonMsg("The new API has changed field '%s' from type '%s' to '%s'", this.mkDotName(old.getName(), oldField.getName()), TypeInfo.getAstDesc(oldFieldType), TypeInfo.getAstDesc(newFieldType)).build());
        }
        this.checkFieldArguments(ctx, old, oldField, oldField.getInputValueDefinitions(), newField.getInputValueDefinitions());
        this.checkDirectives(ctx, old, oldField.getDirectives(), newField.getDirectives());
        this.checkType(ctx, oldFieldType, newFieldType);
    }

    private void checkFieldArguments(DiffCtx ctx, TypeDefinition oldDef, FieldDefinition oldField, List<InputValueDefinition> oldInputValueDefinitions, List<InputValueDefinition> newInputValueDefinitions) {
        Map<String, InputValueDefinition> oldArgsMap = this.sortedMap(oldInputValueDefinitions, InputValueDefinition::getName);
        Map<String, InputValueDefinition> newArgMap = this.sortedMap(newInputValueDefinitions, InputValueDefinition::getName);
        if (oldArgsMap.size() > newArgMap.size()) {
            ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).fieldName(oldField.getName()).reasonMsg("The new API has less arguments on field '%s' of type '%s' than the old API", this.mkDotName(oldDef.getName(), oldField.getName()), oldDef.getName()).build());
            return;
        }
        for (Map.Entry<String, InputValueDefinition> entry : oldArgsMap.entrySet()) {
            String argName = entry.getKey();
            ctx.report(DiffEvent.apiInfo().typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).fieldName(oldField.getName()).reasonMsg("\tExamining field argument '%s' ...", this.mkDotName(oldDef.getName(), oldField.getName(), argName)).build());
            InputValueDefinition newArg = newArgMap.get(argName);
            if (newArg == null) {
                ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).fieldName(oldField.getName()).components(argName).reasonMsg("The new API is missing the field argument '%s'", this.mkDotName(oldDef.getName(), oldField.getName(), argName)).build());
                continue;
            }
            this.checkFieldArg(ctx, oldDef, oldField, entry.getValue(), newArg);
        }
        for (Map.Entry<String, InputValueDefinition> entry : newArgMap.entrySet()) {
            InputValueDefinition newArg = entry.getValue();
            Optional<InputValueDefinition> oldArg = Optional.ofNullable(oldArgsMap.get(newArg.getName()));
            if (oldArg.isPresent() || !TypeInfo.typeInfo(newArg.getType()).isNonNull()) continue;
            ctx.report(DiffEvent.apiBreakage().category(DiffCategory.STRICTER).typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).fieldName(oldField.getName()).components(newArg.getName()).reasonMsg("The new API has made the new argument '%s' on field '%s' non null and hence more strict for old consumers", newArg.getName(), this.mkDotName(oldDef.getName(), oldField.getName())).build());
        }
    }

    private void checkFieldArg(DiffCtx ctx, TypeDefinition oldDef, FieldDefinition oldField, InputValueDefinition oldArg, InputValueDefinition newArg) {
        Type newArgType;
        Type oldArgType = oldArg.getType();
        DiffCategory category = this.checkTypeWithNonNullAndList(oldArgType, newArgType = newArg.getType());
        if (category != null) {
            ctx.report(DiffEvent.apiBreakage().category(category).typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).fieldName(oldField.getName()).components(TypeInfo.getAstDesc(oldArgType), TypeInfo.getAstDesc(newArgType)).reasonMsg("The new API has changed field '%s' argument '%s' from type '%s' to '%s'", this.mkDotName(oldDef.getName(), oldField.getName()), oldArg.getName(), TypeInfo.getAstDesc(oldArgType), TypeInfo.getAstDesc(newArgType)).build());
        } else {
            this.checkType(ctx, oldArgType, newArgType);
        }
        boolean changedDefaultValue = false;
        Value oldValue = oldArg.getDefaultValue();
        Value newValue = newArg.getDefaultValue();
        if (oldValue != null && newValue != null) {
            if (!oldValue.getClass().equals(newValue.getClass())) {
                ctx.report(DiffEvent.apiBreakage().category(DiffCategory.INVALID).typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).fieldName(oldField.getName()).components(oldArg.getName()).reasonMsg("The new API has changed default value types on argument named '%s' on field '%s' of type '%s", oldArg.getName(), this.mkDotName(oldDef.getName(), oldField.getName()), oldDef.getName()).build());
            }
            if (!oldValue.isEqualTo(newValue)) {
                changedDefaultValue = true;
            }
        }
        if (oldValue == null && newValue != null) {
            changedDefaultValue = true;
        }
        if (oldValue != null && newValue == null) {
            changedDefaultValue = true;
        }
        if (changedDefaultValue) {
            ctx.report(DiffEvent.apiDanger().category(DiffCategory.DIFFERENT).typeName(oldDef.getName()).typeKind(TypeKind.getTypeKind(oldDef)).fieldName(oldField.getName()).components(oldArg.getName()).reasonMsg("The new API has changed default value on argument named '%s' on field '%s' of type '%s", oldArg.getName(), this.mkDotName(oldDef.getName(), oldField.getName()), oldDef.getName()).build());
        }
        this.checkDirectives(ctx, oldDef, oldArg.getDirectives(), newArg.getDirectives());
    }

    private void checkDirectives(DiffCtx ctx, TypeDefinition oldDef, TypeDefinition newDef) {
        List<Directive> oldDirectives = oldDef.getDirectives();
        List<Directive> newDirectives = newDef.getDirectives();
        this.checkDirectives(ctx, oldDef, oldDirectives, newDirectives);
    }

    void checkDirectives(DiffCtx ctx, TypeDefinition old, List<Directive> oldDirectives, List<Directive> newDirectives) {
        if (!this.options.enforceDirectives) {
            return;
        }
        Map<String, Directive> oldDirectivesMap = this.sortedMap(oldDirectives, Directive::getName);
        Map<String, Directive> newDirectivesMap = this.sortedMap(newDirectives, Directive::getName);
        for (String directiveName : oldDirectivesMap.keySet()) {
            Directive oldDirective = oldDirectivesMap.get(directiveName);
            Optional<Directive> newDirective = Optional.ofNullable(newDirectivesMap.get(directiveName));
            if (!newDirective.isPresent()) {
                ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(old.getName()).typeKind(TypeKind.getTypeKind(old)).components(directiveName).reasonMsg("The new API does not have a directive named '%s' on type '%s'", directiveName, old.getName()).build());
                continue;
            }
            TreeMap<String, Argument> oldArgumentsByName = new TreeMap<String, Argument>(oldDirective.getArgumentsByName());
            TreeMap<String, Argument> newArgumentsByName = new TreeMap<String, Argument>(newDirective.get().getArgumentsByName());
            if (oldArgumentsByName.size() > newArgumentsByName.size()) {
                ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(old.getName()).typeKind(TypeKind.getTypeKind(old)).components(directiveName).reasonMsg("The new API has less arguments on directive '%s' on type '%s' than the old API", directiveName, old.getName()).build());
                return;
            }
            for (String argName : oldArgumentsByName.keySet()) {
                Argument oldArgument = (Argument)oldArgumentsByName.get(argName);
                Optional newArgument = Optional.ofNullable(newArgumentsByName.get(argName));
                if (!newArgument.isPresent()) {
                    ctx.report(DiffEvent.apiBreakage().category(DiffCategory.MISSING).typeName(old.getName()).typeKind(TypeKind.getTypeKind(old)).components(directiveName, argName).reasonMsg("The new API does not have an argument named '%s' on directive '%s' on type '%s'", argName, directiveName, old.getName()).build());
                    continue;
                }
                Value oldValue = oldArgument.getValue();
                Value newValue = ((Argument)newArgument.get()).getValue();
                if (oldValue == null || newValue == null || oldValue.getClass().equals(newValue.getClass())) continue;
                ctx.report(DiffEvent.apiBreakage().category(DiffCategory.INVALID).typeName(old.getName()).typeKind(TypeKind.getTypeKind(old)).components(directiveName, argName).reasonMsg("The new API has changed value types on argument named '%s' on directive '%s' on type '%s'", argName, directiveName, old.getName()).build());
            }
        }
    }

    DiffCategory checkTypeWithNonNullAndList(Type oldType, Type newType) {
        TypeInfo oldTypeInfo = TypeInfo.typeInfo(oldType);
        TypeInfo newTypeInfo = TypeInfo.typeInfo(newType);
        if (!oldTypeInfo.getName().equals(newTypeInfo.getName())) {
            return DiffCategory.INVALID;
        }
        while (true) {
            if (oldTypeInfo.isNonNull() && newTypeInfo.isNonNull()) {
                oldTypeInfo = oldTypeInfo.unwrapOne();
                newTypeInfo = newTypeInfo.unwrapOne();
            } else if (oldTypeInfo.isNonNull() && !newTypeInfo.isNonNull()) {
                oldTypeInfo = oldTypeInfo.unwrapOne();
            } else if (!oldTypeInfo.isNonNull() && newTypeInfo.isNonNull()) {
                return DiffCategory.STRICTER;
            }
            if (oldTypeInfo.isList() && !newTypeInfo.isList()) {
                return DiffCategory.INVALID;
            }
            if (oldTypeInfo.isPlain()) {
                if (newTypeInfo.isPlain()) break;
                return DiffCategory.INVALID;
            }
            oldTypeInfo = oldTypeInfo.unwrapOne();
            newTypeInfo = newTypeInfo.unwrapOne();
        }
        return null;
    }

    static String getTypeName(Type type) {
        if (type == null) {
            return null;
        }
        return TypeInfo.typeInfo(type).getName();
    }

    private Optional<SchemaDefinition> getSchemaDef(Document document) {
        return document.getDefinitions().stream().filter(d -> d instanceof SchemaDefinition).map(SchemaDefinition.class::cast).findFirst();
    }

    private Optional<OperationTypeDefinition> getOpDef(String opName, SchemaDefinition schemaDef) {
        return schemaDef.getOperationTypeDefinitions().stream().filter(otd -> otd.getName().equals(opName)).findFirst();
    }

    private Optional<OperationTypeDefinition> synthOperationTypeDefinition(Function<Type, Optional<ObjectTypeDefinition>> typeReteriver, String opName) {
        TypeName type = new TypeName(SchemaDiff.capitalize(opName));
        Optional<ObjectTypeDefinition> typeDef = typeReteriver.apply(type);
        return typeDef.map(objectTypeDefinition -> new OperationTypeDefinition(opName, type));
    }

    private <T> Map<String, T> sortedMap(List<T> listOfNamedThings, Function<T, String> nameFunc) {
        Map map = listOfNamedThings.stream().collect(Collectors.toMap(nameFunc, Function.identity(), (x, y) -> y));
        return new TreeMap(map);
    }

    private static String capitalize(String name) {
        if (name != null && name.length() != 0) {
            char[] chars = name.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars);
        }
        return name;
    }

    private String mkDotName(String ... objectNames) {
        return Arrays.stream(objectNames).collect(Collectors.joining("."));
    }

    static {
        SYSTEM_SCALARS.add("ID");
        SYSTEM_SCALARS.add("Boolean");
        SYSTEM_SCALARS.add("String");
        SYSTEM_SCALARS.add("Byte");
        SYSTEM_SCALARS.add("Char");
        SYSTEM_SCALARS.add("Short");
        SYSTEM_SCALARS.add("Int");
        SYSTEM_SCALARS.add("Long");
        SYSTEM_SCALARS.add("Float");
        SYSTEM_SCALARS.add("Double");
        SYSTEM_SCALARS.add("BigInteger");
        SYSTEM_SCALARS.add("BigDecimal");
    }

    private class CountingReporter
    implements DifferenceReporter {
        final DifferenceReporter delegate;
        int breakingCount = 1;

        private CountingReporter(DifferenceReporter delegate) {
            this.delegate = delegate;
        }

        @Override
        public void report(DiffEvent differenceEvent) {
            if (differenceEvent.getLevel().equals((Object)DiffLevel.BREAKING)) {
                ++this.breakingCount;
            }
            this.delegate.report(differenceEvent);
        }

        @Override
        public void onEnd() {
            this.delegate.onEnd();
        }
    }

    public static class Options {
        final boolean enforceDirectives;

        Options(boolean enforceDirectives) {
            this.enforceDirectives = enforceDirectives;
        }

        public Options enforceDirectives() {
            return new Options(true);
        }

        public static Options defaultOptions() {
            return new Options(false);
        }
    }
}

