/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.introspection.Introspection;
import graphql.language.Directive;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValueDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.TypeResolver;
import graphql.schema.TypeResolverProxy;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.FieldWiringEnvironment;
import graphql.schema.idl.InterfaceWiringEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.ScalarWiringEnvironment;
import graphql.schema.idl.SchemaGeneratorHelper;
import graphql.schema.idl.SchemaTypeChecker;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeInfo;
import graphql.schema.idl.UnionWiringEnvironment;
import graphql.schema.idl.WiringFactory;
import graphql.schema.idl.errors.NotAnInputTypeError;
import graphql.schema.idl.errors.NotAnOutputTypeError;
import graphql.schema.idl.errors.SchemaProblem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PublicApi
public class SchemaGenerator {
    private final SchemaTypeChecker typeChecker = new SchemaTypeChecker();
    private final SchemaGeneratorHelper schemaGeneratorHelper = new SchemaGeneratorHelper();

    public GraphQLSchema makeExecutableSchema(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) throws SchemaProblem {
        List<GraphQLError> errors = this.typeChecker.checkTypeRegistry(typeRegistry, wiring);
        if (!errors.isEmpty()) {
            throw new SchemaProblem(errors);
        }
        BuildContext buildCtx = new BuildContext(typeRegistry, wiring);
        return this.makeExecutableSchemaImpl(buildCtx);
    }

    private GraphQLSchema makeExecutableSchemaImpl(BuildContext buildCtx) {
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        if (!typeRegistry.schemaDefinition().isPresent()) {
            Optional<TypeDefinition> subscriptionTypeDef;
            TypeDefinition queryTypeDef = typeRegistry.getType("Query").get();
            GraphQLObjectType query = (GraphQLObjectType)this.buildOutputType(buildCtx, new TypeName(queryTypeDef.getName()));
            schemaBuilder.query(query);
            Optional<TypeDefinition> mutationTypeDef = typeRegistry.getType("Mutation");
            if (mutationTypeDef.isPresent()) {
                GraphQLObjectType mutation = (GraphQLObjectType)this.buildOutputType(buildCtx, new TypeName(mutationTypeDef.get().getName()));
                schemaBuilder.mutation(mutation);
            }
            if ((subscriptionTypeDef = typeRegistry.getType("Subscription")).isPresent()) {
                GraphQLObjectType subscription = (GraphQLObjectType)this.buildOutputType(buildCtx, new TypeName(subscriptionTypeDef.get().getName()));
                schemaBuilder.subscription(subscription);
            }
        } else {
            SchemaDefinition schemaDefinition = typeRegistry.schemaDefinition().get();
            List<OperationTypeDefinition> operationTypes = schemaDefinition.getOperationTypeDefinitions();
            OperationTypeDefinition queryOp = operationTypes.stream().filter(op -> "query".equals(op.getName())).findFirst().get();
            Optional<OperationTypeDefinition> mutationOp = operationTypes.stream().filter(op -> "mutation".equals(op.getName())).findFirst();
            Optional<OperationTypeDefinition> subscriptionOp = operationTypes.stream().filter(op -> "subscription".equals(op.getName())).findFirst();
            GraphQLObjectType query = this.buildOperation(buildCtx, queryOp);
            schemaBuilder.query(query);
            if (mutationOp.isPresent()) {
                GraphQLObjectType mutation = this.buildOperation(buildCtx, mutationOp.get());
                schemaBuilder.mutation(mutation);
            }
            if (subscriptionOp.isPresent()) {
                GraphQLObjectType subscription = this.buildOperation(buildCtx, subscriptionOp.get());
                schemaBuilder.subscription(subscription);
            }
        }
        Set<GraphQLType> additionalTypes = this.buildAdditionalTypes(buildCtx);
        schemaBuilder.fieldVisibility(buildCtx.getWiring().getFieldVisibility());
        return schemaBuilder.build(additionalTypes);
    }

    private GraphQLObjectType buildOperation(BuildContext buildCtx, OperationTypeDefinition operation) {
        Type type = operation.getType();
        return (GraphQLObjectType)this.buildOutputType(buildCtx, type);
    }

    private Set<GraphQLType> buildAdditionalTypes(BuildContext buildCtx) {
        HashSet<GraphQLType> additionalTypes = new HashSet<GraphQLType>();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        typeRegistry.types().values().forEach(typeDefinition -> {
            TypeName typeName = new TypeName(typeDefinition.getName());
            if (typeDefinition instanceof InputObjectTypeDefinition) {
                if (buildCtx.hasInputType((TypeDefinition)typeDefinition) == null) {
                    additionalTypes.add(this.buildInputType(buildCtx, typeName));
                }
            } else if (buildCtx.hasOutputType((TypeDefinition)typeDefinition) == null) {
                additionalTypes.add((GraphQLType)this.buildOutputType(buildCtx, typeName));
            }
        });
        return additionalTypes;
    }

    private <T extends GraphQLOutputType> T buildOutputType(BuildContext buildCtx, Type rawType) {
        TypeDefinition typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLOutputType outputType = buildCtx.hasOutputType(typeDefinition);
        if (outputType != null) {
            return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (T)((GraphQLOutputType)typeInfo.decorate(GraphQLTypeReference.typeRef(typeInfo.getName())));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof ObjectTypeDefinition) {
            outputType = this.buildObjectType(buildCtx, (ObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof InterfaceTypeDefinition) {
            outputType = this.buildInterfaceType(buildCtx, (InterfaceTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof UnionTypeDefinition) {
            outputType = this.buildUnionType(buildCtx, (UnionTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            outputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            outputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnOutputTypeError(typeDefinition);
        }
        buildCtx.put(outputType);
        buildCtx.pop();
        return (T)((GraphQLOutputType)typeInfo.decorate(outputType));
    }

    private GraphQLInputType buildInputType(BuildContext buildCtx, Type rawType) {
        TypeDefinition typeDefinition = buildCtx.getTypeDefinition(rawType);
        TypeInfo typeInfo = TypeInfo.typeInfo(rawType);
        GraphQLInputType inputType = buildCtx.hasInputType(typeDefinition);
        if (inputType != null) {
            return (GraphQLInputType)typeInfo.decorate(inputType);
        }
        if (buildCtx.stackContains(typeInfo)) {
            return (GraphQLInputType)typeInfo.decorate(GraphQLTypeReference.typeRef(typeInfo.getName()));
        }
        buildCtx.push(typeInfo);
        if (typeDefinition instanceof InputObjectTypeDefinition) {
            inputType = this.buildInputObjectType(buildCtx, (InputObjectTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof EnumTypeDefinition) {
            inputType = this.buildEnumType(buildCtx, (EnumTypeDefinition)typeDefinition);
        } else if (typeDefinition instanceof ScalarTypeDefinition) {
            inputType = this.buildScalar(buildCtx, (ScalarTypeDefinition)typeDefinition);
        } else {
            throw new NotAnInputTypeError(typeDefinition);
        }
        buildCtx.put(inputType);
        buildCtx.pop();
        return (GraphQLInputType)typeInfo.decorate(inputType);
    }

    private GraphQLObjectType buildObjectType(BuildContext buildCtx, ObjectTypeDefinition typeDefinition) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(typeDefinition, typeDefinition.getDescription()));
        List<ObjectTypeExtensionDefinition> extensions = this.objectTypeExtensions(typeDefinition, buildCtx);
        builder.withDirectives(this.buildDirectives(typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.OBJECT));
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition newFieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            builder.field(newFieldDefinition);
        });
        extensions.forEach(extension -> extension.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition newFieldDefinition = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            if (!builder.hasField(newFieldDefinition.getName())) {
                builder.field(newFieldDefinition);
            }
        }));
        this.buildObjectTypeInterfaces(buildCtx, typeDefinition, builder, extensions);
        return builder.build();
    }

    private void buildObjectTypeInterfaces(BuildContext buildCtx, ObjectTypeDefinition typeDefinition, GraphQLObjectType.Builder builder, List<ObjectTypeExtensionDefinition> extensions) {
        LinkedHashMap interfaces = new LinkedHashMap();
        typeDefinition.getImplements().forEach(type -> {
            GraphQLInterfaceType newInterfaceType = (GraphQLInterfaceType)this.buildOutputType(buildCtx, (Type)type);
            interfaces.put(newInterfaceType.getName(), newInterfaceType);
        });
        extensions.forEach(extension -> extension.getImplements().forEach(type -> {
            GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)this.buildOutputType(buildCtx, (Type)type);
            if (!interfaces.containsKey(interfaceType.getName())) {
                interfaces.put(interfaceType.getName(), interfaceType);
            }
        }));
        interfaces.values().forEach(builder::withInterface);
    }

    private GraphQLInterfaceType buildInterfaceType(BuildContext buildCtx, InterfaceTypeDefinition typeDefinition) {
        GraphQLInterfaceType.Builder builder = GraphQLInterfaceType.newInterface();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.typeResolver(this.getTypeResolverForInterface(buildCtx, typeDefinition));
        List<InterfaceTypeExtensionDefinition> extensions = this.interfaceTypeExtensions(typeDefinition, buildCtx);
        builder.withDirectives(this.buildDirectives(typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.OBJECT));
        typeDefinition.getFieldDefinitions().forEach(fieldDef -> builder.field(this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef)));
        extensions.forEach(extension -> extension.getFieldDefinitions().forEach(fieldDef -> {
            GraphQLFieldDefinition field = this.buildField(buildCtx, typeDefinition, (FieldDefinition)fieldDef);
            if (!builder.hasField(field.getName())) {
                builder.field(field);
            }
        }));
        return builder.build();
    }

    private GraphQLUnionType buildUnionType(BuildContext buildCtx, UnionTypeDefinition typeDefinition) {
        GraphQLUnionType.Builder builder = GraphQLUnionType.newUnionType();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(typeDefinition, typeDefinition.getDescription()));
        builder.typeResolver(this.getTypeResolverForUnion(buildCtx, typeDefinition));
        List<UnionTypeExtensionDefinition> extensions = this.unionTypeExtensions(typeDefinition, buildCtx);
        typeDefinition.getMemberTypes().forEach(mt -> {
            Object outputType = this.buildOutputType(buildCtx, (Type)mt);
            if (outputType instanceof GraphQLTypeReference) {
                builder.possibleType((GraphQLTypeReference)outputType);
            } else {
                builder.possibleType((GraphQLObjectType)outputType);
            }
        });
        builder.withDirectives(this.buildDirectives(typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.UNION));
        extensions.forEach(extension -> extension.getMemberTypes().forEach(mt -> {
            Object outputType = this.buildOutputType(buildCtx, (Type)mt);
            if (!builder.containType(outputType.getName())) {
                if (outputType instanceof GraphQLTypeReference) {
                    builder.possibleType((GraphQLTypeReference)outputType);
                } else {
                    builder.possibleType((GraphQLObjectType)outputType);
                }
            }
        }));
        return builder.build();
    }

    private GraphQLEnumType buildEnumType(BuildContext buildCtx, EnumTypeDefinition typeDefinition) {
        GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(typeDefinition, typeDefinition.getDescription()));
        List<EnumTypeExtensionDefinition> extensions = this.enumTypeExtensions(typeDefinition, buildCtx);
        EnumValuesProvider enumValuesProvider = buildCtx.getWiring().getEnumValuesProviders().get(typeDefinition.getName());
        typeDefinition.getEnumValueDefinitions().forEach(evd -> {
            GraphQLEnumValueDefinition enumValueDefinition = this.buildEnumValue(buildCtx, typeDefinition, enumValuesProvider, (EnumValueDefinition)evd);
            builder.value(enumValueDefinition);
        });
        extensions.forEach(extension -> extension.getEnumValueDefinitions().forEach(evd -> {
            GraphQLEnumValueDefinition enumValueDefinition = this.buildEnumValue(buildCtx, typeDefinition, enumValuesProvider, (EnumValueDefinition)evd);
            if (!builder.hasValue(enumValueDefinition.getName())) {
                builder.value(enumValueDefinition);
            }
        }));
        builder.withDirectives(this.buildDirectives(typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.ENUM));
        return builder.build();
    }

    private GraphQLEnumValueDefinition buildEnumValue(BuildContext buildCtx, EnumTypeDefinition typeDefinition, EnumValuesProvider enumValuesProvider, EnumValueDefinition evd) {
        Object value;
        String description = this.schemaGeneratorHelper.buildDescription(evd, evd.getDescription());
        String deprecation = this.schemaGeneratorHelper.buildDeprecationReason(evd.getDirectives());
        if (enumValuesProvider != null) {
            value = enumValuesProvider.getValue(evd.getName());
            Assert.assertNotNull(value, "EnumValuesProvider for %s returned null for %s", typeDefinition.getName(), evd.getName());
        } else {
            value = evd.getName();
        }
        return GraphQLEnumValueDefinition.newEnumValueDefinition().name(evd.getName()).value(value).description(description).deprecationReason(deprecation).withDirectives(this.buildDirectives(evd.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.ENUM_VALUE)).build();
    }

    private GraphQLScalarType buildScalar(BuildContext buildCtx, ScalarTypeDefinition typeDefinition) {
        List<ScalarTypeExtensionDefinition> extensions;
        ScalarWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring runtimeWiring = buildCtx.getWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        if (wiringFactory.providesScalar(environment = new ScalarWiringEnvironment(typeRegistry, typeDefinition, extensions = this.scalarTypeExtensions(typeDefinition, buildCtx)))) {
            return wiringFactory.getScalar(environment);
        }
        return buildCtx.getWiring().getScalars().get(typeDefinition.getName());
    }

    private GraphQLFieldDefinition buildField(BuildContext buildCtx, TypeDefinition parentType, FieldDefinition fieldDef) {
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        builder.definition(fieldDef);
        builder.name(fieldDef.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(fieldDef, fieldDef.getDescription()));
        builder.deprecate(this.schemaGeneratorHelper.buildDeprecationReason(fieldDef.getDirectives()));
        GraphQLDirective[] directives = this.buildDirectives(fieldDef.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.FIELD);
        builder.withDirectives(directives);
        fieldDef.getInputValueDefinitions().forEach(inputValueDefinition -> builder.argument(this.buildArgument(buildCtx, (InputValueDefinition)inputValueDefinition)));
        Object fieldType = this.buildOutputType(buildCtx, fieldDef.getType());
        builder.type((GraphQLOutputType)fieldType);
        builder.dataFetcherFactory(this.buildDataFetcherFactory(buildCtx, parentType, fieldDef, (GraphQLOutputType)fieldType, Arrays.asList(directives)));
        return builder.build();
    }

    private DataFetcherFactory buildDataFetcherFactory(BuildContext buildCtx, TypeDefinition parentType, FieldDefinition fieldDef, GraphQLOutputType fieldType, List<GraphQLDirective> directives) {
        DataFetcherFactory dataFetcherFactory;
        FieldWiringEnvironment wiringEnvironment;
        String fieldName = fieldDef.getName();
        String parentTypeName = parentType.getName();
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring runtimeWiring = buildCtx.getWiring();
        WiringFactory wiringFactory = runtimeWiring.getWiringFactory();
        if (wiringFactory.providesDataFetcherFactory(wiringEnvironment = new FieldWiringEnvironment(typeRegistry, parentType, fieldDef, fieldType, directives))) {
            dataFetcherFactory = wiringFactory.getDataFetcherFactory(wiringEnvironment);
            Assert.assertNotNull(dataFetcherFactory, "The WiringFactory indicated it provides a data fetcher factory but then returned null", new Object[0]);
        } else {
            DataFetcher dataFetcher;
            if (wiringFactory.providesDataFetcher(wiringEnvironment)) {
                dataFetcher = wiringFactory.getDataFetcher(wiringEnvironment);
                Assert.assertNotNull(dataFetcher, "The WiringFactory indicated it provides a data fetcher but then returned null", new Object[0]);
            } else {
                dataFetcher = runtimeWiring.getDataFetcherForType(parentTypeName).get(fieldName);
                if (dataFetcher == null && (dataFetcher = runtimeWiring.getDefaultDataFetcherForType(parentTypeName)) == null) {
                    dataFetcher = wiringFactory.getDefaultDataFetcher(wiringEnvironment);
                    Assert.assertNotNull(dataFetcher, "The WiringFactory indicated MUST provide a default data fetcher as part of its contract", new Object[0]);
                }
            }
            dataFetcherFactory = DataFetcherFactories.useDataFetcher(dataFetcher);
        }
        return dataFetcherFactory;
    }

    private GraphQLInputObjectType buildInputObjectType(BuildContext buildCtx, InputObjectTypeDefinition typeDefinition) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject();
        builder.definition(typeDefinition);
        builder.name(typeDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(typeDefinition, typeDefinition.getDescription()));
        List<InputObjectTypeExtensionDefinition> extensions = this.inputObjectTypeExtensions(typeDefinition, buildCtx);
        builder.withDirectives(this.buildDirectives(typeDefinition.getDirectives(), this.directivesOf(extensions), Introspection.DirectiveLocation.INPUT_OBJECT));
        typeDefinition.getInputValueDefinitions().forEach(inputValue -> builder.field(this.buildInputField(buildCtx, (InputValueDefinition)inputValue)));
        extensions.forEach(extension -> extension.getInputValueDefinitions().forEach(inputValueDefinition -> {
            GraphQLInputObjectField inputField = this.buildInputField(buildCtx, (InputValueDefinition)inputValueDefinition);
            if (!builder.hasField(inputField.getName())) {
                builder.field(inputField);
            }
        }));
        return builder.build();
    }

    private GraphQLInputObjectField buildInputField(BuildContext buildCtx, InputValueDefinition fieldDef) {
        GraphQLInputObjectField.Builder fieldBuilder = GraphQLInputObjectField.newInputObjectField();
        fieldBuilder.definition(fieldDef);
        fieldBuilder.name(fieldDef.getName());
        fieldBuilder.description(this.schemaGeneratorHelper.buildDescription(fieldDef, fieldDef.getDescription()));
        GraphQLInputType inputType = this.buildInputType(buildCtx, fieldDef.getType());
        fieldBuilder.type(inputType);
        Value defaultValue = fieldDef.getDefaultValue();
        if (defaultValue != null) {
            fieldBuilder.defaultValue(this.schemaGeneratorHelper.buildValue(defaultValue, inputType));
        }
        fieldBuilder.withDirectives(this.buildDirectives(fieldDef.getDirectives(), Collections.emptyList(), Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION));
        return fieldBuilder.build();
    }

    private GraphQLArgument buildArgument(BuildContext buildCtx, InputValueDefinition valueDefinition) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.definition(valueDefinition);
        builder.name(valueDefinition.getName());
        builder.description(this.schemaGeneratorHelper.buildDescription(valueDefinition, valueDefinition.getDescription()));
        GraphQLInputType inputType = this.buildInputType(buildCtx, valueDefinition.getType());
        builder.type(inputType);
        Value defaultValue = valueDefinition.getDefaultValue();
        if (defaultValue != null) {
            builder.defaultValue(this.schemaGeneratorHelper.buildValue(defaultValue, inputType));
        }
        return builder.build();
    }

    private TypeResolver getTypeResolverForUnion(BuildContext buildCtx, UnionTypeDefinition unionType) {
        TypeResolver typeResolver;
        UnionWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new UnionWiringEnvironment(typeRegistry, unionType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, "The WiringFactory indicated it union provides a type resolver but then returned null", new Object[0]);
        } else {
            typeResolver = wiring.getTypeResolvers().get(unionType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    private TypeResolver getTypeResolverForInterface(BuildContext buildCtx, InterfaceTypeDefinition interfaceType) {
        TypeResolver typeResolver;
        InterfaceWiringEnvironment environment;
        TypeDefinitionRegistry typeRegistry = buildCtx.getTypeRegistry();
        RuntimeWiring wiring = buildCtx.getWiring();
        WiringFactory wiringFactory = wiring.getWiringFactory();
        if (wiringFactory.providesTypeResolver(environment = new InterfaceWiringEnvironment(typeRegistry, interfaceType))) {
            typeResolver = wiringFactory.getTypeResolver(environment);
            Assert.assertNotNull(typeResolver, "The WiringFactory indicated it provides a interface type resolver but then returned null", new Object[0]);
        } else {
            typeResolver = wiring.getTypeResolvers().get(interfaceType.getName());
            if (typeResolver == null) {
                typeResolver = new TypeResolverProxy();
            }
        }
        return typeResolver;
    }

    private GraphQLDirective[] buildDirectives(List<Directive> directives, List<Directive> extensionDirectives, Introspection.DirectiveLocation directiveLocation) {
        directives = directives == null ? Collections.emptyList() : directives;
        extensionDirectives = extensionDirectives == null ? Collections.emptyList() : extensionDirectives;
        HashSet<String> names = new HashSet<String>();
        ArrayList<GraphQLDirective> output = new ArrayList<GraphQLDirective>();
        for (Directive directive : directives) {
            if (names.contains(directive.getName())) continue;
            names.add(directive.getName());
            output.add(this.schemaGeneratorHelper.buildDirective(directive, directiveLocation));
        }
        for (Directive directive : extensionDirectives) {
            if (names.contains(directive.getName())) continue;
            names.add(directive.getName());
            output.add(this.schemaGeneratorHelper.buildDirective(directive, directiveLocation));
        }
        return output.toArray(new GraphQLDirective[0]);
    }

    private List<ObjectTypeExtensionDefinition> objectTypeExtensions(ObjectTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.objectTypeExtensions().get(typeDefinition.getName()));
    }

    private List<InterfaceTypeExtensionDefinition> interfaceTypeExtensions(InterfaceTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.interfaceTypeExtensions().get(typeDefinition.getName()));
    }

    private List<UnionTypeExtensionDefinition> unionTypeExtensions(UnionTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.unionTypeExtensions().get(typeDefinition.getName()));
    }

    private List<EnumTypeExtensionDefinition> enumTypeExtensions(EnumTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.enumTypeExtensions().get(typeDefinition.getName()));
    }

    private List<ScalarTypeExtensionDefinition> scalarTypeExtensions(ScalarTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.scalarTypeExtensions().get(typeDefinition.getName()));
    }

    private List<InputObjectTypeExtensionDefinition> inputObjectTypeExtensions(InputObjectTypeDefinition typeDefinition, BuildContext buildCtx) {
        return this.nvl(buildCtx.typeRegistry.inputObjectTypeExtensions().get(typeDefinition.getName()));
    }

    private <T> List<T> nvl(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    private List<Directive> directivesOf(List<? extends TypeDefinition> typeDefinition) {
        Stream directiveStream = typeDefinition.stream().map(TypeDefinition::getDirectives).filter(Objects::nonNull).flatMap(Collection::stream);
        return directiveStream.collect(Collectors.toList());
    }

    class BuildContext {
        private final TypeDefinitionRegistry typeRegistry;
        private final RuntimeWiring wiring;
        private final Stack<String> definitionStack = new Stack();
        private final Map<String, GraphQLOutputType> outputGTypes = new HashMap<String, GraphQLOutputType>();
        private final Map<String, GraphQLInputType> inputGTypes = new HashMap<String, GraphQLInputType>();

        BuildContext(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) {
            this.typeRegistry = typeRegistry;
            this.wiring = wiring;
        }

        public TypeDefinitionRegistry getTypeRegistry() {
            return this.typeRegistry;
        }

        TypeDefinition getTypeDefinition(Type type) {
            return this.typeRegistry.getType(type).get();
        }

        boolean stackContains(TypeInfo typeInfo) {
            return this.definitionStack.contains(typeInfo.getName());
        }

        void push(TypeInfo typeInfo) {
            this.definitionStack.push(typeInfo.getName());
        }

        void pop() {
            this.definitionStack.pop();
        }

        GraphQLOutputType hasOutputType(TypeDefinition typeDefinition) {
            return this.outputGTypes.get(typeDefinition.getName());
        }

        GraphQLInputType hasInputType(TypeDefinition typeDefinition) {
            return this.inputGTypes.get(typeDefinition.getName());
        }

        void put(GraphQLOutputType outputType) {
            this.outputGTypes.put(outputType.getName(), outputType);
            if (outputType instanceof GraphQLInputType) {
                this.inputGTypes.put(outputType.getName(), (GraphQLInputType)((Object)outputType));
            }
        }

        void put(GraphQLInputType inputType) {
            this.inputGTypes.put(inputType.getName(), inputType);
            if (inputType instanceof GraphQLOutputType) {
                this.outputGTypes.put(inputType.getName(), (GraphQLOutputType)((Object)inputType));
            }
        }

        RuntimeWiring getWiring() {
            return this.wiring;
        }
    }
}

