/*
 * Decompiled with CFR 0.152.
 */
package templates.restkotlin;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.RenderingException;
import com.fizzed.rocker.runtime.DefaultRockerModel;
import com.fizzed.rocker.runtime.DefaultRockerTemplate;
import com.fizzed.rocker.runtime.PlainTextUnloadedClassLoader;
import com.fizzed.rocker.runtime.RockerRuntime;
import java.io.IOException;

public class lightTestServerKt
extends DefaultRockerModel {
    public static final ContentType CONTENT_TYPE = ContentType.RAW;
    public static final String TEMPLATE_NAME = "lightTestServerKt.rocker.raw";
    public static final String TEMPLATE_PACKAGE_NAME = "templates.restkotlin";
    public static final String HEADER_HASH = "-752895709";
    public static final long MODIFIED_AT = 1551528490000L;
    public static final String[] ARGUMENT_NAMES = new String[]{"handlerPackage"};
    private String handlerPackage;

    public lightTestServerKt handlerPackage(String handlerPackage) {
        this.handlerPackage = handlerPackage;
        return this;
    }

    public String handlerPackage() {
        return this.handlerPackage;
    }

    public static lightTestServerKt template(String handlerPackage) {
        return new lightTestServerKt().handlerPackage(handlerPackage);
    }

    @Override
    protected DefaultRockerTemplate buildTemplate() throws RenderingException {
        return RockerRuntime.getInstance().getBootstrap().template(this.getClass(), this);
    }

    private static class PlainText {
        private static final String PLAIN_TEXT_0_0 = "\npackage ";
        private static final String PLAIN_TEXT_1_0 = "\n\nimport assertk.Assert\nimport assertk.assertions.contains\nimport assertk.assertions.isEqualTo\nimport com.networknt.client.Http2Client\nimport com.networknt.server.Server\nimport io.undertow.UndertowOptions\nimport io.undertow.client.ClientCallback\nimport io.undertow.client.ClientExchange\nimport io.undertow.client.ClientRequest\nimport io.undertow.client.ClientResponse\nimport io.undertow.util.FlexBase64\nimport io.undertow.util.Headers\nimport io.undertow.util.HttpString\nimport io.undertow.util.Methods\nimport mu.KotlinLogging\nimport org.junit.jupiter.api.extension.AfterAllCallback\nimport org.junit.jupiter.api.extension.BeforeAllCallback\nimport org.junit.jupiter.api.extension.ExtensionContext\nimport org.xnio.OptionMap\nimport java.io.IOException\nimport java.net.ServerSocket\nimport java.net.URI\nimport java.util.*\nimport java.util.concurrent.CountDownLatch\nimport java.util.concurrent.atomic.AtomicReference\n\n/**\n * Junit5 Extension which sets up a light-server BeforeAll tests and tears it down AfterAll.\n * Use with `@ExtendWith(LightTestServer::class)`\n *\n * The first time a server is started in a particular VM, a random port is assigned to it to avoid clashes between\n * concurrent test runs or other active servers.\n *\n * There are also static utility methods to make requests to the configured server.\n */\nclass LightTestServer() : BeforeAllCallback, AfterAllCallback {\n\n    // EXTENSION LIFE-CYCLE METHODS\n\n    var oldIsDynamicPort: Boolean? = null\n    var oldHttpsPort: Int? = null\n\n    // Patch Server.config and start server\n    override fun beforeAll(context: ExtensionContext?) {\n        oldIsDynamicPort = Server.config.isDynamicPort\n        oldHttpsPort = Server.config.httpsPort\n        Server.config.isDynamicPort = false\n        Server.config.httpsPort = httpsPort\n        Server.start()\n    }\n\n    // Stop server and unpatch config\n    override fun afterAll(context: ExtensionContext?) {\n        Server.stop()\n        Server.config.isDynamicPort = oldIsDynamicPort!!\n        Server.config.httpsPort = oldHttpsPort!!\n    }\n\n    companion object {\n\n        val log = KotlinLogging.logger {}\n\n        // SERVER STATE\n\n        val httpsPort = randomFreePort(40000, 60000)\n        val baseUrl = \"https://localhost:$httpsPort\"\n\n\n        // MAKE REQUESTS TO SERVER\n\n        /** Make a GET request to the server maintained by this extension. */\n        fun makeGetRequest(path: String, auth: String? = null): ClientResponse {\n            return makeRequest(path, Methods.GET, null, auth)\n        }\n\n        /** Make a POST request to the server maintained by this extension. */\n        fun makePostRequest(path: String, body: String, auth: String? = null): ClientResponse {\n            return makeRequest(path, Methods.POST, body, auth)\n        }\n\n        /** Make a PUT request to the server maintained by this extension. */\n        fun makePutRequest(path: String, body: String, auth: String? = null): ClientResponse {\n            return makeRequest(path, Methods.PUT, body, auth)\n        }\n\n        /** Make a DELETE request to the server maintained by this extension. */\n        fun makeDeleteRequest(path: String, auth: String? = null): ClientResponse {\n            return makeRequest(path, Methods.DELETE, null, auth)\n        }\n\n        /** Finds a random free port by attempting to listen on random ports until it succeeds. */\n        fun randomFreePort(minPort: Int, maxPort: Int): Int {\n            val random = Random()\n            while (true) {\n                val port = random.nextInt(maxPort - minPort) + minPort\n                try {\n                    val ss = ServerSocket(port)\n                    ss.close()\n                    return port\n                } catch (e: IOException) {\n                    log.info { \"Port ${port} was busy\" }\n                }\n            }\n        }\n\n        /** Make a request to the server maintained by this extension. */\n        fun makeRequest(path: String, method: HttpString, body: String?, auth: String? = null): ClientResponse {\n            log.info { \"${method} :: $baseUrl :: ${path}\" }\n\n            val client = Http2Client.getInstance()\n\n            client.connect(\n                URI(baseUrl),\n                Http2Client.WORKER,\n                Http2Client.SSL,\n                Http2Client.BUFFER_POOL,\n                OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)\n            ).get().use { connection ->\n\n                val request = ClientRequest().setPath(path).setMethod(method)\n                authenticate(request, auth)\n                val latch = CountDownLatch(1)\n                val reference = AtomicReference<ClientResponse>()\n                val callback: ClientCallback<ClientExchange>\n\n                if (body == null) {\n                    callback = client.createClientCallback(reference, latch)\n                } else {\n                    log.info { \"body: ${body}\" }\n                    val firstChar = if (body.length > 0) body[0] else '\\u0000'\n                    if (firstChar == '[' || firstChar == '{') {\n                        request.requestHeaders.put(Headers.CONTENT_TYPE, \"application/json\")\n                    } else {\n                        request.requestHeaders.put(Headers.CONTENT_TYPE, \"text/plain\")\n                    }\n                    request.requestHeaders.put(Headers.TRANSFER_ENCODING, \"chunked\")\n                    callback = client.createClientCallback(reference, latch, body)\n                }\n\n                connection.sendRequest(request, callback)\n                latch.await()\n\n                val response = reference.get()\n                log.info { \"Response code = ${response.responseCode}\" }\n                log.info { \"Response body = ${response.getAttachment(Http2Client.RESPONSE_BODY)}\" }\n                return response\n            }\n\n        }\n\n        private fun authenticate(request: ClientRequest, auth: String?) {\n            if (auth == null) return\n\n            log.info { \"auth = ${auth}\" }\n            val bytes = auth.toByteArray(Charsets.UTF_8)\n            log.info { \"bytes = ${bytes}\" }\n            val encoded = FlexBase64.encodeString(bytes, false)\n            log.info { \"encoded = ${encoded}\" }\n            request.requestHeaders.add(\n                Headers.AUTHORIZATION,\n                \"Basic ${encoded}\"\n            )\n        }\n    }\n}\n\nfun Assert<ClientResponse>.rcIsEqualTo(expected: Int) = given { actual ->\n    assertThat(actual.responseCode, \"Response Code\").isEqualTo(expected)\n}\n\nfun Assert<ClientResponse>.bodyIsEqualTo(expected: String) = given { actual ->\n    assertThat(actual.getAttachment(com.networknt.client.Http2Client.RESPONSE_BODY), \"Body\").isEqualTo(expected)\n}\n\nfun Assert<ClientResponse>.bodyContains(expected: String)  = given { actual ->\n    assertThat(actual.getAttachment(com.networknt.client.Http2Client.RESPONSE_BODY), \"Body\").contains(expected)\n}\n";

        private PlainText() {
        }
    }

    public static class Template
    extends DefaultRockerTemplate {
        private static final byte[] PLAIN_TEXT_0_0;
        private static final byte[] PLAIN_TEXT_1_0;
        protected final String handlerPackage;

        public Template(lightTestServerKt model2) {
            super(model2);
            this.__internal.setCharset("UTF-8");
            this.__internal.setContentType(CONTENT_TYPE);
            this.__internal.setTemplateName(lightTestServerKt.TEMPLATE_NAME);
            this.__internal.setTemplatePackageName(lightTestServerKt.TEMPLATE_PACKAGE_NAME);
            this.handlerPackage = model2.handlerPackage();
        }

        @Override
        protected void __doRender() throws IOException, RenderingException {
            this.__internal.aboutToExecutePosInTemplate(1, 30);
            this.__internal.writeValue(PLAIN_TEXT_0_0);
            this.__internal.aboutToExecutePosInTemplate(2, 9);
            this.__internal.renderValue(this.handlerPackage, false);
            this.__internal.aboutToExecutePosInTemplate(2, 24);
            this.__internal.writeValue(PLAIN_TEXT_1_0);
        }

        static {
            PlainTextUnloadedClassLoader loader = PlainTextUnloadedClassLoader.tryLoad(lightTestServerKt.class.getClassLoader(), lightTestServerKt.class.getName() + "$PlainText", "UTF-8");
            PLAIN_TEXT_0_0 = loader.tryGet("PLAIN_TEXT_0_0");
            PLAIN_TEXT_1_0 = loader.tryGet("PLAIN_TEXT_1_0");
        }
    }
}

