/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.codegen.CodegenWebConfig;
import com.networknt.codegen.FrameworkRegistry;
import com.networknt.codegen.Generator;
import com.networknt.codegen.Utils;
import com.networknt.config.Config;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/codegen/multiple/0.0.1")
public class CodegenMultipleHandler
implements HybridHandler {
    private static final String CONFIG_NAME = "codegen-web";
    private static final String STATUS_INVALID_FRAMEWORK = "ERR11100";
    private static final String STATUS_MISSING_GENERATOR_ITEM = "ERR11101";
    private static final String STATUS_INVALID_MODEL_URL = "ERR11103";
    private static final String STATUS_INVALID_CONFIG_JSON = "ERR11104";
    private static final String STATUS_INVALID_CONFIG_URL_EXTENSION = "ERR11105";
    private static final String STATUS_GENERATOR_EXCEPTION = "ERR11106";
    private static final String STATUS_COMPRESSION_EXCEPTION = "ERR11107";
    private static final Logger logger = LoggerFactory.getLogger(CodegenMultipleHandler.class);
    private static CodegenWebConfig codegenWebConfig = (CodegenWebConfig)Config.getInstance().getJsonObjectConfig("codegen-web", CodegenWebConfig.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        String output = UuidUtil.uuidToBase64((UUID)UuidUtil.getUUID());
        String zipFile = output + ".zip";
        String projectFolder = codegenWebConfig.getTmpFolder() + File.separator + output;
        List generators = (List)((Map)input).get("generators");
        if (generators == null || generators.size() == 0) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, STATUS_MISSING_GENERATOR_ITEM, new Object[0]));
        }
        try {
            for (Map generatorMap : generators) {
                String framework = (String)generatorMap.get("framework");
                if (!FrameworkRegistry.getInstance().getFrameworks().contains(framework)) {
                    return NioUtils.toByteBuffer((String)this.getStatus(exchange, STATUS_INVALID_FRAMEWORK, new Object[]{framework}));
                }
                String modelType = (String)generatorMap.get("modelType");
                Object model = null;
                if ("C".equals(modelType)) {
                    String modelText = (String)generatorMap.get("modelText");
                    model = "light-graphql-4j".equals(framework) ? modelText : (modelText.startsWith("{") || modelText.startsWith("[") ? Generator.jsonMapper.readTree(modelText) : Generator.yamlMapper.readTree(modelText));
                } else if ("U".equals(modelType)) {
                    String modelUrl = (String)generatorMap.get("modelUrl");
                    if (Utils.isUrl((String)modelUrl)) {
                        model = modelUrl.endsWith(".json") ? Generator.jsonMapper.readTree(Utils.urlToByteArray((URL)new URL(modelUrl))) : (modelUrl.endsWith(".yml") || modelUrl.endsWith(".yaml") ? Generator.yamlMapper.readTree(Utils.urlToByteArray((URL)new URL(modelUrl))) : new String(Utils.urlToByteArray((URL)new URL(modelUrl)), StandardCharsets.UTF_8));
                    } else {
                        return NioUtils.toByteBuffer((String)this.getStatus(exchange, STATUS_INVALID_MODEL_URL, new Object[]{modelUrl}));
                    }
                }
                String configType = (String)generatorMap.get("configType");
                JsonNode config = null;
                if ("C".equals(configType)) {
                    String configText = (String)generatorMap.get("configText");
                    config = (configText = configText.trim()).startsWith("{") || configText.startsWith("[") ? Generator.jsonMapper.readTree(configText) : Generator.yamlMapper.readTree(configText);
                } else if ("U".equals(configType)) {
                    String configUrl = (String)generatorMap.get("configUrl");
                    if ((configUrl = configUrl.trim()).endsWith(".json")) {
                        config = Generator.jsonMapper.readTree(Utils.urlToByteArray((URL)new URL(configUrl)));
                    } else if (configUrl.endsWith(".yml") || configUrl.endsWith(".yaml")) {
                        config = Generator.yamlMapper.readTree(Utils.urlToByteArray((URL)new URL(configUrl)));
                    } else {
                        return NioUtils.toByteBuffer((String)this.getStatus(exchange, STATUS_INVALID_CONFIG_URL_EXTENSION, new Object[]{configUrl}));
                    }
                }
                Generator generator = FrameworkRegistry.getInstance().getGenerator(framework);
                generator.generate(projectFolder, model, config);
            }
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, STATUS_GENERATOR_EXCEPTION, new Object[]{e.getMessage()}));
        }
        try {
            NioUtils.create((String)(codegenWebConfig.getZipFolder() + File.separator + zipFile), (String[])new String[]{projectFolder});
            Files.walk(Paths.get(projectFolder, new String[0]), FileVisitOption.FOLLOW_LINKS).sorted(Comparator.reverseOrder()).map(Path::toFile).peek(System.out::println).forEach(File::delete);
            NioUtils.deleteOldFiles((String)codegenWebConfig.getZipFolder(), (int)codegenWebConfig.getZipKeptMinute());
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, STATUS_COMPRESSION_EXCEPTION, new Object[]{e.getMessage()}));
        }
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "application/zip").add(new HttpString("Content-Disposition"), "attachment");
        File file = new File(codegenWebConfig.getZipFolder() + File.separator + zipFile);
        return NioUtils.toByteBuffer((File)file);
    }
}

